/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl.connection.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.webswing.model.SyncObjectResponse;
import org.webswing.model.app.in.ServerToAppFrameMsgIn;
import org.webswing.model.app.out.AppHandshakeMsgOut;
import org.webswing.model.app.out.AppToServerFrameMsgOut;
import org.webswing.model.appframe.in.AppFrameMsgIn;
import org.webswing.server.common.util.JwtUtil;
import org.webswing.services.impl.connection.ServerConnection;
import org.webswing.toolkit.util.Util;
import org.webswing.util.AppLogger;
import org.webswing.util.ClassLoaderUtil;
import org.webswing.util.ProtoMapper;

@ClientEndpoint
public class AppWebsocketConnectionImpl
implements ServerConnection {
    private static int MAX_RECONNECT_RETRIES = 5;
    private static int maxMessageSize = Integer.getInteger("webswing.websocketMessageSizeLimit", 0x100000);
    private static long syncTimeout = Long.getLong("webswing.syncCallTimeout", 3000L);
    private ProtoMapper protoMapper = new ProtoMapper("org.webswing.model.app.proto.ServerAppFrameProto", "org.webswing.model.app.proto.ServerAppFrameProto", ClassLoaderUtil.getServiceClassLoader());
    private String serverUrl;
    private ServerConnection.MessageListener messageListener;
    private Session session;
    private ByteArrayOutputStream partialMsg = new ByteArrayOutputStream();
    private Map<String, SyncObjectResponse> syncCallResposeMap = Collections.synchronizedMap(new ConcurrentHashMap());
    private Timer reconnectTimer = new Timer(true);
    private AtomicBoolean reconnectScheduled = new AtomicBoolean(false);
    private AtomicBoolean interruptReconnect = new AtomicBoolean(false);
    private WebSocketContainer container;

    @Override
    public void initialize(String serverUrl, ServerConnection.MessageListener messageListener) throws Exception {
        this.serverUrl = serverUrl;
        this.messageListener = messageListener;
        this.resetTimer();
        this.connect();
    }

    private void connect() throws Exception {
        if (this.reconnectScheduled.get()) {
            this.resetTimer();
        }
        AppLogger.info((String)("Starting websocket connection to server [" + this.serverUrl + "]."), (Object[])new Object[0]);
        try {
            if (this.container == null) {
                this.container = ContainerProvider.getWebSocketContainer();
            }
            this.container.connectToServer((Object)this, URI.create(this.serverUrl));
        }
        catch (Exception e) {
            AppLogger.error((String)("Failed to connect websocket to server [" + this.serverUrl + "]!"), (Object[])new Object[]{e});
            throw e;
        }
    }

    @OnOpen
    public void onOpen(Session session) throws Exception {
        AppLogger.info((String)("Websocket connection opened to server [" + this.serverUrl + "]."), (Object[])new Object[0]);
        this.session = session;
        session.setMaxBinaryMessageBufferSize(maxMessageSize);
        AppHandshakeMsgOut handshake = new AppHandshakeMsgOut();
        try {
            String secretMessage = JwtUtil.createHandshakeToken();
            handshake.setSecretMessage(secretMessage);
        }
        catch (Exception e) {
            AppLogger.error((String)"Could not create secret message! Disconnecting...", (Object[])new Object[]{e});
            this.disconnect((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Connection not secured!");
            throw e;
        }
        AppToServerFrameMsgOut msgOut = new AppToServerFrameMsgOut();
        msgOut.setHandshake(handshake);
        this.sendMessage(msgOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(Session session, byte[] bytes, boolean last) {
        if (bytes == null) {
            return;
        }
        try {
            ServerToAppFrameMsgIn msgIn;
            this.partialMsg.write(bytes);
            if (last && (msgIn = this.protoMapper.decodeProto(this.partialMsg.toByteArray(), ServerToAppFrameMsgIn.class)) != null) {
                this.messageListener.onMessage(msgIn);
            }
        }
        catch (IOException e) {
            AppLogger.error((String)("Could not decode proto message from server [" + this.serverUrl + "]!"), (Object[])new Object[]{e});
        }
        finally {
            if (last) {
                try {
                    this.partialMsg.close();
                }
                catch (IOException iOException) {}
                this.partialMsg = new ByteArrayOutputStream();
            }
        }
    }

    @OnClose
    public void onClose(CloseReason closeReason) {
        AppLogger.error((String)("Websocket closed to server [" + this.serverUrl + "]" + (closeReason != null ? ", close code [" + closeReason.getCloseCode().getCode() + "], reason [" + closeReason.getReasonPhrase() + "]!" : "")), (Object[])new Object[0]);
        this.scheduleReconnect(0);
    }

    private void scheduleReconnect(final int retry) {
        if (retry >= MAX_RECONNECT_RETRIES) {
            return;
        }
        if (this.reconnectScheduled.get()) {
            this.resetTimer();
        } else {
            this.interruptReconnect.set(false);
        }
        this.reconnectTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                AppWebsocketConnectionImpl.this.reconnectScheduled.set(false);
                if (AppWebsocketConnectionImpl.this.interruptReconnect.get()) {
                    AppWebsocketConnectionImpl.this.interruptReconnect.set(false);
                    return;
                }
                try {
                    AppWebsocketConnectionImpl.this.connect();
                }
                catch (Exception e) {
                    AppWebsocketConnectionImpl.this.scheduleReconnect(retry + 1);
                }
            }
        }, 1000L);
    }

    private void resetTimer() {
        this.reconnectTimer.cancel();
        this.reconnectTimer = new Timer(true);
        this.interruptReconnect.set(true);
    }

    @OnError
    public void onError(Session session, Throwable t) {
        AppLogger.error((String)("Websocket error on server [" + this.serverUrl + "]!"), (Object[])new Object[]{t});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSyncMessageResult(ServerToAppFrameMsgIn msgIn, AppFrameMsgIn frame) {
        String correlationId = null;
        if (msgIn.getApiCallResult() != null && msgIn.getApiCallResult().getCorrelationId() != null) {
            correlationId = msgIn.getApiCallResult().getCorrelationId();
        } else if (frame.getJsResponse() != null && frame.getJsResponse().getCorrelationId() != null) {
            correlationId = frame.getJsResponse().getCorrelationId();
        } else if (frame.getJavaRequest() != null && frame.getJavaRequest().getCorrelationId() != null) {
            correlationId = frame.getJavaRequest().getCorrelationId();
        }
        if (this.syncCallResposeMap.containsKey(correlationId)) {
            SyncObjectResponse syncObject = this.syncCallResposeMap.get(correlationId);
            this.syncCallResposeMap.put(correlationId, new SyncObjectResponse(msgIn, frame));
            SyncObjectResponse syncObjectResponse = syncObject;
            synchronized (syncObjectResponse) {
                syncObject.notifyAll();
            }
        } else {
            AppLogger.warn((String)("No thread waiting for sync-ed message with id " + correlationId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(AppToServerFrameMsgOut msgOut) {
        if (this.session == null || !this.session.isOpen()) {
            AppLogger.error((String)"Cannot send message, session closed!", (Object[])new Object[0]);
            return;
        }
        if (Util.getWebToolkit().isRecording() && msgOut.getAppFrameMsgOut() != null) {
            Util.getWebToolkit().recordFrame(msgOut.getAppFrameMsgOut());
        }
        Session session = this.session;
        synchronized (session) {
            try {
                byte[] encoded = this.protoMapper.encodeProto((Serializable)msgOut);
                int length = encoded.length;
                if (length > maxMessageSize) {
                    int sendLength;
                    for (int sent = 0; sent != length; sent += sendLength) {
                        sendLength = sent + maxMessageSize > length ? length - sent : maxMessageSize;
                        this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(encoded, sent, sendLength), sent + sendLength == length);
                    }
                } else {
                    this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(encoded));
                }
            }
            catch (IOException e) {
                AppLogger.error((String)("Error sending msg to server [" + this.serverUrl + "] , session [" + this.session.getId() + "]"), (Object[])new Object[]{e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncObjectResponse sendMessageSync(AppToServerFrameMsgOut msgOut, String correlationId) throws TimeoutException {
        SyncObjectResponse syncObject = new SyncObjectResponse();
        this.syncCallResposeMap.put(correlationId, syncObject);
        this.sendMessage(msgOut);
        SyncObjectResponse response = null;
        try {
            SyncObjectResponse syncObjectResponse = syncObject;
            synchronized (syncObjectResponse) {
                if (this.syncCallResposeMap.get(correlationId) == syncObject) {
                    syncObject.wait(syncTimeout);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        response = this.syncCallResposeMap.get(correlationId);
        this.syncCallResposeMap.remove(correlationId);
        if (response == syncObject) {
            throw new TimeoutException("Call timed out after " + syncTimeout + " ms. Call id " + correlationId);
        }
        return response;
    }

    @Override
    public void close() {
        this.close("Closing connection. Application shutdown.");
    }

    @Override
    public void close(String reason) {
        this.disconnect((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, reason);
    }

    private void disconnect(CloseReason.CloseCode closeCode, String reason) {
        AppLogger.info((String)("Disconnecting websocket to server [" + this.serverUrl + "]."), (Object[])new Object[0]);
        if (this.session != null && this.session.isOpen()) {
            try {
                this.session.close(new CloseReason(closeCode, reason));
            }
            catch (IOException e) {
                AppLogger.error((String)("Failed to destroy websocket connection, session [" + this.session.getId() + "]!"), (Object[])new Object[]{e});
            }
        }
    }
}

