/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.theme;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.webswing.common.WindowActionType;
import org.webswing.common.WindowDecoratorTheme;
import org.webswing.model.appframe.out.AccessibilityMsgOut;
import org.webswing.toolkit.api.component.Dockable;
import org.webswing.toolkit.util.Util;
import org.webswing.util.AppLogger;

public class DefaultWindowDecoratorTheme
implements WindowDecoratorTheme {
    private static final String DEFAULT_THEME = "Murrine";
    Insets insets = new Insets(0, 0, 0, 0);
    private String theme = System.getProperty("webswing.theme", "Murrine");
    private Properties themeProperties;
    private ImageSet active;
    private ImageSet inactive;
    public int BUTTON_OFFSET = 7;
    public int BUTTON_SPACING = 4;
    public int TITLE_HORIZONTAL_OFFSET = 0;

    public DefaultWindowDecoratorTheme() {
        try {
            this.init();
        }
        catch (Exception e) {
            AppLogger.error((String)("Could not load theme " + this.theme + ". Falling back to default theme " + DEFAULT_THEME), (Object[])new Object[]{e});
            this.theme = DEFAULT_THEME;
            try {
                this.init();
            }
            catch (IOException e1) {
                AppLogger.fatal((String)"Could not load default theme:", (Object[])new Object[]{e1});
            }
        }
    }

    private void init() throws IOException {
        this.themeProperties = this.readProperties();
        this.active = new ImageSet(){
            {
                this.TOP_LEFT = DefaultWindowDecoratorTheme.this.readImage("top-left-active");
                this.TITLE = DefaultWindowDecoratorTheme.this.readImage("title-1-active");
                this.MENU = DefaultWindowDecoratorTheme.this.readImage("menu-active");
                this.UNDOCK = DefaultWindowDecoratorTheme.this.readImage("shade-active");
                this.DOCK = DefaultWindowDecoratorTheme.this.readImage("stick-active");
                this.HIDE = DefaultWindowDecoratorTheme.this.readImage("hide-active");
                this.MAXIMIZE = DefaultWindowDecoratorTheme.this.readImage("maximize-active");
                this.CLOSE = DefaultWindowDecoratorTheme.this.readImage("close-active");
                this.TOP_RIGHT = DefaultWindowDecoratorTheme.this.readImage("top-right-active");
                this.LEFT = DefaultWindowDecoratorTheme.this.readImage("left-active");
                this.RIGHT = DefaultWindowDecoratorTheme.this.readImage("right-active");
                this.BOTTOM_LEFT = DefaultWindowDecoratorTheme.this.readImage("bottom-left-active");
                this.BOTTOM = DefaultWindowDecoratorTheme.this.readImage("bottom-active");
                this.BOTTOM_RIGHT = DefaultWindowDecoratorTheme.this.readImage("bottom-right-active");
                this.TEXT_COLOR = Color.decode(DefaultWindowDecoratorTheme.this.themeProperties.getProperty("active_text_color", "#000000"));
                this.TEXT_SHADOW_COLOR = Color.decode(DefaultWindowDecoratorTheme.this.themeProperties.getProperty("active_text_shadow_color", "#111111"));
            }
        };
        this.inactive = new ImageSet(){
            {
                this.TOP_LEFT = DefaultWindowDecoratorTheme.this.readImage("top-left-inactive");
                this.TITLE = DefaultWindowDecoratorTheme.this.readImage("title-1-inactive");
                this.MENU = DefaultWindowDecoratorTheme.this.readImage("menu-inactive");
                this.UNDOCK = DefaultWindowDecoratorTheme.this.readImage("shade-inactive");
                this.DOCK = DefaultWindowDecoratorTheme.this.readImage("stick-inactive");
                this.HIDE = DefaultWindowDecoratorTheme.this.readImage("hide-inactive");
                this.MAXIMIZE = DefaultWindowDecoratorTheme.this.readImage("maximize-inactive");
                this.CLOSE = DefaultWindowDecoratorTheme.this.readImage("close-inactive");
                this.TOP_RIGHT = DefaultWindowDecoratorTheme.this.readImage("top-right-inactive");
                this.LEFT = DefaultWindowDecoratorTheme.this.readImage("left-inactive");
                this.RIGHT = DefaultWindowDecoratorTheme.this.readImage("right-inactive");
                this.BOTTOM_LEFT = DefaultWindowDecoratorTheme.this.readImage("bottom-left-inactive");
                this.BOTTOM = DefaultWindowDecoratorTheme.this.readImage("bottom-inactive");
                this.BOTTOM_RIGHT = DefaultWindowDecoratorTheme.this.readImage("bottom-right-inactive");
                this.TEXT_COLOR = Color.decode(DefaultWindowDecoratorTheme.this.themeProperties.getProperty("inactive_text_color", "#000000"));
                this.TEXT_SHADOW_COLOR = Color.decode(DefaultWindowDecoratorTheme.this.themeProperties.getProperty("inactive_text_shadow_color", "#111111"));
            }
        };
        this.insets = new Insets(this.active.TITLE.getHeight(), this.active.LEFT.getWidth(), this.active.BOTTOM.getHeight(), this.active.RIGHT.getWidth());
    }

    protected Properties readProperties() throws IOException {
        Properties properies = new Properties();
        ClassLoader classLoader = DefaultWindowDecoratorTheme.class.getClassLoader();
        URL resource = classLoader.getResource("themes/" + this.theme + "/xfwm4/themerc");
        if (resource == null) {
            resource = new File(this.theme + "/themerc").toURI().toURL();
        }
        if (resource == null) {
            throw new IOException("File " + this.theme + "/themerc does not exist.");
        }
        properies.load(resource.openStream());
        return properies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage readImage(String key) throws IOException {
        File localFile;
        ClassLoader classLoader = DefaultWindowDecoratorTheme.class.getClassLoader();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        Graphics2D g = null;
        BufferedImage bimage = null;
        InputStream is = classLoader.getResourceAsStream("themes/" + this.theme + "/xfwm4/" + key + "_xpm.png");
        if (is == null && (localFile = new File(this.theme + "/" + key + "_xpm.png")).exists()) {
            is = new FileInputStream(localFile);
        }
        if (is != null) {
            try {
                BufferedImage xpm = ImageIO.read(is);
                bimage = gc.createCompatibleImage(((Image)xpm).getWidth(null), ((Image)xpm).getHeight(null), 2);
                g = bimage.createGraphics();
                g.drawImage((Image)xpm, 0, 0, null);
            }
            catch (Exception e) {
                AppLogger.debug((String)("Exception while reading theme file " + key + " for theme " + this.theme), (Object[])new Object[]{e});
            }
            finally {
                is.close();
            }
        }
        if ((is = classLoader.getResourceAsStream("themes/" + this.theme + "/xfwm4/" + key + ".png")) == null && (localFile = new File(this.theme + "/" + key + ".png")).exists()) {
            is = new FileInputStream(localFile);
        }
        if (is != null) {
            try {
                BufferedImage png = ImageIO.read(is);
                if (g == null) {
                    bimage = gc.createCompatibleImage(((Image)png).getWidth(null), ((Image)png).getHeight(null), 2);
                    g = bimage.createGraphics();
                }
                g.drawImage((Image)png, 0, 0, null);
            }
            catch (Exception e) {
                AppLogger.debug((String)("Exception while reading theme file " + key + " for theme " + this.theme), (Object[])new Object[]{e});
            }
            finally {
                is.close();
            }
        }
        return bimage;
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public void paintWindowDecoration(Graphics g, Object window, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ImageSet is = window != null && window.equals(Util.getWebToolkit().getWindowManager().getActiveWindow()) ? this.active : this.inactive;
        int xOffset = 0;
        int yOffset = 0;
        int x = xOffset;
        int y = yOffset + is.TITLE.getHeight();
        int effectiveH = h - is.TOP_LEFT.getHeight() - is.BOTTOM_LEFT.getHeight();
        g.drawImage(is.LEFT, x, y, is.LEFT.getWidth(), effectiveH, null);
        g.drawImage(is.RIGHT, xOffset + w - is.RIGHT.getWidth(), y, is.RIGHT.getWidth(), effectiveH, null);
        x = xOffset + is.TOP_LEFT.getWidth();
        y = yOffset;
        int effectiveW = w - is.TOP_LEFT.getWidth() - is.TOP_RIGHT.getWidth();
        g.drawImage(is.TITLE, x, y, effectiveW, is.TITLE.getHeight(), null);
        x = xOffset + is.BOTTOM_LEFT.getWidth();
        y = yOffset + h;
        effectiveW = w - is.BOTTOM_LEFT.getWidth() - is.BOTTOM_RIGHT.getWidth();
        g.drawImage(is.BOTTOM, x, y - is.BOTTOM.getHeight(), effectiveW, is.BOTTOM.getHeight(), null);
        x = xOffset;
        y = yOffset;
        g.drawImage(is.TOP_LEFT, x, y, null);
        g.drawImage(is.TOP_RIGHT, xOffset + w - is.TOP_RIGHT.getWidth(), y, null);
        g.drawImage(is.MENU, x += is.TOP_LEFT.getWidth() + this.BUTTON_SPACING, y + (is.TITLE.getHeight() - is.MENU.getHeight()) / 2, null);
        Rectangle menuRect = new Rectangle(x, y + (is.TITLE.getHeight() - is.MENU.getHeight()) / 2, is.MENU.getWidth(), is.MENU.getHeight());
        g.drawImage(DefaultWindowDecoratorTheme.getIcon(window), menuRect.x, menuRect.y, menuRect.width, menuRect.height, null);
        String title = DefaultWindowDecoratorTheme.getTitle(window) == null ? "" : DefaultWindowDecoratorTheme.getTitle(window);
        g.setFont(UIManager.getFont("TitledBorder.font").deriveFont(0, 12.0f));
        float lineMetricsHeight = g.getFontMetrics().getLineMetrics(title, g).getHeight();
        g.setColor(is.TEXT_COLOR);
        g.drawString(title, x += is.MENU.getWidth() + this.BUTTON_SPACING, y + (is.TITLE.getHeight() - (int)lineMetricsHeight) / 2 + (int)lineMetricsHeight);
        x = xOffset + w - this.BUTTON_SPACING;
        boolean firstButton = true;
        if (this.isCloseButtonVisible(window)) {
            g.drawImage(is.CLOSE, x -= is.CLOSE.getWidth(), y + (is.TITLE.getHeight() - is.CLOSE.getHeight()) / 2, null);
            firstButton = false;
        }
        if (this.isMinMaxButtonVisible(window)) {
            g.drawImage(is.MAXIMIZE, x -= (firstButton ? 0 : this.BUTTON_SPACING) + is.MAXIMIZE.getWidth(), y + (is.TITLE.getHeight() - is.MAXIMIZE.getHeight()) / 2, null);
            g.drawImage(is.HIDE, x -= this.BUTTON_SPACING + is.HIDE.getWidth(), y + (is.TITLE.getHeight() - is.HIDE.getHeight()) / 2, null);
            firstButton = false;
        }
        if (this.isDockButtonVisible(window) && window instanceof Window) {
            boolean undocked = Util.isWindowUndocked((Window)((Window)window));
            BufferedImage img = undocked ? is.DOCK : is.UNDOCK;
            g.drawImage(img, x -= (firstButton ? 0 : this.BUTTON_SPACING) + img.getWidth(), y + (is.TITLE.getHeight() - img.getHeight()) / 2, null);
            firstButton = false;
        }
        x = xOffset;
        y = yOffset + h;
        g.drawImage(is.BOTTOM_LEFT, x, y - is.BOTTOM_LEFT.getHeight(), null);
        g.drawImage(is.BOTTOM_RIGHT, xOffset + w - is.BOTTOM_RIGHT.getWidth(), y - is.BOTTOM_RIGHT.getHeight(), null);
        this.insets = new Insets(is.TITLE.getHeight(), is.LEFT.getWidth(), is.BOTTOM.getHeight(), is.RIGHT.getWidth());
    }

    private Rectangle getDockUndockRect(Window w) {
        ImageSet is = w != null && w.equals(Util.getWebToolkit().getWindowManager().getActiveWindow()) ? this.active : this.inactive;
        boolean undocked = Util.isWindowUndocked((Window)w);
        BufferedImage img = undocked ? is.DOCK : is.UNDOCK;
        int x = w.getWidth() - this.BUTTON_SPACING - img.getWidth();
        if (this.isCloseButtonVisible(w)) {
            x = x - this.BUTTON_SPACING - is.CLOSE.getWidth();
        }
        if (this.isMinMaxButtonVisible(w)) {
            x = x - this.BUTTON_SPACING - is.MAXIMIZE.getWidth() - this.BUTTON_SPACING - is.HIDE.getWidth();
        }
        return new Rectangle(x, 0 + (is.TITLE.getHeight() - img.getHeight()) / 2, img.getWidth(), img.getHeight());
    }

    private Rectangle getHideRect(Window w) {
        ImageSet is = w != null && w.equals(Util.getWebToolkit().getWindowManager().getActiveWindow()) ? this.active : this.inactive;
        int x = w.getWidth() - this.BUTTON_SPACING - is.MAXIMIZE.getWidth() - this.BUTTON_SPACING - is.HIDE.getWidth();
        if (this.isCloseButtonVisible(w)) {
            x = x - this.BUTTON_SPACING - is.CLOSE.getWidth();
        }
        return new Rectangle(x, 0 + (is.TITLE.getHeight() - is.HIDE.getHeight()) / 2, is.HIDE.getWidth(), is.HIDE.getHeight());
    }

    private Rectangle getMaximizeRect(Window w) {
        ImageSet is = w != null && w.equals(Util.getWebToolkit().getWindowManager().getActiveWindow()) ? this.active : this.inactive;
        int x = w.getWidth() - this.BUTTON_SPACING - is.MAXIMIZE.getWidth();
        if (this.isCloseButtonVisible(w)) {
            x = x - this.BUTTON_SPACING - is.CLOSE.getWidth();
        }
        return new Rectangle(x, 0 + (is.TITLE.getHeight() - is.MAXIMIZE.getHeight()) / 2, is.MAXIMIZE.getWidth(), is.MAXIMIZE.getHeight());
    }

    private Rectangle getCloseRect(Window w) {
        ImageSet is = w != null && w.equals(Util.getWebToolkit().getWindowManager().getActiveWindow()) ? this.active : this.inactive;
        int x = w.getWidth() - this.BUTTON_SPACING - is.CLOSE.getWidth();
        return new Rectangle(x, 0 + (is.TITLE.getHeight() - is.CLOSE.getHeight()) / 2, is.CLOSE.getWidth(), is.CLOSE.getHeight());
    }

    private static String getTitle(Object o) {
        if (o instanceof Frame) {
            return ((Frame)o).getTitle();
        }
        if (o instanceof Dialog) {
            return ((Dialog)o).getTitle();
        }
        return null;
    }

    private static Image getIcon(Object o) {
        List<Image> images;
        if (o instanceof Frame) {
            return ((Frame)o).getIconImage();
        }
        if (o instanceof Dialog && (images = ((Dialog)o).getIconImages()).size() > 0) {
            return images.get(0);
        }
        return null;
    }

    public WindowActionType getAction(Window w, Point e) {
        Rectangle eventPoint = new Rectangle((int)e.getX(), (int)e.getY(), 1, 1);
        Insets i = w.getInsets();
        if (this.isDockButtonVisible(w) && SwingUtilities.isRectangleContainingRectangle(this.getDockUndockRect(w), eventPoint)) {
            return Util.isWindowUndocked((Window)w) ? WindowActionType.dock : WindowActionType.undock;
        }
        if (this.isMinMaxButtonVisible(w)) {
            if (SwingUtilities.isRectangleContainingRectangle(this.getHideRect(w), eventPoint)) {
                return WindowActionType.minimize;
            }
            if (SwingUtilities.isRectangleContainingRectangle(this.getMaximizeRect(w), eventPoint)) {
                return WindowActionType.maximize;
            }
        }
        if (this.isCloseButtonVisible(w) && SwingUtilities.isRectangleContainingRectangle(this.getCloseRect(w), eventPoint)) {
            return WindowActionType.close;
        }
        if (this.canResize(w)) {
            if (e.getX() < 10.0 && e.getY() < 10.0) {
                return WindowActionType.resizeUniTopLeft;
            }
            if (e.getX() > (double)(w.getWidth() - 10) && e.getY() < 10.0) {
                return WindowActionType.resizeUniTopRight;
            }
            if (e.getX() < 10.0 && e.getY() > (double)(w.getHeight() - 10)) {
                return WindowActionType.resizeUniBottomLeft;
            }
            if (e.getX() > (double)(w.getWidth() - 10) && e.getY() > (double)(w.getHeight() - 10)) {
                return WindowActionType.resizeUniBottomRight;
            }
            if (e.getX() > (double)(w.getWidth() - i.right)) {
                return WindowActionType.resizeRight;
            }
            if (e.getX() < (double)i.left) {
                return WindowActionType.resizeLeft;
            }
            if (e.getY() > (double)(w.getHeight() - i.bottom)) {
                return WindowActionType.resizeBottom;
            }
            if (e.getY() < (double)i.bottom) {
                return WindowActionType.resizeTop;
            }
        }
        if (e.getY() < (double)i.top) {
            return WindowActionType.move;
        }
        return WindowActionType.cursorChanged;
    }

    public AccessibilityMsgOut getAccessible(Window window, WindowActionType action, Point mousePointer) {
        AccessibilityMsgOut result = new AccessibilityMsgOut();
        if (!action.isButtonActionType()) {
            return null;
        }
        result.setId(System.identityHashCode(window) + "-" + action.name());
        result.setRole("decorationbutton");
        ArrayList<String> states = new ArrayList<String>();
        states.add("ENABLED");
        result.setStates(states);
        Rectangle rect = null;
        switch (action) {
            case dock: {
                rect = this.getDockUndockRect(window);
                result.setText("accessibility.window.button.toggleDock");
                break;
            }
            case undock: {
                rect = this.getDockUndockRect(window);
                result.setText("accessibility.window.button.toggleDock");
                break;
            }
            case close: {
                rect = this.getCloseRect(window);
                result.setText("accessibility.window.button.close");
                break;
            }
            case maximize: {
                rect = this.getMaximizeRect(window);
                if (!(window instanceof Frame)) break;
                if ((((Frame)window).getExtendedState() & 6) != 0) {
                    result.setText("accessibility.window.button.restore");
                    break;
                }
                result.setText("accessibility.window.button.maximize");
                break;
            }
            case minimize: {
                rect = this.getHideRect(window);
                result.setText("accessibility.window.button.minimize");
                break;
            }
        }
        if (rect != null) {
            Point loc = window.getLocationOnScreen();
            result.setScreenX(loc.x + rect.x);
            result.setScreenY(loc.y + rect.y);
            result.setWidth(rect.width);
            result.setHeight(rect.height);
        }
        return result;
    }

    public boolean isMinMaxButtonVisible(Object w) {
        if (w instanceof Window && Util.isWindowUndocked((Window)((Window)w))) {
            return false;
        }
        return w instanceof Frame && ((Frame)w).isResizable();
    }

    public boolean isCloseButtonVisible(Object w) {
        return !(w instanceof Window) || !Util.isWindowUndocked((Window)((Window)w));
    }

    public boolean canResize(Window w) {
        if (Util.isWindowUndocked((Window)w)) {
            return false;
        }
        return w instanceof Dialog && ((Dialog)w).isResizable() || w instanceof Frame && ((Frame)w).isResizable();
    }

    private boolean isDockButtonVisible(Object w) {
        switch (Util.getDockMode()) {
            case "NONE": {
                return false;
            }
            case "ALL": {
                return true;
            }
            case "MARKED": {
                return w instanceof Dockable;
            }
        }
        return false;
    }

    private abstract class ImageSet {
        BufferedImage TOP_LEFT;
        BufferedImage TITLE;
        BufferedImage MENU;
        BufferedImage DOCK;
        BufferedImage UNDOCK;
        BufferedImage HIDE;
        BufferedImage MAXIMIZE;
        BufferedImage CLOSE;
        BufferedImage TOP_RIGHT;
        BufferedImage LEFT;
        BufferedImage RIGHT;
        BufferedImage BOTTOM_LEFT;
        BufferedImage BOTTOM;
        BufferedImage BOTTOM_RIGHT;
        Color TEXT_COLOR;
        Color TEXT_SHADOW_COLOR;
        boolean TITLE_SHADOW;
        int TITLE_VERTICAL_OFFSET;

        private ImageSet() {
        }
    }
}

