/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webswing.model.CommonMsg;

public class ProtoMapper {
    public static final String PROTO_PACKAGE_APPFRAME_IN = "org.webswing.model.appframe.proto.AppFrameProtoIn";
    public static final String PROTO_PACKAGE_APPFRAME_OUT = "org.webswing.model.appframe.proto.AppFrameProtoOut";
    public static final String PROTO_PACKAGE_SERVER_APP_FRAME = "org.webswing.model.app.proto.ServerAppFrameProto";
    public static final String PROTO_PACKAGE_SERVER_BROWSER_FRAME = "org.webswing.model.browser.proto.ServerBrowserFrameProto";
    private static final String PROTO_PACKAGE_SERVER_COMMON = "org.webswing.model.common.proto.CommonProto";
    private final String basicProtoPackageEncode;
    private final String basicProtoPackageDecode;
    private Map<Class<?>, Class<?>> classProtoMap = new HashMap();
    private ClassLoader classLoader;

    public ProtoMapper(String basicProtoPackageEncodeDecode) {
        this.basicProtoPackageEncode = basicProtoPackageEncodeDecode;
        this.basicProtoPackageDecode = basicProtoPackageEncodeDecode;
    }

    public ProtoMapper(String basicProtoPackageEncodeDecode, ClassLoader classLoader) {
        this.basicProtoPackageEncode = basicProtoPackageEncodeDecode;
        this.basicProtoPackageDecode = basicProtoPackageEncodeDecode;
        this.classLoader = classLoader;
    }

    public ProtoMapper(String basicProtoPackageEncode, String basicProtoPackageDecode) {
        this.basicProtoPackageEncode = basicProtoPackageEncode;
        this.basicProtoPackageDecode = basicProtoPackageDecode;
    }

    public ProtoMapper(String basicProtoPackageEncode, String basicProtoPackageDecode, ClassLoader classLoader) {
        this.basicProtoPackageEncode = basicProtoPackageEncode;
        this.basicProtoPackageDecode = basicProtoPackageDecode;
        this.classLoader = classLoader;
    }

    public byte[] encodeProto(Serializable msg) throws IOException {
        Message result = this.encodeMessage(msg);
        return result.toByteArray();
    }

    public <T> T decodeProto(byte[] bytes, Class<T> msgInClass) throws IOException {
        T result = this.decodeMessage(bytes, msgInClass);
        return result;
    }

    private <T> T decodeMessage(byte[] bytes, Class<T> c) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            Class<?> protoClass = this.resolveProtoCounterpartClass(c, this.basicProtoPackageDecode);
            GeneratedMessageV3 protoMsg = (GeneratedMessageV3)protoClass.getDeclaredMethod("parseFrom", byte[].class).invoke(null, new Object[]{bytes});
            return this.decodeMessage((Message)protoMsg, c);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("decoding " + c + " from ProtoBuffer format failed!", e);
        }
    }

    private <T> T decodeMessage(Message protoMsg, Class<T> c) throws IOException {
        try {
            T result = c.newInstance();
            Map valueMap = protoMsg.getAllFields();
            for (Descriptors.FieldDescriptor fd : valueMap.keySet()) {
                Object value;
                Field field = c.getDeclaredField(fd.getName());
                field.setAccessible(true);
                if (fd.isRepeated()) {
                    if (field.getType() == List.class && field.getGenericType() instanceof ParameterizedType) {
                        ArrayList<Object> decodedList = new ArrayList<Object>();
                        ParameterizedType type = (ParameterizedType)field.getGenericType();
                        Class param = (Class)type.getActualTypeArguments()[0];
                        for (Object o : (List)valueMap.get(fd)) {
                            Object value2;
                            if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                                decodedList.add(this.decodeMessage((Message)o, param));
                                continue;
                            }
                            if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
                                value2 = this.decodeEnum((Descriptors.EnumValueDescriptor)o, param);
                                decodedList.add(value2);
                                continue;
                            }
                            if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
                                value2 = ((ByteString)o).toByteArray();
                                decodedList.add(value2);
                                continue;
                            }
                            decodedList.add(o);
                        }
                        field.set(result, decodedList);
                        continue;
                    }
                    throw new IOException("Field '" + fd.getName() + "' of " + c + " has to be List with generics type!");
                }
                if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                    Object o = this.decodeMessage((Message)valueMap.get(fd), field.getType());
                    field.set(result, o);
                    continue;
                }
                if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
                    value = this.decodeEnum((Descriptors.EnumValueDescriptor)valueMap.get(fd), field.getType());
                    field.set(result, value);
                    continue;
                }
                if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
                    value = ((ByteString)valueMap.get(fd)).toByteArray();
                    field.set(result, value);
                    continue;
                }
                field.set(result, valueMap.get(fd));
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException("decoding " + c + " from ProtoBuffer format failed!", e);
        }
    }

    private Message encodeMessage(Object msg) throws IOException {
        if (msg == null) {
            return null;
        }
        try {
            Class<?> c = msg.getClass();
            Class<?> protoClass = this.resolveProtoCounterpartClass(c, this.basicProtoPackageEncode);
            Message.Builder b = null;
            try {
                b = (Message.Builder)protoClass.getDeclaredMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Not able to resolve ProtoBuffer builder for " + protoClass.getName() + ".", e);
            }
            if (b != null) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object value = field.get(msg);
                    if (Modifier.isStatic(field.getModifiers()) || value == null) continue;
                    String fieldName = field.getName();
                    Descriptors.FieldDescriptor protoField = b.getDescriptorForType().findFieldByName(fieldName);
                    if (protoField == null) {
                        throw new IOException("Field '" + fieldName + "' not found in " + protoClass);
                    }
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        Collection list = (Collection)value;
                        for (Object val : list) {
                            this.encodeAndSetMessageValue(b, protoField, val, true);
                        }
                        continue;
                    }
                    this.encodeAndSetMessageValue(b, protoField, value, false);
                }
            }
            return b.build();
        }
        catch (Exception e) {
            throw new IOException("encoding " + msg.getClass() + " to ProtoBuffer format failed!", e);
        }
    }

    private Enum<?> decodeEnum(Descriptors.EnumValueDescriptor pe, Class<?> type) throws IOException {
        if (pe == null) {
            return null;
        }
        try {
            List<?> enumCons = Arrays.asList(type.getEnumConstants());
            for (Object e : enumCons) {
                Enum enm = (Enum)e;
                if (!pe.getName().equals(enm.name())) continue;
                return enm;
            }
        }
        catch (Exception e) {
            throw new IOException("Resolving enum " + type + " from ProtoBuffer format failed!", e);
        }
        return null;
    }

    private Descriptors.EnumValueDescriptor encodeEnum(Enum<?> enm) throws IOException {
        if (enm == null) {
            return null;
        }
        try {
            Class<?> protoClass = this.resolveProtoCounterpartClass(enm.getClass(), this.basicProtoPackageEncode);
            if (protoClass.isEnum()) {
                List<?> protoEnumCons = Arrays.asList(protoClass.getEnumConstants());
                for (Object pe : protoEnumCons) {
                    ProtocolMessageEnum penm = (ProtocolMessageEnum)pe;
                    if (!penm.getValueDescriptor().getName().equals(enm.name())) continue;
                    return penm.getValueDescriptor();
                }
            }
            throw new IOException("Could not resolve proto counterpart for " + enm.getClass() + "." + enm);
        }
        catch (Exception e) {
            throw new IOException("resolving Enum " + enm.getClass() + " to ProtoBuffer format failed!", e);
        }
    }

    private Class<?> resolveProtoCounterpartClass(Class<?> c, String protoPackage) throws ClassNotFoundException {
        if (!this.classProtoMap.containsKey(c)) {
            ClassLoader cl = this.classLoader;
            if (cl == null) {
                cl = c.getClassLoader();
            }
            String className = c.getName().substring(c.getName().lastIndexOf(".") + 1);
            String protoClassName = null;
            protoClassName = CommonMsg.class.isAssignableFrom(c) ? "org.webswing.model.common.proto.CommonProto$" + className.replaceAll("\\$", "Proto\\$") + "Proto" : protoPackage + "$" + className.replaceAll("\\$", "Proto\\$") + "Proto";
            Class<?> protoClass = cl.loadClass(protoClassName);
            this.classProtoMap.put(c, protoClass);
        }
        Class<?> protoClass = this.classProtoMap.get(c);
        return protoClass;
    }

    private void encodeAndSetMessageValue(Message.Builder b, Descriptors.FieldDescriptor protoField, Object value, boolean list) throws IOException {
        if (protoField.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
            this.setField(b, protoField, this.encodeMessage(value), list);
        } else if (protoField.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
            this.setField(b, protoField, this.encodeEnum((Enum)value), list);
        } else if (protoField.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
            this.setField(b, protoField, ByteString.readFrom((InputStream)new ByteArrayInputStream((byte[])value)), list);
        } else {
            this.setField(b, protoField, value, list);
        }
    }

    private void setField(Message.Builder b, Descriptors.FieldDescriptor protoField, Object message, boolean list) throws IOException {
        try {
            if (list) {
                b.addRepeatedField(protoField, message);
            } else {
                b.setField(protoField, message);
            }
        }
        catch (Exception e) {
            throw new IOException("Could not set " + message.getClass() + " to " + protoField.getFullName(), e);
        }
    }
}

