/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl;

import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.VolatileImage;
import org.webswing.directdraw.DirectDraw;
import org.webswing.directdraw.DirectDrawServicesAdapter;
import org.webswing.directdraw.toolkit.VolatileWebImageWrapper;
import org.webswing.directdraw.toolkit.WebImage;
import org.webswing.ext.services.DirectDrawService;
import org.webswing.services.impl.ddutil.FastDirectDrawServicesAdapter;

public class DirectDrawServiceImpl
implements DirectDrawService {
    private static DirectDrawServiceImpl impl;
    protected DirectDraw dd = new DirectDraw((DirectDrawServicesAdapter)new FastDirectDrawServicesAdapter());

    public static DirectDrawServiceImpl getInstance() {
        if (impl == null) {
            impl = new DirectDrawServiceImpl();
        }
        return impl;
    }

    private DirectDrawServiceImpl() {
    }

    public Image createImage(int width, int height) {
        return this.dd.createImage(width, height);
    }

    public Image extractWebImage(Image webImage) {
        if (webImage instanceof WebImage) {
            return ((WebImage)webImage).extractReadOnlyWebImage(true);
        }
        if (webImage instanceof VolatileWebImageWrapper) {
            return ((VolatileWebImageWrapper)webImage).getWebImage().extractReadOnlyWebImage(true);
        }
        return null;
    }

    public void resetCache() {
        this.dd.resetConstantCache();
    }

    public byte[] buildWebImage(Image webImage) {
        if (webImage instanceof WebImage) {
            return ((WebImage)webImage).toMessage(this.dd).toByteArray();
        }
        if (webImage instanceof VolatileWebImageWrapper) {
            return ((VolatileWebImageWrapper)webImage).getWebImage().toMessage(this.dd).toByteArray();
        }
        return null;
    }

    public boolean isDirty(Image webImage) {
        if (webImage instanceof WebImage) {
            return ((WebImage)webImage).isDirty();
        }
        if (webImage instanceof VolatileWebImageWrapper) {
            return ((VolatileWebImageWrapper)webImage).getWebImage().isDirty();
        }
        return false;
    }

    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps, int transparency) {
        return this.dd.createVolatileImage(width, height, caps);
    }

    public void resetImage(Image webImage) {
        if (webImage instanceof WebImage) {
            ((WebImage)webImage).reset();
        } else if (webImage instanceof VolatileWebImageWrapper) {
            ((VolatileWebImageWrapper)webImage).getWebImage().reset();
        }
    }

    public void resetImageBeforeRepaint(Image webImage) {
        if (webImage instanceof WebImage) {
            ((WebImage)webImage).resetBeforeRepaint();
        } else if (webImage instanceof VolatileWebImageWrapper) {
            ((VolatileWebImageWrapper)webImage).getWebImage().resetBeforeRepaint();
        }
    }
}

