/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.classloader;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.webswing.util.AppLogger;

public class ClassModificationRegister {
    private static FileLock lock;
    private Set<String> unmodifiedClassSet = new HashSet<String>();
    private PrintWriter writer = null;

    public ClassModificationRegister() {
        this.readUnmodified();
        try {
            if (this.acquireLock()) {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.getClassListFile(), true)));
                AppLogger.info((String)"ClassModificationRegister: lock acquired.", (Object[])new Object[0]);
            }
        }
        catch (IOException ex) {
            AppLogger.error((String)("ClassModificationRegister: Failed to create unmodified class register map. " + ex.getMessage()), (Object[])new Object[0]);
        }
    }

    private boolean acquireLock() throws IOException {
        if (lock == null) {
            RandomAccessFile lockFile = new RandomAccessFile(this.getClassListLockFile(), "rw");
            FileChannel channel = lockFile.getChannel();
            lock = channel.tryLock();
        }
        return lock != null;
    }

    private void readUnmodified() {
        try (Scanner sc = null;){
            sc = new Scanner(this.getClassListFile());
            while (sc.hasNextLine()) {
                this.unmodifiedClassSet.add(sc.nextLine());
            }
        }
    }

    File getClassListFile() {
        String blacklistFileName = System.getProperty("webswing.classModificationBlacklist");
        if (blacklistFileName != null) {
            return new File(blacklistFileName);
        }
        String tempDir = System.getProperty("webswing.tempDirPath");
        String applicationName = URLEncoder.encode(System.getProperty("webswing.appId"));
        return new File(URI.create(tempDir + applicationName + ".unmodified_classes"));
    }

    File getClassListLockFile() {
        return new File(this.getClassListFile().getAbsolutePath() + ".lock");
    }

    public boolean canSkipModification(String className) {
        return this.unmodifiedClassSet.contains(className);
    }

    public void notifyClassLoaded(String className) {
        this.unmodifiedClassSet.remove(className);
    }

    public void setModificationState(String className, boolean modified) {
        if (!modified && this.writer != null) {
            this.writer.println(className);
            this.writer.flush();
        }
    }
}

