/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl.connection.impl;

import jakarta.websocket.DeploymentException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslContextConfigurator;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.util.CommonUtil;

public class WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    public static final String __OBFUSCATE = "OBF:";
    private static ClientManager client;

    static ClientManager getClient() {
        if (client == null) {
            client = ClientManager.createClient((String)JdkClientContainer.class.getName());
            client.getProperties().put("org.glassfish.tyrus.client.sharedContainerIdleTimeout", 0);
            SslContextConfigurator sslContextConfigurator = new SslContextConfigurator();
            String truststore = System.getProperty("webswing.server.websocket.truststore");
            String truststoretype = System.getProperty("webswing.server.websocket.truststore.type");
            String truststorePwd = System.getProperty("webswing.server.websocket.truststore.password");
            if (truststore != null) {
                try {
                    truststore = CommonUtil.getValidFile((String)truststore).getCanonicalPath();
                    sslContextConfigurator.setTrustStoreFile(truststore);
                    if (truststoretype != null) {
                        sslContextConfigurator.setTrustStoreType(truststoretype);
                    }
                    if (truststorePwd != null) {
                        if (truststorePwd.startsWith(__OBFUSCATE)) {
                            truststorePwd = WebSocketClient.deobfuscate(truststorePwd);
                        }
                        sslContextConfigurator.setTrustStorePassword(truststorePwd);
                    }
                }
                catch (IOException e) {
                    log.error("Failed to load truststore for Webswing server connection.", (Throwable)e);
                }
            }
            SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(sslContextConfigurator, true, false, false);
            sslEngineConfigurator.setHostVerificationEnabled(!Boolean.getBoolean("webswing.server.websocket.hostnameVerifier.disabled"));
            client.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", sslEngineConfigurator);
            String proxyUri = System.getProperty("webswing.server.websocket.proxyUri");
            if (proxyUri != null) {
                client.getProperties().put("org.glassfish.tyrus.client.proxy", proxyUri);
            }
        }
        return client;
    }

    public static String deobfuscate(String s) {
        if (s.startsWith(__OBFUSCATE)) {
            s = s.substring(4);
        }
        byte[] b = new byte[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            int i0;
            String x;
            if (s.charAt(i) == 'U') {
                x = s.substring(++i, i + 4);
                i0 = Integer.parseInt(x, 36);
                byte bx = (byte)(i0 >> 8);
                b[l++] = bx;
                continue;
            }
            x = s.substring(i, i + 4);
            i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            byte bx = (byte)((i1 + i2 - 254) / 2);
            b[l++] = bx;
        }
        return new String(b, 0, l, StandardCharsets.UTF_8);
    }

    public void connectToServer(Object annotatedConnectionHndler, String path) throws IOException {
        try {
            WebSocketClient.getClient().connectToServer(annotatedConnectionHndler, URI.create(path));
        }
        catch (DeploymentException e) {
            throw new IOException("Failed to connect to websocket", e);
        }
    }
}

