/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.extension.ConfigurationProvider;
import org.webswing.server.extension.ConfigurationUpdateHandler;
import org.webswing.server.extension.DefaultConfigurationProvider;
import org.webswing.server.extension.ExtensionClassLoader;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.ConfigurationChangeEvent;
import org.webswing.server.services.config.ConfigurationChangeListener;
import org.webswing.server.services.config.ConfigurationService;

@Singleton
public class ConfigurationServiceImpl
implements ConfigurationService,
ConfigurationUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private final ExtensionClassLoader extensionLoader;
    private int interval;
    private ConfigurationProvider provider;
    private List<ConfigurationChangeListener> changeListeners = new ArrayList();

    @Inject
    public ConfigurationServiceImpl(ExtensionClassLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
        this.interval = Integer.getInteger("webswing.configReloadIntervalMs", 1000);
    }

    public void start() throws WsInitException {
        String providerClassName = System.getProperty("webswing.configProvider", DefaultConfigurationProvider.class.getName());
        try {
            Class providerClass = this.extensionLoader.loadClass(providerClassName);
            try {
                Constructor constructor = providerClass.getDeclaredConstructor(ConfigurationUpdateHandler.class);
                this.provider = (ConfigurationProvider)constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                this.provider = (ConfigurationProvider)providerClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new WsInitException("Could not instantiate configuration provider " + providerClassName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.clear();
        }
    }

    public SecuredPathConfig getConfiguration(String path) {
        path = this.asPath(path);
        Map configuration = this.provider.getConfiguration(path);
        return this.provider.toSecuredPathConfig(path, configuration);
    }

    public List<String> getPaths() {
        return this.provider.getPaths();
    }

    public void setConfiguration(String path, Map<String, Object> configuration) throws Exception {
        path = this.asPath(path);
        if (configuration == null) {
            configuration = this.provider.createDefaultConfiguration(path);
        }
        this.provider.validateConfiguration(path, configuration);
        this.provider.saveConfiguration(path, configuration);
    }

    public void removeConfiguration(String path) throws Exception {
        this.provider.removeConfiguration(this.asPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeListener(ConfigurationChangeListener listener) {
        List list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ConfigurationChangeListener listener) {
        List list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConfigChanged(String path, SecuredPathConfig newCfg) {
        List list = this.changeListeners;
        synchronized (list) {
            for (ConfigurationChangeListener listener : this.changeListeners) {
                if (listener == null) continue;
                listener.onConfigChanged(new ConfigurationChangeEvent(this.asPath(path), newCfg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConfigDeleted(String path) {
        List list = this.changeListeners;
        synchronized (list) {
            for (ConfigurationChangeListener listener : this.changeListeners) {
                if (listener == null) continue;
                listener.onConfigDeleted(new ConfigurationChangeEvent(this.asPath(path), null));
            }
        }
    }

    public MetaObject describeConfiguration(String path, Map<String, Object> json, ConfigContext ctx) throws WsException {
        return this.provider.describeConfiguration(this.asPath(path), json, ctx, (ClassLoader)this.extensionLoader);
    }

    private String asPath(String path) {
        String p = CommonUtil.toPath((String)path);
        if (StringUtils.isBlank((String)p)) {
            p = "/";
        }
        return p;
    }

    public boolean isMultiApplicationMode() {
        return this.provider.isMultiApplicationMode();
    }
}

