/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.startup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.webswing.server.extension.Initializer;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.jms.JmsService;
import org.webswing.server.services.startup.StartupService;
import org.webswing.server.services.websocket.WebSocketService;

@Singleton
public class StartupServiceImpl
implements StartupService {
    private final JmsService jms;
    private final WebSocketService websocket;
    private final ConfigurationService config;

    @Inject
    public StartupServiceImpl(Initializer ini, JmsService jms, WebSocketService websocket, ConfigurationService config) {
        this.jms = jms;
        this.websocket = websocket;
        this.config = config;
    }

    public void start() throws WsInitException {
        try {
            this.jms.start();
            this.websocket.start();
            this.config.start();
        }
        catch (WsInitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WsInitException("Failed to start Webswing. " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        this.config.stop();
        this.websocket.stop();
        this.jms.stop();
    }
}

