/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swinginstance;

import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import main.Main;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgIn;
import org.webswing.model.MsgInternal;
import org.webswing.model.MsgOut;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.c2s.ParamMsg;
import org.webswing.model.c2s.SimpleEventMsgIn;
import org.webswing.model.c2s.TimestampsMsgIn;
import org.webswing.model.internal.ApiCallMsgInternal;
import org.webswing.model.internal.ApiEventMsgInternal;
import org.webswing.model.internal.ExitMsgInternal;
import org.webswing.model.internal.JvmStatsMsgInternal;
import org.webswing.model.internal.OpenFileResultMsgInternal;
import org.webswing.model.internal.PrinterJobResultMsgInternal;
import org.webswing.model.internal.ThreadDumpMsgInternal;
import org.webswing.model.internal.ThreadDumpRequestMsgInternal;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.CursorChangeEventMsg;
import org.webswing.model.s2c.LinkActionMsg;
import org.webswing.model.s2c.SimpleEventMsgOut;
import org.webswing.server.common.model.AppletLauncherConfig;
import org.webswing.server.common.model.DesktopLauncherConfig;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.model.admin.SwingInstanceStatus;
import org.webswing.server.common.model.admin.SwingSession;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.EncodedMessage;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.files.FileTransferHandler;
import org.webswing.server.services.jvmconnection.JvmConnection;
import org.webswing.server.services.jvmconnection.JvmConnectionService;
import org.webswing.server.services.jvmconnection.JvmListener;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.modules.AbstractSecurityModule;
import org.webswing.server.services.swinginstance.SessionRecorder;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swinginstance.SwingInstanceImpl;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingprocess.ProcessExitListener;
import org.webswing.server.services.swingprocess.SwingProcess;
import org.webswing.server.services.swingprocess.SwingProcessConfig;
import org.webswing.server.services.swingprocess.SwingProcessService;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.util.FontUtils;
import org.webswing.server.util.ServerUtil;
import org.webswing.toolkit.api.WebswingApi;

public class SwingInstanceImpl
implements SwingInstance,
JvmListener {
    private static final String LAUNCHER_CONFIG = "launcherConfig";
    private static final String WEB_TOOLKIT_CLASS_NAME = "org.webswing.toolkit.WebToolkit";
    private static final String WEB_GRAPHICS_ENV_CLASS_NAME = "org.webswing.toolkit.ge.WebGraphicsEnvironment";
    private static final String WEB_PRINTER_JOB_CLASS_NAME = "org.webswing.toolkit.WebPrinterJobWrapper";
    private static final String WIN_SHELL_FOLDER_MANAGER = "sun.awt.shell.Win32ShellFolderManager2";
    private static final String JAVA_FX_PATH = System.getProperty("java.home") + "/lib/ext/jfxrt.jar";
    private static final String JAVA_FX_TOOLKIT_CLASS_NAME = "org.webswing.javafx.ToolkitJarMarker";
    private static final Logger log = LoggerFactory.getLogger(SwingInstance.class);
    private final SwingInstanceManager manager;
    private final FileTransferHandler fileHandler;
    private final String instanceId;
    private final String clientId;
    private String clientIp;
    private AbstractWebswingUser user;
    private SwingProcess process;
    private JvmConnection jvmConnection;
    private SessionRecorder sessionRecorder;
    private WebSocketConnection webConnection;
    private WebSocketConnection mirroredWebConnection;
    private SwingConfig config;
    private Date disconnectedSince;
    private final Date startedAt = new Date();
    private final String queueId;
    private String customArgs = "";
    private int debugPort = 0;
    private String locale = null;
    private String userIp = null;
    private String userOs = null;
    private String userBrowser = null;
    private Date endedAt = null;
    private List<String> warningHistoryLog;
    private Map<Long, ThreadDumpMsgInternal> threadDumps = new ConcurrentHashMap();

    public SwingInstanceImpl(SwingInstanceManager manager, FileTransferHandler fileHandler, SwingProcessService processService, JvmConnectionService connectionService, ConnectionHandshakeMsgIn h, SwingConfig config, WebSocketConnection websocket) throws WsException {
        this.manager = manager;
        this.fileHandler = fileHandler;
        this.webConnection = websocket;
        this.instanceId = ServerUtil.resolveInstanceIdForMode((WebSocketConnection)websocket, (ConnectionHandshakeMsgIn)h, (SwingConfig)config);
        this.config = config;
        this.user = websocket.getUser();
        this.clientId = h.getClientId();
        this.customArgs = ServerUtil.getCustomArgs((HttpServletRequest)websocket.getRequest());
        this.debugPort = ServerUtil.getDebugPort((HttpServletRequest)websocket.getRequest());
        this.clientIp = ServerUtil.getClientIp((WebSocketConnection)websocket);
        this.queueId = this.user.getUserId() + "-" + config.getName() + "-" + this.startedAt.getTime();
        this.updateUser(websocket);
        try {
            this.jvmConnection = connectionService.connect(this.queueId, (JvmListener)this);
            this.process = this.start(processService, config, h);
            this.notifyUserConnected();
        }
        catch (Exception e) {
            this.notifyExiting();
            throw new WsException("Failed to create App instance.", (Throwable)e);
        }
        this.sessionRecorder = ServerUtil.isRecording((HttpServletRequest)websocket.getRequest()) ? new SessionRecorder((SwingInstance)this) : null;
        this.logStatValue("webSocketConnected", (Number)(websocket.isWebsocketTransport() ? 1 : 2));
    }

    public void connectSwingInstance(WebSocketConnection r, ConnectionHandshakeMsgIn h) {
        if (h.isMirrored()) {
            this.connectMirroredWebSession(r);
        } else if (h.getSessionId() != null && h.getSessionId().equals(this.getSessionId())) {
            this.sendToSwing(r, (MsgIn)h);
        } else {
            boolean result = this.connectPrimaryWebSession(r);
            if (result) {
                r.broadcastMessage((MsgOut)SimpleEventMsgOut.continueOldSession.buildMsgOut());
            } else {
                r.broadcastMessage((MsgOut)SimpleEventMsgOut.applicationAlreadyRunning.buildMsgOut());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectPrimaryWebSession(WebSocketConnection resource) {
        if (resource != null) {
            if (this.webConnection != null && this.config.isAllowStealSession()) {
                WebSocketConnection webSocketConnection = this.webConnection;
                synchronized (webSocketConnection) {
                    this.webConnection.broadcastMessage((MsgOut)SimpleEventMsgOut.sessionStolenNotification.buildMsgOut());
                }
                this.notifyUserDisconnected();
                this.webConnection = null;
            }
            if (this.webConnection == null) {
                this.webConnection = resource;
                this.updateUser(resource);
                this.logStatValue("webSocketConnected", (Number)(resource.isWebsocketTransport() ? 1 : 2));
                this.disconnectedSince = null;
                this.notifyUserConnected();
                return true;
            }
        }
        return false;
    }

    private void updateUser(WebSocketConnection resource) {
        this.userIp = ServerUtil.getClientIp((WebSocketConnection)this.webConnection);
        this.userOs = ServerUtil.getClientOs((WebSocketConnection)this.webConnection);
        this.userBrowser = ServerUtil.getClientBrowser((WebSocketConnection)this.webConnection);
    }

    private void disconnectPrimaryWebSession() {
        if (this.webConnection != null) {
            this.notifyUserDisconnected();
            this.webConnection = null;
            this.disconnectedSince = new Date();
            this.logStatValue("webSocketConnected", (Number)0);
        }
    }

    public void shutdown(boolean force) {
        if (force) {
            this.kill(0);
        } else {
            SimpleEventMsgIn simpleEventMsgIn = new SimpleEventMsgIn();
            simpleEventMsgIn.setType(SimpleEventMsgIn.SimpleEventType.killSwing);
            this.sendToSwing(null, (MsgIn)simpleEventMsgIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectMirroredWebSession(WebSocketConnection resource) {
        if (resource != null) {
            if (this.mirroredWebConnection != null) {
                WebSocketConnection webSocketConnection = this.mirroredWebConnection;
                synchronized (webSocketConnection) {
                    this.mirroredWebConnection.broadcastMessage((MsgOut)SimpleEventMsgOut.sessionStolenNotification.buildMsgOut());
                }
                this.notifyMirrorViewDisconnected();
            }
            this.mirroredWebConnection = resource;
            this.notifyMirrorViewConnected();
        }
    }

    private void disconnectMirroredWebSession() {
        if (this.mirroredWebConnection != null) {
            this.notifyMirrorViewDisconnected();
            this.mirroredWebConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToWeb(MsgOut o) {
        WebSocketConnection webSocketConnection;
        EncodedMessage serialized = new EncodedMessage(o);
        if (this.sessionRecorder != null) {
            this.sessionRecorder.saveFrame(serialized.getProtoMessage());
        }
        if (this.webConnection != null) {
            webSocketConnection = this.webConnection;
            synchronized (webSocketConnection) {
                this.webConnection.broadcastMessage(serialized);
                int length = serialized.getLength(this.webConnection.isBinary());
                this.logStatValue("outboundSize", (Number)length);
            }
        }
        if (this.mirroredWebConnection != null) {
            webSocketConnection = this.mirroredWebConnection;
            synchronized (webSocketConnection) {
                this.mirroredWebConnection.broadcastMessage(serialized);
            }
        }
    }

    public boolean sendToSwing(WebSocketConnection r, MsgIn h) {
        if (this.isRunning()) {
            if (h instanceof SimpleEventMsgIn) {
                SimpleEventMsgIn m = (SimpleEventMsgIn)h;
                if (m.getType().equals((Object)SimpleEventMsgIn.SimpleEventType.paintAck)) {
                    if (this.webConnection != null && r.uuid().equals(this.webConnection.uuid()) || this.webConnection == null && this.mirroredWebConnection != null && r.uuid().equals(this.mirroredWebConnection.uuid())) {
                        this.jvmConnection.send((Serializable)h);
                    }
                } else if (m.getType().equals((Object)SimpleEventMsgIn.SimpleEventType.unload)) {
                    if (this.webConnection != null && r.uuid().equals(this.webConnection.uuid())) {
                        this.jvmConnection.send((Serializable)h);
                    }
                    this.disconnectPrimaryWebSession();
                    this.disconnectMirroredWebSession();
                } else {
                    this.jvmConnection.send((Serializable)h);
                }
            } else if (h instanceof TimestampsMsgIn) {
                this.processTimestampMessage((TimestampsMsgIn)h);
                this.jvmConnection.send((Serializable)h);
            } else {
                this.jvmConnection.send((Serializable)h);
            }
            return true;
        }
        return false;
    }

    private void processTimestampMessage(TimestampsMsgIn h) {
        if (StringUtils.isNotEmpty((String)h.getSendTimestamp())) {
            long currentTime = System.currentTimeMillis();
            long sendTime = Long.parseLong(h.getSendTimestamp());
            if (StringUtils.isNotEmpty((String)h.getRenderingTime()) && StringUtils.isNotEmpty((String)h.getStartTimestamp())) {
                long renderingTime = Long.parseLong(h.getRenderingTime());
                long startTime = Long.parseLong(h.getStartTimestamp());
                this.logStatValue("latencyServerRendering", (Number)(sendTime - startTime));
                this.logStatValue("latencyClientRendering", (Number)renderingTime);
                this.logStatValue("latency", (Number)(currentTime - startTime));
                this.logStatValue("latencyNetworkTransfer", (Number)(currentTime - sendTime - renderingTime));
            }
        }
        if (h.getPing() > 0) {
            this.logStatValue("latencyPing", (Number)h.getPing());
        }
    }

    public void onJvmMessage(Serializable o) {
        if (o instanceof MsgInternal) {
            if (o instanceof ApiCallMsgInternal) {
                ApiCallMsgInternal query = (ApiCallMsgInternal)o;
                AbstractWebswingUser currentUser = this.webConnection != null ? this.webConnection.getUser() : null;
                switch (2.$SwitchMap$org$webswing$model$internal$ApiCallMsgInternal$ApiMethod[query.getMethod().ordinal()]) {
                    case 1: {
                        if (currentUser == null) {
                            query.setResult(null);
                        } else {
                            Boolean result = currentUser.hasRole((String)((Object)query.getArgs()[0]));
                            query.setResult((Serializable)result);
                        }
                        this.jvmConnection.send((Serializable)query);
                        break;
                    }
                    case 2: {
                        if (currentUser == null) {
                            query.setResult(null);
                        } else {
                            Boolean result = currentUser.isPermitted((String)((Object)query.getArgs()[0]));
                            query.setResult((Serializable)result);
                        }
                        this.jvmConnection.send((Serializable)query);
                        break;
                    }
                }
            } else if (o instanceof PrinterJobResultMsgInternal) {
                PrinterJobResultMsgInternal pj = (PrinterJobResultMsgInternal)o;
                boolean success = this.fileHandler.registerFile(pj.getPdfFile(), pj.getId(), 30L, TimeUnit.MINUTES, this.getUser(), this.getInstanceId(), pj.isTempFile(), false, null);
                if (success) {
                    AppFrameMsgOut f = new AppFrameMsgOut();
                    LinkActionMsg linkAction = new LinkActionMsg(LinkActionMsg.LinkActionType.print, pj.getId());
                    f.setLinkAction(linkAction);
                    this.sendToWeb((MsgOut)f);
                }
            } else if (o instanceof OpenFileResultMsgInternal) {
                OpenFileResultMsgInternal fr = (OpenFileResultMsgInternal)o;
                String extension = this.getFileExtension(fr.getFile());
                String id = UUID.randomUUID().toString() + extension;
                boolean success = this.fileHandler.registerFile(fr.getFile(), id, 30L, TimeUnit.MINUTES, this.getUser(), this.getInstanceId(), false, fr.isWaitForFile(), fr.getOverwriteDetails());
                if (success) {
                    AppFrameMsgOut f = new AppFrameMsgOut();
                    LinkActionMsg linkAction = new LinkActionMsg(LinkActionMsg.LinkActionType.file, id);
                    f.setLinkAction(linkAction);
                    this.sendToWeb((MsgOut)f);
                }
            } else if (o instanceof JvmStatsMsgInternal) {
                JvmStatsMsgInternal s = (JvmStatsMsgInternal)o;
                this.logStatValue("memoryAllocated", (Number)s.getHeapSize());
                this.logStatValue("memoryUsed", (Number)s.getHeapSizeUsed());
                this.logStatValue("cpuUtilization", (Number)s.getCpuUsage());
                this.logStatValue("edtThreadBlockedForSeconds", (Number)s.getEdtPingSeconds());
                if (this.getAppConfig().isMonitorEdtEnabled() && s.getEdtPingSeconds() > 2) {
                    this.sendToWeb((MsgOut)SimpleEventMsgOut.applicationBusy.buildMsgOut());
                }
            } else if (o instanceof ExitMsgInternal) {
                this.close();
                ExitMsgInternal e = (ExitMsgInternal)o;
                this.kill(e.getWaitForExit());
            } else if (o instanceof ThreadDumpMsgInternal) {
                ThreadDumpMsgInternal e = (ThreadDumpMsgInternal)o;
                this.threadDumps.put(e.getTimestamp(), e);
            }
        } else if (o instanceof AppFrameMsgOut && ((AppFrameMsgOut)o).getCursorChange() != null) {
            CursorChangeEventMsg cmsg = ((AppFrameMsgOut)o).getCursorChange();
            if (cmsg.getCurFile() != null) {
                File cur = new File(cmsg.getCurFile());
                boolean success = this.fileHandler.registerFile(cur, cur.getName(), 1L, TimeUnit.DAYS, this.getUser(), this.getInstanceId(), false, false, null);
                cmsg.setCurFile(cur.getName());
            }
            this.sendToWeb((MsgOut)o);
        } else if (o instanceof MsgOut) {
            this.sendToWeb((MsgOut)o);
        }
    }

    private void close() {
        if (this.config.isAutoLogout()) {
            this.sendToWeb((MsgOut)SimpleEventMsgOut.shutDownAutoLogoutNotification.buildMsgOut());
        }
        if (StringUtils.isNotBlank((String)this.config.getGoodbyeUrl())) {
            VariableSubstitutor subs = VariableSubstitutor.forSwingInstance((SecuredPathConfig)this.manager.getConfig(), (String)this.user.getUserId(), (Map)this.user.getUserAttributes(), (String)this.getClientId(), (String)this.clientIp, (String)this.locale, (String)this.customArgs);
            String url = subs.replace(this.config.getGoodbyeUrl());
            if (url.startsWith("/")) {
                url = AbstractSecurityModule.getContextPath((ServletContext)this.manager.getServletContext()) + url;
            }
            AppFrameMsgOut result = new AppFrameMsgOut();
            result.setLinkAction(new LinkActionMsg(LinkActionMsg.LinkActionType.redirect, url));
            this.sendToWeb((MsgOut)result);
        } else {
            this.sendToWeb((MsgOut)SimpleEventMsgOut.shutDownNotification.buildMsgOut());
        }
        this.jvmConnection.close();
        this.notifyExiting();
        if (this.process != null && this.config.isIsolatedFs() && this.config.isClearTransferDir()) {
            String transferDir = (String)this.process.getConfig().getProperties().get("webswing.transfer.dir");
            try {
                if (transferDir.indexOf(File.pathSeparator) != -1) {
                    throw new IOException("Can not clear upload folder if multiple roots are defined. Turn off the option in Webswing config. [" + transferDir + "]");
                }
                if (transferDir != null) {
                    FileUtils.deleteDirectory((File)new File(transferDir));
                    log.info("Transfer dir for session [" + this.process.getConfig().getName() + "] cleared. [" + transferDir + "]");
                }
            }
            catch (IOException e) {
                log.error("Failed to delete transfer dir " + transferDir, (Throwable)e);
            }
        }
    }

    public void notifyExiting() {
        this.endedAt = new Date();
        if (this.isRunning()) {
            this.process.setProcessExitListener(null);
        }
        if (this.sessionRecorder != null) {
            this.sessionRecorder.close();
        }
        this.manager.notifySwingClose((SwingInstance)this);
    }

    public void startRecording() {
        if (this.sessionRecorder == null) {
            this.sessionRecorder = new SessionRecorder((SwingInstance)this);
            this.sendToSwing(this.webConnection, (MsgIn)new SimpleEventMsgIn(SimpleEventMsgIn.SimpleEventType.repaint));
        }
    }

    public SwingSession toSwingSession(boolean stats) {
        SwingSession session = new SwingSession();
        session.setId(this.getInstanceId());
        session.setApplet(Boolean.valueOf(SwingConfig.LauncherType.Applet.equals((Object)this.getAppConfig().getLauncherType())));
        session.setApplication(this.getAppConfig().getName());
        session.setConnected(Boolean.valueOf(this.getSessionId() != null));
        if (!session.getConnected().booleanValue()) {
            session.setDisconnectedSince(this.getDisconnectedSince());
        }
        session.setStartedAt(this.getStartedAt());
        session.setUser(this.getUser());
        session.setUserIp(this.userIp);
        session.setUserOs(this.userOs);
        session.setUserBrowser(this.userBrowser);
        session.setEndedAt(this.getEndedAt());
        session.setStatus(this.getStatus());
        if (stats) {
            session.setStats(this.manager.getInstanceStats(this.getClientId()));
        }
        session.setMetrics(this.manager.getInstanceMetrics(this.getClientId()));
        session.setWarnings(this.manager.getInstanceWarnings(this.getClientId()));
        if (this.isRunning()) {
            session.setWarningHistory(this.manager.getInstanceWarningHistory(this.getClientId()));
        } else {
            session.setWarningHistory(this.warningHistoryLog);
        }
        session.setRecorded(this.isRecording());
        session.setRecordingFile(this.getRecordingFile());
        session.setThreadDumps(this.toMap(this.threadDumps));
        return session;
    }

    public void kill(int delayMs) {
        if (this.process != null) {
            this.process.destroy(delayMs);
        }
    }

    private SwingProcess start(SwingProcessService processService, SwingConfig appConfig, ConnectionHandshakeMsgIn handshake) throws Exception {
        this.locale = handshake.getLocale();
        Integer screenWidth = handshake.getDesktopWidth();
        Integer screenHeight = handshake.getDesktopHeight();
        VariableSubstitutor subs = VariableSubstitutor.forSwingInstance((SecuredPathConfig)this.manager.getConfig(), (String)this.user.getUserId(), (Map)this.user.getUserAttributes(), (String)this.getClientId(), (String)this.clientIp, (String)this.locale, (String)this.customArgs);
        SwingProcess swing = null;
        try {
            SwingProcessConfig swingConfig = new SwingProcessConfig();
            swingConfig.setName(this.getClientId());
            String java = this.getAbsolutePath(subs.replace(appConfig.getJreExecutable()), false);
            swingConfig.setJreExecutable(java);
            String homeDir = this.getAbsolutePath(subs.replace(appConfig.getUserDir()), true);
            swingConfig.setBaseDir(homeDir);
            swingConfig.setMainClass(Main.class.getName());
            swingConfig.setClassPath(new File(URI.create(CommonUtil.getWarFileLocation())).getAbsolutePath());
            String javaVersion = subs.replace(appConfig.getJavaVersion());
            boolean useJFX = this.config.isJavaFx();
            if (!new File(JAVA_FX_PATH).exists()) {
                log.warn("Java FX not supported with current java version (Try version 1.8). JavaFx library not found in '" + new File(JAVA_FX_PATH).getCanonicalPath() + "'. ");
                useJFX = false;
            }
            String webToolkitClass = WEB_TOOLKIT_CLASS_NAME;
            String webGraphicsEnvClass = WEB_GRAPHICS_ENV_CLASS_NAME;
            if (javaVersion.startsWith("1.7")) {
                webToolkitClass = webToolkitClass + "7";
                webGraphicsEnvClass = webGraphicsEnvClass + "7";
            } else if (javaVersion.startsWith("1.8")) {
                webToolkitClass = webToolkitClass + "8";
                webGraphicsEnvClass = webGraphicsEnvClass + "8";
            } else {
                log.error("Java version " + javaVersion + " not supported in this version of Webswing.");
                throw new RuntimeException("Java version not supported. (Version starting with 1.7 and 1.8 are supported.)");
            }
            String webSwingToolkitApiJarPath = CommonUtil.getBootClassPathForClass((String)WebswingApi.class.getName());
            String webSwingToolkitJarPath = CommonUtil.getBootClassPathForClass((String)WEB_TOOLKIT_CLASS_NAME);
            String webSwingToolkitJarPathSpecific = CommonUtil.getBootClassPathForClass((String)webToolkitClass);
            String rtWinShellJarPath = System.getProperty("os.name", "").startsWith("Windows") ? "" : File.pathSeparator + CommonUtil.getBootClassPathForClass((String)WIN_SHELL_FOLDER_MANAGER);
            String bootCp = "-Xbootclasspath/a:" + webSwingToolkitApiJarPath + File.pathSeparatorChar + webSwingToolkitJarPathSpecific + File.pathSeparatorChar + webSwingToolkitJarPath + rtWinShellJarPath;
            if (useJFX) {
                bootCp = bootCp + File.pathSeparator + CommonUtil.getBootClassPathForClass((String)JAVA_FX_TOOLKIT_CLASS_NAME) + File.pathSeparator + "\"" + new File(JAVA_FX_PATH).getCanonicalPath() + "\"";
            }
            String debug = appConfig.isDebug() && this.debugPort != 0 ? " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=y " : "";
            String vmArgs = appConfig.getVmArgs() == null ? "" : subs.replace(appConfig.getVmArgs());
            swingConfig.setJvmArgs(bootCp + debug + " -noverify " + vmArgs);
            swingConfig.addProperty("webswing.clientId", this.getClientId());
            swingConfig.addProperty("webswing.jmsQueueId", this.queueId);
            swingConfig.addProperty("webswing.applicationHome", this.getAbsolutePath(".", false));
            swingConfig.addProperty("webswing.classPath", subs.replace(CommonUtil.generateClassPathString((Collection)appConfig.getClassPathEntries())));
            swingConfig.addProperty("webswing.tempDirPath", System.getProperty("webswing.tempDirPath"));
            swingConfig.addProperty("webswing.jmsUrl", System.getProperty("webswing.jmsUrl", "nio://127.0.0.1:34455"));
            swingConfig.addProperty("webswing.theme", subs.replace(appConfig.getTheme()));
            swingConfig.addProperty("webswing.isolatedFs", appConfig.isIsolatedFs());
            swingConfig.addProperty("webswing.transfer.dir", this.getAbsolutePaths(subs.replace(appConfig.getTransferDir()), false));
            swingConfig.addProperty("webswing.allowDownload", appConfig.isAllowDownload());
            swingConfig.addProperty("webswing.allowAutoDownload", appConfig.isAllowAutoDownload());
            swingConfig.addProperty("webswing.allowUpload", appConfig.isAllowUpload());
            swingConfig.addProperty("webswing.transparentFileOpen", appConfig.isTransparentFileOpen());
            swingConfig.addProperty("webswing.transparentFileSave", appConfig.isTransparentFileSave());
            swingConfig.addProperty("webswing.allowDelete", appConfig.isAllowDelete());
            swingConfig.addProperty("webswing.allowLocalClipboard", appConfig.isAllowLocalClipboard());
            swingConfig.addProperty("webswing.allowJsLink", appConfig.isAllowJsLink());
            swingConfig.addProperty("webswing.initialUrl", handshake.getUrl());
            swingConfig.addProperty("webswing.directdraw", appConfig.isDirectdraw());
            swingConfig.addProperty("webswing.directdraw.supported", handshake.isDirectDrawSupported());
            swingConfig.addProperty("webswing.sessionTimeoutSec", appConfig.getSwingSessionTimeout());
            swingConfig.addProperty("webswing.sessionTimeoutIfInactive", appConfig.isTimeoutIfInactive());
            swingConfig.addProperty("awt.toolkit", webToolkitClass);
            swingConfig.addProperty("java.awt.headless", false);
            swingConfig.addProperty("java.awt.graphicsenv", webGraphicsEnvClass);
            swingConfig.addProperty("java.awt.printerjob", WEB_PRINTER_JOB_CLASS_NAME);
            swingConfig.addProperty("webswing.printerJobDelegate", appConfig.isAllowServerPrinting() ? PrinterJob.getPrinterJob().getClass().getCanonicalName() : "org.webswing.toolkit.WebPrinterJob");
            swingConfig.addProperty("sun.awt.fontconfig", FontUtils.createFontConfiguration((SwingConfig)appConfig, (VariableSubstitutor)subs));
            swingConfig.addProperty("webswing.screenWidth", screenWidth == null ? 300 : screenWidth);
            swingConfig.addProperty("webswing.screenHeight", screenHeight == null ? 300 : screenHeight);
            if (useJFX) {
                swingConfig.addProperty("glass.platform", "Web");
                swingConfig.addProperty("prism.order", "web");
                swingConfig.addProperty("prism.text", "t2k");
                swingConfig.addProperty("prism.lcdtext", "false");
                swingConfig.addProperty("javafx.live.resize", "false");
            }
            switch (2.$SwitchMap$org$webswing$server$common$model$SwingConfig$LauncherType[appConfig.getLauncherType().ordinal()]) {
                case 1: {
                    AppletLauncherConfig applet = (AppletLauncherConfig)appConfig.getValueAs(LAUNCHER_CONFIG, AppletLauncherConfig.class);
                    swingConfig.addProperty("webswing.appletDocumentBase", handshake.getDocumentBase());
                    swingConfig.addProperty("webswing.appletClass", applet.getAppletClass());
                    for (String key : applet.getParameters().keySet()) {
                        swingConfig.addProperty("webswing.appletParam_" + subs.replace(key), subs.replace((String)applet.getParameters().get(key)));
                    }
                    if (handshake.getParams() == null) break;
                    for (ParamMsg p : handshake.getParams()) {
                        swingConfig.addProperty("webswing.appletParam_" + p.getName(), p.getValue());
                    }
                    break;
                }
                case 2: {
                    DesktopLauncherConfig desktop = (DesktopLauncherConfig)appConfig.getValueAs(LAUNCHER_CONFIG, DesktopLauncherConfig.class);
                    swingConfig.setArgs(subs.replace(desktop.getArgs()));
                    swingConfig.addProperty("webswing.mainClass", subs.replace(desktop.getMainClass()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Launcher type not recognized.");
                }
            }
            swing = processService.create(swingConfig);
            swing.execute();
            swing.setProcessExitListener((ProcessExitListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e1) {
            this.close();
            throw new Exception(e1);
        }
        return swing;
    }

    private String getAbsolutePaths(String paths, boolean b) throws IOException {
        String result = "";
        for (String s : paths.split(File.pathSeparator)) {
            result = result + this.getAbsolutePath(s, b) + File.pathSeparator;
        }
        return result.substring(0, Math.max(0, result.length() - 1));
    }

    private String getAbsolutePath(String path, boolean create) throws IOException {
        File f;
        if (StringUtils.isBlank((String)path)) {
            path = ".";
        }
        if ((f = this.manager.resolveFile(path)) == null || !f.exists()) {
            boolean done;
            boolean absolute;
            String[] pathSegs = (path = path.replaceAll("\\\\", "/")).split("/");
            boolean bl = absolute = pathSegs[0].length() == 0 || pathSegs[0].contains(":");
            if (!absolute) {
                File home = this.manager.resolveFile(".");
                f = new File(home, path);
            } else {
                f = new File(path);
            }
            if (create && !(done = f.mkdirs())) {
                throw new IOException("Unable to create path. " + f.getAbsolutePath());
            }
        }
        return f.getCanonicalPath();
    }

    public String getClientId() {
        return this.clientId;
    }

    public SwingConfig getAppConfig() {
        return this.config;
    }

    public String getSessionId() {
        if (this.webConnection != null) {
            return this.webConnection.uuid();
        }
        return null;
    }

    public String getMirroredSessionId() {
        if (this.mirroredWebConnection != null) {
            return this.mirroredWebConnection.uuid();
        }
        return null;
    }

    public boolean isRunning() {
        return this.process != null && this.process.isRunning();
    }

    public String getUser() {
        return this.user.getUserId();
    }

    public Date getDisconnectedSince() {
        return this.disconnectedSince;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public Date getEndedAt() {
        return this.endedAt;
    }

    public Boolean isRecording() {
        return this.sessionRecorder != null && !this.sessionRecorder.isFailed();
    }

    public String getRecordingFile() {
        return this.sessionRecorder != null ? this.sessionRecorder.getFileName() : null;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public SwingInstanceStatus getStatus() {
        if (this.process == null) {
            return SwingInstanceStatus.NOT_STARTED;
        }
        if (this.isRunning()) {
            if (this.getEndedAt() == null) {
                return SwingInstanceStatus.RUNNING;
            }
            return SwingInstanceStatus.EXITING;
        }
        if (this.process.isForceKilled()) {
            return SwingInstanceStatus.FORCE_KILLED;
        }
        return SwingInstanceStatus.FINISHED;
    }

    public void webSessionDisconnected(String connectionId) {
        if (this.getSessionId() != null && this.getSessionId().equals(connectionId)) {
            this.disconnectPrimaryWebSession();
        } else if (this.getMirroredSessionId() != null && this.getMirroredSessionId().equals(connectionId)) {
            this.disconnectMirroredWebSession();
        }
    }

    public String getMirrorSessionId() {
        return this.mirroredWebConnection != null ? this.mirroredWebConnection.uuid() : null;
    }

    public void logStatValue(String name, Number value) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.manager.logStatValue(this.getClientId(), name, value);
        }
    }

    public void logWarningHistory() {
        List current = this.manager.getInstanceWarnings(this.getClientId());
        if (current != null) {
            current.addAll(this.manager.getInstanceWarningHistory(this.getClientId()));
        }
        this.warningHistoryLog = current;
    }

    private Map<Long, String> toMap(Map<Long, ThreadDumpMsgInternal> dumps) {
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (ThreadDumpMsgInternal dump : dumps.values()) {
            result.put(dump.getTimestamp(), dump.getReason());
        }
        return result;
    }

    public String getThreadDump(String id) {
        try {
            ThreadDumpMsgInternal dump = (ThreadDumpMsgInternal)this.threadDumps.get(Long.parseLong(id));
            if (dump != null) {
                return FileUtils.readFileToString((File)new File(dump.getDump()));
            }
            return null;
        }
        catch (Exception e) {
            log.error("Failed to load threaddump", (Throwable)e);
            return null;
        }
    }

    public void requestThreadDump() {
        if (this.isRunning()) {
            this.jvmConnection.send((Serializable)new ThreadDumpRequestMsgInternal());
        }
    }

    private void notifyUserConnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.UserConnected, this.webConnection);
    }

    private void notifyUserDisconnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.UserDisconnected, this.webConnection);
    }

    private void notifyMirrorViewConnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.MirrorViewConnected, this.mirroredWebConnection);
    }

    private void notifyMirrorViewDisconnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.MirrorViewDisconnected, this.mirroredWebConnection);
    }

    private void sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType type, WebSocketConnection r) {
        ApiEventMsgInternal event;
        if (r != null && r.getUser() != null) {
            AbstractWebswingUser connectedUser = r.getUser();
            event = new ApiEventMsgInternal(type, new Serializable[]{connectedUser.getUserId(), new HashMap(connectedUser.getUserAttributes())});
        } else {
            event = new ApiEventMsgInternal(type, new Serializable[]{null, null});
        }
        this.jvmConnection.send((Serializable)event);
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    static /* synthetic */ void access$000(SwingInstanceImpl x0) {
        x0.close();
    }
}

