/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.WebswingService;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.playback.RecordingPlaybackUrlHandlerImpl;
import org.webswing.server.services.security.SecurityManagerService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.websocket.SecuredAtmosphereFramework;
import org.webswing.server.services.websocket.WebSocketAtmosphereHandler;
import org.webswing.server.services.websocket.WebSocketMessageListener;
import org.webswing.server.services.websocket.WebSocketService;
import org.webswing.server.services.websocket.WebSocketUrlHandler;
import org.webswing.server.services.websocket.WebSocketUrlHandlerImpl;
import org.webswing.server.util.ServerUtil;

@Singleton
public class WebSocketServiceImpl
implements WebswingService,
WebSocketService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketService.class);
    private static final String WEBSOCKET_MESSAGE_SIZE = System.getProperty("webswing.websocketMessageSizeLimit", "65536");
    private static final String WEBSOCKET_THREADPOOL_SIZE = System.getProperty("webswing.websocketThreadPoolLimit", "10");
    private static final Class<?>[] jsonInterceptors = new Class[]{AtmosphereResourceLifecycleInterceptor.class, TrackMessageSizeInterceptor.class, SuspendTrackerInterceptor.class};
    private static final Class<?>[] binaryInterceptors = new Class[]{AtmosphereResourceLifecycleInterceptor.class, SuspendTrackerInterceptor.class};
    private static final String BINARY_HANDLER_PATH = "/async/swing-bin";
    private static final String JSON_HANDLER_PATH = "/async/swing";
    private static final String PLAYBACK_HANDLER_WS_PATH = "/async/swing-play";
    private static final String PLAYBACK_HANDLER_PATH = "/playback/async/swing-play";
    private final SecuredAtmosphereFramework framework;
    private final ServletContext context;
    private Map<String, WebSocketAtmosphereHandler> websocketEndpoints = new HashMap();

    @Inject
    public WebSocketServiceImpl(ServletContext context, SecurityManagerService securityManager) {
        this.context = context;
        this.framework = new SecuredAtmosphereFramework(securityManager);
    }

    public void start() throws WsInitException {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("org.atmosphere.websocket.maxTextMessageSize", WEBSOCKET_MESSAGE_SIZE);
        initParams.put("org.atmosphere.websocket.maxBinaryMessageSize", WEBSOCKET_MESSAGE_SIZE);
        initParams.put("org.atmosphere.cpr.broadcaster.maxProcessingThreads", WEBSOCKET_THREADPOOL_SIZE);
        initParams.put("org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads", WEBSOCKET_THREADPOOL_SIZE);
        initParams.put("org.atmosphere.cpr.broadcaster.shareableThreadPool", "true");
        initParams.put("org.atmosphere.cpr.scanClassPath", "false");
        initParams.put("org.atmosphere.cpr.AtmosphereFramework.analytics", "false");
        initParams.put("org.atmosphere.cpr.broadcasterCacheClass", "org.atmosphere.cache.UUIDBroadcasterCache");
        initParams.put("org.atmosphere.container.JSR356AsyncSupport.mappingPath", "/{PATH}");
        try {
            this.framework.init((ServletConfig)new /* Unavailable Anonymous Inner Class!! */, false);
            initParams.put("org.atmosphere.container.JSR356AsyncSupport.mappingPath", ServerUtil.getContextPath((ServletContext)this.context));
            this.websocketEndpoints.put(JSON_HANDLER_PATH, new WebSocketAtmosphereHandler());
            this.websocketEndpoints.put(BINARY_HANDLER_PATH, new WebSocketAtmosphereHandler());
            this.websocketEndpoints.put(PLAYBACK_HANDLER_PATH, new WebSocketAtmosphereHandler());
            this.framework.addAtmosphereHandler("*/async/swing", (AtmosphereHandler)this.websocketEndpoints.get(JSON_HANDLER_PATH), this.instantiate(jsonInterceptors));
            this.framework.addAtmosphereHandler("*/async/swing-bin", (AtmosphereHandler)this.websocketEndpoints.get(BINARY_HANDLER_PATH), this.instantiate(binaryInterceptors));
            this.framework.addAtmosphereHandler("*/async/swing-play", (AtmosphereHandler)this.websocketEndpoints.get(PLAYBACK_HANDLER_PATH), this.instantiate(binaryInterceptors));
        }
        catch (ServletException e) {
            throw new WsInitException("Failed to initialize Websocket framework", (Throwable)e);
        }
    }

    public void stop() {
        this.framework.destroy();
    }

    private List<AtmosphereInterceptor> instantiate(Class<?>[] interceptors) {
        ArrayList<AtmosphereInterceptor> result = new ArrayList<AtmosphereInterceptor>();
        for (Class<?> c : interceptors) {
            if (!AtmosphereInterceptor.class.isAssignableFrom(c)) continue;
            try {
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                result.add((AtmosphereInterceptor)constructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                log.error("Failed to initialize Atmosphere Interceptors.", (Throwable)e);
            }
        }
        return result;
    }

    public WebSocketUrlHandler createBinaryWebSocketHandler(PrimaryUrlHandler parent, SwingInstanceManager instanceManager) {
        WebSocketUrlHandlerImpl result = new WebSocketUrlHandlerImpl(parent, BINARY_HANDLER_PATH, (WebSocketService)this, instanceManager);
        WebSocketAtmosphereHandler endpoint = (WebSocketAtmosphereHandler)this.websocketEndpoints.get(BINARY_HANDLER_PATH);
        endpoint.addHandler(result.getFullPathMapping(), (WebSocketMessageListener)result);
        return result;
    }

    public WebSocketUrlHandler createJsonWebSocketHandler(PrimaryUrlHandler parent, SwingInstanceManager instanceManager) {
        WebSocketUrlHandlerImpl result = new WebSocketUrlHandlerImpl(parent, JSON_HANDLER_PATH, (WebSocketService)this, instanceManager);
        WebSocketAtmosphereHandler endpoint = (WebSocketAtmosphereHandler)this.websocketEndpoints.get(JSON_HANDLER_PATH);
        endpoint.addHandler(result.getFullPathMapping(), (WebSocketMessageListener)result);
        return result;
    }

    public WebSocketUrlHandler createPlaybackWebSocketHandler(PrimaryUrlHandler parent) {
        RecordingPlaybackUrlHandlerImpl result = new RecordingPlaybackUrlHandlerImpl(parent, PLAYBACK_HANDLER_PATH, (WebSocketService)this);
        WebSocketAtmosphereHandler endpoint = (WebSocketAtmosphereHandler)this.websocketEndpoints.get(PLAYBACK_HANDLER_PATH);
        endpoint.addHandler(result.getFullPathMapping(), (WebSocketMessageListener)result);
        return result;
    }

    public void serve(WebSocketUrlHandler handler, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        WebSocketAtmosphereHandler endpoint = (WebSocketAtmosphereHandler)this.websocketEndpoints.get(handler.getPathMapping());
        endpoint.addHandler(req, (WebSocketMessageListener)handler);
        this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)req), AtmosphereResponseImpl.wrap((HttpServletResponse)res));
    }

    public void disconnectWebsockets(Serializable sessionId) {
        BroadcasterFactory f = this.framework.getBroadcasterFactory();
        for (Broadcaster b : f.lookupAll()) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                Subject subject = (Subject)r.getRequest().getAttribute("webswingSecuritySubject");
                if (subject == null || !subject.getSession().getId().equals(sessionId)) continue;
                try {
                    r.close();
                }
                catch (IOException e) {
                    log.error("Failed to close websocket connection " + r.uuid());
                }
            }
        }
    }

    static /* synthetic */ ServletContext access$000(WebSocketServiceImpl x0) {
        return x0.context;
    }
}

