/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.GlobalUrlHandler;
import org.webswing.server.WebswingServerModule;
import org.webswing.server.WebswingServlet;
import org.webswing.server.services.security.SecurableService;
import org.webswing.server.services.security.SecurityManagerService;
import org.webswing.server.services.startup.StartupService;

@WebServlet(asyncSupported=true, displayName="WebswingServlet", urlPatterns={"/*"})
@MultipartConfig(fileSizeThreshold=0x500000)
public class WebswingServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(StartupService.class);
    private static final long serialVersionUID = 1962501775857788874L;
    private StartupService startup;
    private GlobalUrlHandler handler;
    private SecurityManagerService securityManager;

    public void init() throws ServletException {
        1 servletModule = new /* Unavailable Anonymous Inner Class!! */;
        Injector injector = Guice.createInjector((Module[])new Module[]{servletModule, new WebswingServerModule()});
        this.securityManager = (SecurityManagerService)injector.getInstance(SecurityManagerService.class);
        try {
            this.securityManager.start();
            this.startup = (StartupService)injector.getInstance(StartupService.class);
            this.startup.start();
            this.handler = (GlobalUrlHandler)injector.getInstance(GlobalUrlHandler.class);
            this.handler.init();
        }
        catch (Exception e) {
            log.error("Initialization of Webswing failed. ", (Throwable)e);
            this.destroy();
            throw new ServletException("Webswing failed to start!", (Throwable)e);
        }
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) {
        this.securityManager.secure((SecurableService)this.handler, req, res);
    }

    public void destroy() {
        if (this.handler != null) {
            this.handler.destroy();
        }
        if (this.startup != null) {
            this.startup.stop();
        }
        if (this.securityManager != null) {
            this.securityManager.stop();
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.handler.getLastModified(req);
    }
}

