/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.webswing.server.services.security.LoginTokenAdapter;
import org.webswing.server.services.security.LogoutTokenAdapter;
import org.webswing.server.services.security.WebswingAuthenticationInfo;
import org.webswing.server.services.security.WebswingPrincipal;

public class WebswingRealmAdapter
extends AuthorizingRealm {
    public static final String WEBSWING_REALM = "webswingRealm";

    public WebswingRealmAdapter() {
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    public String getName() {
        return WEBSWING_REALM;
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof LoginTokenAdapter;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        WebswingAuthenticationInfo info = null;
        if (token instanceof LoginTokenAdapter) {
            WebswingPrincipal user = (WebswingPrincipal)token.getPrincipal();
            if (SecurityUtils.getSubject().getPrincipals() == null && !(token instanceof LogoutTokenAdapter)) {
                info = new WebswingAuthenticationInfo((PrincipalCollection)new SimplePrincipalCollection((Object)user, WEBSWING_REALM), token.getCredentials());
            } else {
                ArrayList<WebswingPrincipal> principals = new ArrayList<WebswingPrincipal>(SecurityUtils.getSubject().getPrincipals().byType(WebswingPrincipal.class));
                Iterator i = principals.iterator();
                while (i.hasNext()) {
                    WebswingPrincipal p = (WebswingPrincipal)i.next();
                    if (!user.getSecuredPath().equals(p.getSecuredPath())) continue;
                    i.remove();
                }
                if (!(token instanceof LogoutTokenAdapter)) {
                    principals.add(user);
                }
                if (principals.size() > 0) {
                    info = new WebswingAuthenticationInfo((PrincipalCollection)new SimplePrincipalCollection(principals, WEBSWING_REALM), token.getCredentials());
                } else {
                    throw new AuthenticationException("No principal found.");
                }
            }
        }
        return info;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo sai = new SimpleAuthorizationInfo();
        for (WebswingPrincipal p : principals.byType(WebswingPrincipal.class)) {
            sai.addObjectPermission((Permission)p);
        }
        return sai;
    }
}

