/*
 ByteBuffer.js (c) 2013-2014 Daniel Wirtz <dcode@dcode.io>
 This version of ByteBuffer.js uses an ArrayBuffer (AB) as its backing buffer and is compatible with modern browsers.
 Released under the Apache License, Version 2.0
 see: https://github.com/dcodeIO/ByteBuffer.js for details
*/

(function(e){function t(e){function t(e,n,r){"undefined"==typeof e&&(e=t.DEFAULT_CAPACITY),"undefined"==typeof n&&(n=t.DEFAULT_ENDIAN),"undefined"==typeof r&&(r=t.DEFAULT_NOASSERT);if(!r){e|=0;if(0>e)throw RangeError("Illegal capacity");n=!!n,r=!!r}this.buffer=0===e?o:new ArrayBuffer(e),this.view=0===e?null:new DataView(this.buffer),this.offset=0,this.markedOffset=-1,this.limit=e,this.littleEndian="undefined"!=typeof n?!!n:!1,this.noAssert=!!r}function n(e){var t=0;return function(){return t<e.length?e.charCodeAt(t++):null}}function r(){var e=[],t=[];return function(){if(0===arguments.length)return t.join("")+u.apply(String,e);1024<e.length+arguments.length&&(t.push(u.apply(String,e)),e.length=0),Array.prototype.push.apply(e,arguments)}}t.VERSION="3.5.0",t.LITTLE_ENDIAN=!0,t.BIG_ENDIAN=!1,t.DEFAULT_CAPACITY=16,t.DEFAULT_ENDIAN=t.BIG_ENDIAN,t.DEFAULT_NOASSERT=!1,t.Long=e||null;var s=t.prototype,o=new ArrayBuffer(0),u=String.fromCharCode;t.allocate=function(e,n,r){return new t(e,n,r)},t.concat=function(e,n,r,i){if("boolean"==typeof n||"string"!=typeof n)i=r,r=n,n=void 0;for(var s=0,o=0,u=e.length,a;o<u;++o)t.isByteBuffer(e[o])||(e[o]=t.wrap(e[o],n)),a=e[o].limit-e[o].offset,0<a&&(s+=a);if(0===s)return new t(0,r,i);n=new t(s,r,i),i=new Uint8Array(n.buffer);for(o=0;o<u;)r=e[o++],a=r.limit-r.offset,0>=a||(i.set((new Uint8Array(r.buffer)).subarray(r.offset,r.limit),n.offset),n.offset+=a);return n.limit=n.offset,n.offset=0,n},t.isByteBuffer=function(e){return!0===(e&&e instanceof t)},t.type=function(){return ArrayBuffer},t.wrap=function(e,n,r,o){"string"!=typeof n&&(o=r,r=n,n=void 0);if("string"==typeof e)switch("undefined"==typeof n&&(n="utf8"),n){case"base64":return t.fromBase64(e,r);case"hex":return t.fromHex(e,r);case"binary":return t.fromBinary(e,r);case"utf8":return t.fromUTF8(e,r);case"debug":return t.fromDebug(e,r);default:throw Error("Unsupported encoding: "+n)}if(null===e||"object"!=typeof e)throw TypeError("Illegal buffer");if(t.isByteBuffer(e))return n=s.clone.call(e),n.markedOffset=-1,n;if(e instanceof Uint8Array)n=new t(0,r,o),0<e.length&&(n.buffer=e.buffer,n.offset=e.byteOffset,n.limit=e.byteOffset+e.length,n.view=0<e.length?new DataView(e.buffer):null);else if(e instanceof ArrayBuffer)n=new t(0,r,o),0<e.byteLength&&(n.buffer=e,n.offset=0,n.limit=e.byteLength,n.view=0<e.byteLength?new DataView(e):null);else{if("[object Array]"!==Object.prototype.toString.call(e))throw TypeError("Illegal buffer");for(n=new t(e.length,r,o),n.limit=e.length,i=0;i<e.length;++i)n.view.setUint8(i,e[i])}return n},s.writeInt8=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e|=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=1;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setInt8(t-1,e),n&&(this.offset+=1),this},s.writeByte=s.writeInt8,s.readInt8=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+1) <= "+this.buffer.byteLength)}return e=this.view.getInt8(e),t&&(this.offset+=1),e},s.readByte=s.readInt8,s.writeUint8=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=1;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setUint8(t-1,e),n&&(this.offset+=1),this},s.readUint8=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+1) <= "+this.buffer.byteLength)}return e=this.view.getUint8(e),t&&(this.offset+=1),e},s.writeInt16=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e|=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=2;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setInt16(t-2,e,this.littleEndian),n&&(this.offset+=2),this},s.writeShort=s.writeInt16,s.readInt16=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+2>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+2) <= "+this.buffer.byteLength)}return e=this.view.getInt16(e,this.littleEndian),t&&(this.offset+=2),e},s.readShort=s.readInt16,s.writeUint16=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=2;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setUint16(t-2,e,this.littleEndian),n&&(this.offset+=2),this},s.readUint16=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+2>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+2) <= "+this.buffer.byteLength)}return e=this.view.getUint16(e,this.littleEndian),t&&(this.offset+=2),e},s.writeInt32=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e|=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=4;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setInt32(t-4,e,this.littleEndian),n&&(this.offset+=4),this},s.writeInt=s.writeInt32,s.readInt32=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+4) <= "+this.buffer.byteLength)}return e=this.view.getInt32(e,this.littleEndian),t&&(this.offset+=4),e},s.readInt=s.readInt32,s.writeUint32=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=4;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setUint32(t-4,e,this.littleEndian),n&&(this.offset+=4),this},s.readUint32=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+4) <= "+this.buffer.byteLength)}return e=this.view.getUint32(e,this.littleEndian),t&&(this.offset+=4),e},e&&(s.writeInt64=function(t,n){var r="undefined"==typeof n;r&&(n=this.offset);if(!this.noAssert){if("number"==typeof t)t=e.fromNumber(t);else if(!(t&&t instanceof e))throw TypeError("Illegal value: "+t+" (not an integer or Long)");if("number"!=typeof n||0!==n%1)throw TypeError("Illegal offset: "+n+" (not an integer)");n>>>=0;if(0>n||n+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+n+" (+0) <= "+this.buffer.byteLength)}"number"==typeof t&&(t=e.fromNumber(t)),n+=8;var i=this.buffer.byteLength;return n>i&&this.resize((i*=2)>n?i:n),n-=8,this.littleEndian?(this.view.setInt32(n,t.low,!0),this.view.setInt32(n+4,t.high,!0)):(this.view.setInt32(n,t.high,!1),this.view.setInt32(n+4,t.low,!1)),r&&(this.offset+=8),this},s.writeLong=s.writeInt64,s.readInt64=function(t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+8>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+8) <= "+this.buffer.byteLength)}return t=this.littleEndian?new e(this.view.getInt32(t,!0),this.view.getInt32(t+4,!0),!1):new e(this.view.getInt32(t+4,!1),this.view.getInt32(t,!1),!1),n&&(this.offset+=8),t},s.readLong=s.readInt64,s.writeUint64=function(t,n){var r="undefined"==typeof n;r&&(n=this.offset);if(!this.noAssert){if("number"==typeof t)t=e.fromNumber(t);else if(!(t&&t instanceof e))throw TypeError("Illegal value: "+t+" (not an integer or Long)");if("number"!=typeof n||0!==n%1)throw TypeError("Illegal offset: "+n+" (not an integer)");n>>>=0;if(0>n||n+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+n+" (+0) <= "+this.buffer.byteLength)}"number"==typeof t&&(t=e.fromNumber(t)),n+=8;var i=this.buffer.byteLength;return n>i&&this.resize((i*=2)>n?i:n),n-=8,this.littleEndian?(this.view.setInt32(n,t.low,!0),this.view.setInt32(n+4,t.high,!0)):(this.view.setInt32(n,t.high,!1),this.view.setInt32(n+4,t.low,!1)),r&&(this.offset+=8),this},s.readUint64=function(t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+8>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+8) <= "+this.buffer.byteLength)}return t=this.littleEndian?new e(this.view.getInt32(t,!0),this.view.getInt32(t+4,!0),!0):new e(this.view.getInt32(t+4,!1),this.view.getInt32(t,!1),!0),n&&(this.offset+=8),t}),s.writeFloat32=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e)throw TypeError("Illegal value: "+e+" (not a number)");if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=4;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setFloat32(t-4,e,this.littleEndian),n&&(this.offset+=4),this},s.writeFloat=s.writeFloat32,s.readFloat32=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+4) <= "+this.buffer.byteLength)}return e=this.view.getFloat32(e,this.littleEndian),t&&(this.offset+=4),e},s.readFloat=s.readFloat32,s.writeFloat64=function(e,t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof e)throw TypeError("Illegal value: "+e+" (not a number)");if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}t+=8;var r=this.buffer.byteLength;return t>r&&this.resize((r*=2)>t?r:t),this.view.setFloat64(t-8,e,this.littleEndian),n&&(this.offset+=8),this},s.writeDouble=s.writeFloat64,s.readFloat64=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+8>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+8) <= "+this.buffer.byteLength)}return e=this.view.getFloat64(e,this.littleEndian),t&&(this.offset+=8),e},s.readDouble=s.readFloat64,t.MAX_VARINT32_BYTES=5,t.calculateVarint32=function(e){return e>>>=0,128>e?1:16384>e?2:2097152>e?3:268435456>e?4:5},t.zigZagEncode32=function(e){return((e|=0)<<1^e>>31)>>>0},t.zigZagDecode32=function(e){return e>>>1^-(e&1)|0},s.writeVarint32=function(e,n){var r="undefined"==typeof n;r&&(n=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e|=0;if("number"!=typeof n||0!==n%1)throw TypeError("Illegal offset: "+n+" (not an integer)");n>>>=0;if(0>n||n+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+n+" (+0) <= "+this.buffer.byteLength)}var i=t.calculateVarint32(e);n+=i;var s=this.buffer.byteLength;return n>s&&this.resize((s*=2)>n?s:n),n-=i,this.view.setUint8(n,i=e|128),e>>>=0,128<=e?(i=e>>7|128,this.view.setUint8(n+1,i),16384<=e?(i=e>>14|128,this.view.setUint8(n+2,i),2097152<=e?(i=e>>21|128,this.view.setUint8(n+3,i),268435456<=e?(this.view.setUint8(n+4,e>>28&15),i=5):(this.view.setUint8(n+3,i&127),i=4)):(this.view.setUint8(n+2,i&127),i=3)):(this.view.setUint8(n+1,i&127),i=2)):(this.view.setUint8(n,i&127),i=1),r?(this.offset+=i,this):i},s.writeVarint32ZigZag=function(e,n){return this.writeVarint32(t.zigZagEncode32(e),n)},s.readVarint32=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+1) <= "+this.buffer.byteLength)}var n=0,r=0,i;do{i=e+n;if(!this.noAssert&&i>this.limit)throw e=Error("Truncated"),e.truncated=!0,e;i=this.view.getUint8(i),5>n&&(r|=(i&127)<<7*n>>>0),++n}while(128===(i&128));return r|=0,t?(this.offset+=n,r):{value:r,length:n}},s.readVarint32ZigZag=function(e){return e=this.readVarint32(e),"object"==typeof e?e.value=t.zigZagDecode32(e.value):e=t.zigZagDecode32(e),e},e&&(t.MAX_VARINT64_BYTES=10,t.calculateVarint64=function(t){"number"==typeof t&&(t=e.fromNumber(t));var n=t.toInt()>>>0,r=t.shiftRightUnsigned(28).toInt()>>>0;return t=t.shiftRightUnsigned(56).toInt()>>>0,0==t?0==r?16384>n?128>n?1:2:2097152>n?3:4:16384>r?128>r?5:6:2097152>r?7:8:128>t?9:10},t.zigZagEncode64=function(t){return"number"==typeof t?t=e.fromNumber(t,!1):!1!==t.unsigned&&(t=t.toSigned()),t.shiftLeft(1).xor(t.shiftRight(63)).toUnsigned()},t.zigZagDecode64=function(t){return"number"==typeof t?t=e.fromNumber(t,!1):!1!==t.unsigned&&(t=t.toSigned()),t.shiftRightUnsigned(1).xor(t.and(e.ONE).toSigned().negate()).toSigned()},s.writeVarint64=function(n,r){var i="undefined"==typeof r;i&&(r=this.offset);if(!this.noAssert){if("number"==typeof n)n=e.fromNumber(n);else if(!(n&&n instanceof e))throw TypeError("Illegal value: "+n+" (not an integer or Long)");if("number"!=typeof r||0!==r%1)throw TypeError("Illegal offset: "+r+" (not an integer)");r>>>=0;if(0>r||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}"number"==typeof n?n=e.fromNumber(n,!1):!1!==n.unsigned&&(n=n.toSigned());var s=t.calculateVarint64(n),o=n.toInt()>>>0,u=n.shiftRightUnsigned(28).toInt()>>>0,a=n.shiftRightUnsigned(56).toInt()>>>0;r+=s;var f=this.buffer.byteLength;r>f&&this.resize((f*=2)>r?f:r),r-=s;switch(s){case 10:this.view.setUint8(r+9,a>>>7&1);case 9:this.view.setUint8(r+8,9!==s?a|128:a&127);case 8:this.view.setUint8(r+7,8!==s?u>>>21|128:u>>>21&127);case 7:this.view.setUint8(r+6,7!==s?u>>>14|128:u>>>14&127);case 6:this.view.setUint8(r+5,6!==s?u>>>7|128:u>>>7&127);case 5:this.view.setUint8(r+4,5!==s?u|128:u&127);case 4:this.view.setUint8(r+3,4!==s?o>>>21|128:o>>>21&127);case 3:this.view.setUint8(r+2,3!==s?o>>>14|128:o>>>14&127);case 2:this.view.setUint8(r+1,2!==s?o>>>7|128:o>>>7&127);case 1:this.view.setUint8(r,1!==s?o|128:o&127)}return i?(this.offset+=s,this):s},s.writeVarint64ZigZag=function(e,n){return this.writeVarint64(t.zigZagEncode64(e),n)},s.readVarint64=function(t){var n="undefined"==typeof t;n&&(t=this.offset);if(!this.noAssert){if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+1) <= "+this.buffer.byteLength)}var r=t,i=0,s=0,o=0,u=0,u=this.view.getUint8(t++),i=u&127;if(u&128&&(u=this.view.getUint8(t++),i|=(u&127)<<7,u&128&&(u=this.view.getUint8(t++),i|=(u&127)<<14,u&128&&(u=this.view.getUint8(t++),i|=(u&127)<<21,u&128&&(u=this.view.getUint8(t++),s=u&127,u&128&&(u=this.view.getUint8(t++),s|=(u&127)<<7,u&128&&(u=this.view.getUint8(t++),s|=(u&127)<<14,u&128&&(u=this.view.getUint8(t++),s|=(u&127)<<21,u&128&&(u=this.view.getUint8(t++),o=u&127,u&128&&(u=this.view.getUint8(t++),o|=(u&127)<<7,u&128))))))))))throw Error("Buffer overrun");return i=e.fromBits(i|s<<28,s>>>4|o<<24,!1),n?(this.offset=t,i):{value:i,length:t-r}},s.readVarint64ZigZag=function(n){return(n=this.readVarint64(n))&&n.value instanceof e?n.value=t.zigZagDecode64(n.value):n=t.zigZagDecode64(n),n}),s.writeCString=function(e,t){var r="undefined"==typeof t;r&&(t=this.offset);var i,s=e.length;if(!this.noAssert){if("string"!=typeof e)throw TypeError("Illegal str: Not a string");for(i=0;i<s;++i)if(0===e.charCodeAt(i))throw RangeError("Illegal str: Contains NULL-characters");if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}i=t,s=f.a(n(e))[1],t+=s+1;var o=this.buffer.byteLength;return t>o&&this.resize((o*=2)>t?o:t),t-=s+1,f.c(n(e),function(e){this.view.setUint8(t++,e)}.bind(this)),this.view.setUint8(t++,0),r?(this.offset=t-i,this):s},s.readCString=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+1) <= "+this.buffer.byteLength)}var n=e,i,s=-1;return f.b(function(){if(0===s)return null;if(e>=this.limit)throw RangeError("Illegal range: Truncated data, "+e+" < "+this.limit);return 0===(s=this.view.getUint8(e++))?null:s}.bind(this),i=r(),!0),t?(this.offset=e,i()):{string:i(),length:e-n}},s.writeIString=function(e,t){var r="undefined"==typeof t;r&&(t=this.offset);if(!this.noAssert){if("string"!=typeof e)throw TypeError("Illegal str: Not a string");if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}var i=t,s;s=f.a(n(e),this.noAssert)[1],t+=4+s;var o=this.buffer.byteLength;t>o&&this.resize((o*=2)>t?o:t),t-=4+s,this.view.setUint32(t,s,this.littleEndian),t+=4,f.c(n(e),function(e){this.view.setUint8(t++,e)}.bind(this));if(t!==i+4+s)throw RangeError("Illegal range: Truncated data, "+t+" == "+(t+4+s));return r?(this.offset=t,this):t-i},s.readIString=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+4) <= "+this.buffer.byteLength)}var n=0,i=e,n=this.view.getUint32(e,this.littleEndian);e+=4;var s=e+n;return f.b(function(){return e<s?this.view.getUint8(e++):null}.bind(this),n=r(),this.noAssert),n=n(),t?(this.offset=e,n):{string:n,length:e-i}},t.METRICS_CHARS="c",t.METRICS_BYTES="b",s.writeUTF8String=function(e,t){var r="undefined"==typeof t;r&&(t=this.offset);if(!this.noAssert){if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: "+t+" (not an integer)");t>>>=0;if(0>t||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}var i,s=t;i=f.a(n(e))[1],t+=i;var o=this.buffer.byteLength;return t>o&&this.resize((o*=2)>t?o:t),t-=i,f.c(n(e),function(e){this.view.setUint8(t++,e)}.bind(this)),r?(this.offset=t,this):t-s},s.writeString=s.writeUTF8String,t.calculateUTF8Chars=function(e){return f.a(n(e))[0]},t.calculateUTF8Bytes=function(e){return f.a(n(e))[1]},s.readUTF8String=function(e,n,i){"number"==typeof n&&(i=n,n=void 0);var s="undefined"==typeof i;s&&(i=this.offset),"undefined"==typeof n&&(n=t.METRICS_CHARS);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal length: "+e+" (not an integer)");e|=0;if("number"!=typeof i||0!==i%1)throw TypeError("Illegal offset: "+i+" (not an integer)");i>>>=0;if(0>i||i+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+i+" (+0) <= "+this.buffer.byteLength)}var o=0,u=i,a;if(n===t.METRICS_CHARS){a=r(),f.g(function(){return o<e&&i<this.limit?this.view.getUint8(i++):null}.bind(this),function(e){++o,f.e(e,a)}.bind(this));if(o!==e)throw RangeError("Illegal range: Truncated data, "+o+" == "+e);return s?(this.offset=i,a()):{string:a(),length:i-u}}if(n===t.METRICS_BYTES){if(!this.noAssert){if("number"!=typeof i||0!==i%1)throw TypeError("Illegal offset: "+i+" (not an integer)");i>>>=0;if(0>i||i+e>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+i+" (+"+e+") <= "+this.buffer.byteLength)}var c=i+e;f.b(function(){return i<c?this.view.getUint8(i++):null}.bind(this),a=r(),this.noAssert);if(i!==c)throw RangeError("Illegal range: Truncated data, "+i+" == "+c);return s?(this.offset=i,a()):{string:a(),length:i-u}}throw TypeError("Unsupported metrics: "+n)},s.readString=s.readUTF8String,s.writeVString=function(e,r){var i="undefined"==typeof r;i&&(r=this.offset);if(!this.noAssert){if("string"!=typeof e)throw TypeError("Illegal str: Not a string");if("number"!=typeof r||0!==r%1)throw TypeError("Illegal offset: "+r+" (not an integer)");r>>>=0;if(0>r||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}var s=r,o,u;o=f.a(n(e),this.noAssert)[1],u=t.calculateVarint32(o),r+=u+o;var a=this.buffer.byteLength;r>a&&this.resize((a*=2)>r?a:r),r-=u+o,r+=this.writeVarint32(o,r),f.c(n(e),function(e){this.view.setUint8(r++,e)}.bind(this));if(r!==s+o+u)throw RangeError("Illegal range: Truncated data, "+r+" == "+(r+o+u));return i?(this.offset=r,this):r-s},s.readVString=function(e){var t="undefined"==typeof e;t&&(e=this.offset);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+1) <= "+this.buffer.byteLength)}var n=this.readVarint32(e),i=e;e+=n.length;var n=n.value,s=e+n,n=r();return f.b(function(){return e<s?this.view.getUint8(e++):null}.bind(this),n,this.noAssert),n=n(),t?(this.offset=e,n):{string:n,length:e-i}},s.append=function(e,n,r){if("number"==typeof n||"string"!=typeof n)r=n,n=void 0;var i="undefined"==typeof r;i&&(r=this.offset);if(!this.noAssert){if("number"!=typeof r||0!==r%1)throw TypeError("Illegal offset: "+r+" (not an integer)");r>>>=0;if(0>r||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}e instanceof t||(e=t.wrap(e,n)),n=e.limit-e.offset;if(0>=n)return this;r+=n;var s=this.buffer.byteLength;return r>s&&this.resize((s*=2)>r?s:r),(new Uint8Array(this.buffer,r-n)).set((new Uint8Array(e.buffer)).subarray(e.offset,e.limit)),e.offset+=n,i&&(this.offset+=n),this},s.appendTo=function(e,t){return e.append(this,t),this},s.assert=function(e){return this.noAssert=!e,this},s.capacity=function(){return this.buffer.byteLength},s.clear=function(){return this.offset=0,this.limit=this.buffer.byteLength,this.markedOffset=-1,this},s.clone=function(e){var n=new t(0,this.littleEndian,this.noAssert);return e?(e=new ArrayBuffer(this.buffer.byteLength),(new Uint8Array(e)).set(this.buffer),n.buffer=e,n.view=new DataView(e)):(n.buffer=this.buffer,n.view=this.view),n.offset=this.offset,n.markedOffset=this.markedOffset,n.limit=this.limit,n},s.compact=function(e,t){"undefined"==typeof e&&(e=this.offset),"undefined"==typeof t&&(t=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}if(0===e&&t===this.buffer.byteLength)return this;var n=t-e;if(0===n)return this.buffer=o,this.view=null,0<=this.markedOffset&&(this.markedOffset-=e),this.limit=this.offset=0,this;var r=new ArrayBuffer(n);return(new Uint8Array(r)).set((new Uint8Array(this.buffer)).subarray(e,t)),this.buffer=r,this.view=new DataView(r),0<=this.markedOffset&&(this.markedOffset-=e),this.offset=0,this.limit=n,this},s.copy=function(e,n){"undefined"==typeof e&&(e=this.offset),"undefined"==typeof n&&(n=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof n||0!==n%1)throw TypeError("Illegal end: Not an integer");n>>>=0;if(0>e||e>n||n>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+n+" <= "+this.buffer.byteLength)}if(e===n)return new t(0,this.littleEndian,this.noAssert);var r=n-e,i=new t(r,this.littleEndian,this.noAssert);return i.offset=0,i.limit=r,0<=i.markedOffset&&(i.markedOffset-=e),this.copyTo(i,0,e,n),i},s.copyTo=function(e,n,r,i){var s,o;if(!this.noAssert&&!t.isByteBuffer(e))throw TypeError("Illegal target: Not a ByteBuffer");n=(o="undefined"==typeof n)?e.offset:n|0,r=(s="undefined"==typeof r)?this.offset:r|0,i="undefined"==typeof i?this.limit:i|0;if(0>n||n>e.buffer.byteLength)throw RangeError("Illegal target range: 0 <= "+n+" <= "+e.buffer.byteLength);if(0>r||i>this.buffer.byteLength)throw RangeError("Illegal source range: 0 <= "+r+" <= "+this.buffer.byteLength);var u=i-r;return 0===u?e:(e.ensureCapacity(n+u),(new Uint8Array(e.buffer)).set((new Uint8Array(this.buffer)).subarray(r,i),n),s&&(this.offset+=u),o&&(e.offset+=u),this)},s.ensureCapacity=function(e){var t=this.buffer.byteLength;return t<e?this.resize((t*=2)>e?t:e):this},s.fill=function(e,t,n){var r="undefined"==typeof t;r&&(t=this.offset),"string"==typeof e&&0<e.length&&(e=e.charCodeAt(0)),"undefined"==typeof t&&(t=this.offset),"undefined"==typeof n&&(n=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal value: "+e+" (not an integer)");e|=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal begin: Not an integer");t>>>=0;if("number"!=typeof n||0!==n%1)throw TypeError("Illegal end: Not an integer");n>>>=0;if(0>t||t>n||n>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+n+" <= "+this.buffer.byteLength)}if(t>=n)return this;for(;t<n;)this.view.setUint8(t++,e);return r&&(this.offset=t),this},s.flip=function(){return this.limit=this.offset,this.offset=0,this},s.mark=function(e){e="undefined"==typeof e?this.offset:e;if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal offset: "+e+" (not an integer)");e>>>=0;if(0>e||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}return this.markedOffset=e,this},s.order=function(e){if(!this.noAssert&&"boolean"!=typeof e)throw TypeError("Illegal littleEndian: Not a boolean");return this.littleEndian=!!e,this},s.LE=function(e){return this.littleEndian="undefined"!=typeof e?!!e:!0,this},s.BE=function(e){return this.littleEndian="undefined"!=typeof e?!e:!1,this},s.prepend=function(e,n,r){if("number"==typeof n||"string"!=typeof n)r=n,n=void 0;var i="undefined"==typeof r;i&&(r=this.offset);if(!this.noAssert){if("number"!=typeof r||0!==r%1)throw TypeError("Illegal offset: "+r+" (not an integer)");r>>>=0;if(0>r||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}e instanceof t||(e=t.wrap(e,n)),n=e.limit-e.offset;if(0>=n)return this;var s=n-r,o;if(0<s){var u=new ArrayBuffer(this.buffer.byteLength+s);o=new Uint8Array(u),o.set((new Uint8Array(this.buffer)).subarray(r,this.buffer.byteLength),n),this.buffer=u,this.view=new DataView(u),this.offset+=s,0<=this.markedOffset&&(this.markedOffset+=s),this.limit+=s,r+=s}else o=new Uint8Array(this.buffer);return o.set((new Uint8Array(e.buffer)).subarray(e.offset,e.limit),r-n),e.offset=e.limit,i&&(this.offset-=n),this},s.prependTo=function(e,t){return e.prepend(this,t),this},s.printDebug=function(e){"function"!=typeof e&&(e=console.log.bind(console)),e(this.toString()+"\n-------------------------------------------------------------------\n"+this.toDebug(!0))},s.remaining=function(){return this.limit-this.offset},s.reset=function(){return 0<=this.markedOffset?(this.offset=this.markedOffset,this.markedOffset=-1):this.offset=0,this},s.resize=function(e){if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal capacity: "+e+" (not an integer)");e|=0;if(0>e)throw RangeError("Illegal capacity: 0 <= "+e)}return this.buffer.byteLength<e&&(e=new ArrayBuffer(e),(new Uint8Array(e)).set(new Uint8Array(this.buffer)),this.buffer=e,this.view=new DataView(e)),this},s.reverse=function(e,t){"undefined"==typeof e&&(e=this.offset),"undefined"==typeof t&&(t=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}return e===t?this:(Array.prototype.reverse.call((new Uint8Array(this.buffer)).subarray(e,t)),this.view=new DataView(this.buffer),this)},s.skip=function(e){if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal length: "+e+" (not an integer)");e|=0}var t=this.offset+e;if(!this.noAssert&&(0>t||t>this.buffer.byteLength))throw RangeError("Illegal length: 0 <= "+this.offset+" + "+e+" <= "+this.buffer.byteLength);return this.offset=t,this},s.slice=function(e,t){"undefined"==typeof e&&(e=this.offset),"undefined"==typeof t&&(t=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}var n=this.clone();return n.offset=e,n.limit=t,n},s.toBuffer=function(e){var t=this.offset,n=this.limit;if(t>n)var r=t,t=n,n=r;if(!this.noAssert){if("number"!=typeof t||0!==t%1)throw TypeError("Illegal offset: Not an integer");t>>>=0;if("number"!=typeof n||0!==n%1)throw TypeError("Illegal limit: Not an integer");n>>>=0;if(0>t||t>n||n>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+n+" <= "+this.buffer.byteLength)}return!e&&0===t&&n===this.buffer.byteLength?this.buffer:t===n?o:(e=new ArrayBuffer(n-t),(new Uint8Array(e)).set((new Uint8Array(this.buffer)).subarray(t,n),0),e)},s.toArrayBuffer=s.toBuffer,s.toString=function(e,t,n){if("undefined"==typeof e)return"ByteBufferAB(offset="+this.offset+",markedOffset="+this.markedOffset+",limit="+this.limit+",capacity="+this.capacity()+")";"number"==typeof e&&(n=t=e="utf8");switch(e){case"utf8":return this.toUTF8(t,n);case"base64":return this.toBase64(t,n);case"hex":return this.toHex(t,n);case"binary":return this.toBinary(t,n);case"debug":return this.toDebug();case"columns":return this.m();default:throw Error("Unsupported encoding: "+e)}};var a=function(){for(var e={},t=[65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,48,49,50,51,52,53,54,55,56,57,43,47],n=[],r=0,i=t.length;r<i;++r)n[t[r]]=r;return e.i=function(e,n){for(var r,i;null!==(r=e());)n(t[r>>2&63]),i=(r&3)<<4,null!==(r=e())?(i|=r>>4&15,n(t[(i|r>>4&15)&63]),i=(r&15)<<2,null!==(r=e())?(n(t[(i|r>>6&3)&63]),n(t[r&63])):(n(t[i&63]),n(61))):(n(t[i&63]),n(61),n(61))},e.h=function(e,t){function r(e){throw Error("Illegal character code: "+e)}for(var i,s,o;null!==(i=e());)if(s=n[i],"undefined"==typeof s&&r(i),null!==(i=e())&&(o=n[i],"undefined"==typeof o&&r(i),t(s<<2>>>0|(o&48)>>4),null!==(i=e()))){s=n[i];if("undefined"==typeof s){if(61===i)break;r(i)}t((o&15)<<4>>>0|(s&60)>>2);if(null!==(i=e())){o=n[i];if("undefined"==typeof o){if(61===i)break;r(i)}t((s&3)<<6>>>0|o)}}},e.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)},e}();s.toBase64=function(e,t){"undefined"==typeof e&&(e=this.offset),"undefined"==typeof t&&(t=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}var n;return a.i(function(){return e<t?this.view.getUint8(e++):null}.bind(this),n=r()),n()},t.fromBase64=function(e,r,i){if(!i){if("string"!=typeof e)throw TypeError("Illegal str: Not a string");if(0!==e.length%4)throw TypeError("Illegal str: Length not a multiple of 4")}var s=new t(e.length/4*3,r,i),o=0;return a.h(n(e),function(e){s.view.setUint8(o++,e)}),s.limit=o,s},t.btoa=function(e){return t.fromBinary(e).toBase64()},t.atob=function(e){return t.fromBase64(e).toBinary()},s.toBinary=function(e,t){e="undefined"==typeof e?this.offset:e,t="undefined"==typeof t?this.limit:t;if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}if(e===t)return"";for(var n=[],r=[];e<t;)n.push(this.view.getUint8(e++)),1024<=n.length&&(r.push(String.fromCharCode.apply(String,n)),n=[]);return r.join("")+String.fromCharCode.apply(String,n)},t.fromBinary=function(e,n,r){if(!r&&"string"!=typeof e)throw TypeError("Illegal str: Not a string");for(var i=0,s=e.length,o=new t(s,n,r);i<s;){n=e.charCodeAt(i);if(!r&&255<n)throw RangeError("Illegal charCode at "+i+": 0 <= "+n+" <= 255");o.view.setUint8(i++,n)}return o.limit=s,o},s.toDebug=function(e){for(var t=-1,n=this.buffer.byteLength,r,i="",s="",o="";t<n;){-1!==t&&(r=this.view.getUint8(t),i=16>r?i+("0"+r.toString(16).toUpperCase()):i+r.toString(16).toUpperCase(),e&&(s+=32<r&&127>r?String.fromCharCode(r):".")),++t;if(e&&0<t&&0===t%16&&t!==n){for(;51>i.length;)i+=" ";o+=i+s+"\n",i=s=""}i=t===this.offset&&t===this.limit?i+(t===this.markedOffset?"!":"|"):t===this.offset?i+(t===this.markedOffset?"[":"<"):t===this.limit?i+(t===this.markedOffset?"]":">"):i+(t===this.markedOffset?"'":e||0!==t&&t!==n?" ":"")}if(e&&" "!==i){for(;51>i.length;)i+=" ";o+=i+s+"\n"}return e?o:i},t.fromDebug=function(e,n,r){var i=e.length;n=new t((i+1)/3|0,n,r);for(var s=0,o=0,u,a=!1,f=!1,l=!1,c=!1,h=!1;s<i;){switch(u=e.charAt(s++)){case"!":if(!r){if(f||l||c){h=!0;break}f=l=c=!0}n.offset=n.markedOffset=n.limit=o,a=!1;break;case"|":if(!r){if(f||c){h=!0;break}f=c=!0}n.offset=n.limit=o,a=!1;break;case"[":if(!r){if(f||l){h=!0;break}f=l=!0}n.offset=n.markedOffset=o,a=!1;break;case"<":if(!r){if(f){h=!0;break}f=!0}n.offset=o,a=!1;break;case"]":if(!r){if(c||l){h=!0;break}c=l=!0}n.limit=n.markedOffset=o,a=!1;break;case">":if(!r){if(c){h=!0;break}c=!0}n.limit=o,a=!1;break;case"'":if(!r){if(l){h=!0;break}l=!0}n.markedOffset=o,a=!1;break;case" ":a=!1;break;default:if(!r&&a){h=!0;break}u=parseInt(u+e.charAt(s++),16);if(!r&&(isNaN(u)||0>u||255<u))throw TypeError("Illegal str: Not a debug encoded string");n.view.setUint8(o++,u),a=!0}if(h)throw TypeError("Illegal str: Invalid symbol at "+s)}if(!r){if(!f||!c)throw TypeError("Illegal str: Missing offset or limit");if(o<n.buffer.byteLength)throw TypeError("Illegal str: Not a debug encoded string (is it hex?) "+o+" < "+i)}return n},s.toHex=function(e,t){e="undefined"==typeof e?this.offset:e,t="undefined"==typeof t?this.limit:t;if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}for(var n=Array(t-e),r;e<t;)r=this.view.getUint8(e++),16>r?n.push("0",r.toString(16)):n.push(r.toString(16));return n.join("")},t.fromHex=function(e,n,r){if(!r){if("string"!=typeof e)throw TypeError("Illegal str: Not a string");if(0!==e.length%2)throw TypeError("Illegal str: Length not a multiple of 2")}var i=e.length;n=new t(i/2|0,n);for(var s,o=0,u=0;o<i;o+=2){s=parseInt(e.substring(o,o+2),16);if(!r&&(!isFinite(s)||0>s||255<s))throw TypeError("Illegal str: Contains non-hex characters");n.view.setUint8(u++,s)}return n.limit=u,n};var f=function(){var e={k:1114111,j:function(e,t){var n=null;"number"==typeof e&&(n=e,e=function(){return null});for(;null!==n||null!==(n=e());)128>n?t(n&127):(2048>n?t(n>>6&31|192):(65536>n?t(n>>12&15|224):(t(n>>18&7|240),t(n>>12&63|128)),t(n>>6&63|128)),t(n&63|128)),n=null},g:function(e,t){function n(e){e=e.slice(0,e.indexOf(null));var t=Error(e.toString());throw t.name="TruncatedError",t.bytes=e,t}for(var r,i,s,o;null!==(r=e());)if(0===(r&128))t(r);else if(192===(r&224))null===(i=e())&&n([r,i]),t((r&31)<<6|i&63);else if(224===(r&240))null!==(i=e())&&null!==(s=e())||n([r,i,s]),t((r&15)<<12|(i&63)<<6|s&63);else{if(240!==(r&248))throw RangeError("Illegal starting byte: "+r);null!==(i=e())&&null!==(s=e())&&null!==(o=e())||n([r,i,s,o]),t((r&7)<<18|(i&63)<<12|(s&63)<<6|o&63)}},d:function(e,t){for(var n,r=null;null!==(n=null!==r?r:e());)55296<=n&&57343>=n&&null!==(r=e())&&56320<=r&&57343>=r?(t(1024*(n-55296)+r-56320+65536),r=null):t(n);null!==r&&t(r)},e:function(e,t){var n=null;"number"==typeof e&&(n=e,e=function(){return null});for(;null!==n||null!==(n=e());)65535>=n?t(n):(n-=65536,t((n>>10)+55296),t(n%1024+56320)),n=null},c:function(t,n){e.d(t,function(t){e.j(t,n)})},b:function(t,n){e.g(t,function(t){e.e(t,n)})},f:function(e){return 128>e?1:2048>e?2:65536>e?3:4},l:function(t){for(var n,r=0;null!==(n=t());)r+=e.f(n);return r},a:function(t){var n=0,r=0;return e.d(t,function(t){++n,r+=e.f(t)}),[n,r]}};return e}();return s.toUTF8=function(e,t){"undefined"==typeof e&&(e=this.offset),"undefined"==typeof t&&(t=this.limit);if(!this.noAssert){if("number"!=typeof e||0!==e%1)throw TypeError("Illegal begin: Not an integer");e>>>=0;if("number"!=typeof t||0!==t%1)throw TypeError("Illegal end: Not an integer");t>>>=0;if(0>e||e>t||t>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+t+" <= "+this.buffer.byteLength)}var n;try{f.b(function(){return e<t?this.view.getUint8(e++):null}.bind(this),n=r())}catch(i){if(e!==t)throw RangeError("Illegal range: Truncated data, "+e+" != "+t)}return n()},t.fromUTF8=function(e,r,i){if(!i&&"string"!=typeof e)throw TypeError("Illegal str: Not a string");var s=new t(f.a(n(e),!0)[1],r,i),o=0;return f.c(n(e),function(e){s.view.setUint8(o++,e)}),s.limit=o,s},t}"function"==typeof require&&"object"==typeof module&&module&&module.id&&"object"==typeof exports&&exports?module.exports=function(){var e;try{e=require("long")}catch(n){}return t(e)}():"function"==typeof webswingRequirejs.define&&webswingRequirejs.define.amd?webswingRequirejs.define("ByteBuffer",["Long"],function(e){return t(e)}):(e.dcodeIO=e.dcodeIO||{}).ByteBuffer=t(e.dcodeIO.Long)})(this);