/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.admin.InstanceManagerStatus;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.model.rest.LogRequest;
import org.webswing.server.common.model.rest.LogResponse;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationChangeListener;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.security.api.BuiltInModules;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.security.api.WebswingSecurityConfig;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceHolder;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.SwingInstanceManagerService;
import org.webswing.server.services.websocket.WebSocketService;
import org.webswing.server.util.LogReaderUtil;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class GlobalUrlHandler
extends PrimaryUrlHandler
implements SwingInstanceHolder,
SecuredPathHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalUrlHandler.class);
    private static final String SERVERNAME = System.getProperty("webswing.brandingPrefix", "webswing.org");
    private final WebSocketService websocket;
    private final ConfigurationService configService;
    private final SwingInstanceManagerService appFactory;
    private final ResourceHandlerService resourceService;
    private final LoginHandlerService loginService;
    private ServletContext servletContext;
    private Map<String, SwingInstanceManager> instanceManagers = new LinkedHashMap();
    private final ConfigurationChangeListener changeListener = new /* Unavailable Anonymous Inner Class!! */;

    @Inject
    public GlobalUrlHandler(WebSocketService websocket, ConfigurationService config, SwingInstanceManagerService appFactory, ResourceHandlerService resourceService, SecurityModuleService securityService, LoginHandlerService loginService, ServletContext servletContext) {
        super(null, securityService, config);
        this.websocket = websocket;
        this.configService = config;
        this.appFactory = appFactory;
        this.resourceService = resourceService;
        this.loginService = loginService;
        this.servletContext = servletContext;
    }

    public void init() {
        this.registerChildUrlHandler((UrlHandler)this.websocket.createPlaybackWebSocketHandler((PrimaryUrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLoginHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLogoutHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.resourceService.create((UrlHandler)this, (SecurityContext)this));
        this.loadApplications();
        super.init();
        this.configService.registerChangeListener(this.changeListener);
        if (!InstanceManagerStatus.Status.Running.equals((Object)this.getStatus().getStatus())) {
            throw new RuntimeException("Failed to start primary handler.");
        }
    }

    public void destroy() {
        this.configService.removeChangeListener(this.changeListener);
        this.instanceManagers.clear();
        super.destroy();
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) {
        try {
            this.setSecurityHeaders(req, res);
            boolean served = super.serve(req, res);
            if (!served) {
                throw new WsException("Not Found.", 404);
            }
        }
        catch (Exception e) {
            this.handleException(e, req, res);
        }
        return true;
    }

    private void setSecurityHeaders(HttpServletRequest req, HttpServletResponse res) {
        res.addHeader("Server", SERVERNAME);
        if (!Boolean.getBoolean("webswing.disableHttpSecurityHeaders")) {
            res.addHeader("X-Frame-Options", "SAMEORIGIN");
            res.addHeader("X-Content-Type-Options", "nosniff");
            res.addHeader("X-XSS-Protection", "1; mode=block");
            res.addHeader("Referrer-Policy", "strict-origin-when-cross-origin");
            if (StringUtils.equalsIgnoreCase((String)req.getScheme(), (String)"https")) {
                res.addHeader("Strict-Transport-Security", "1; mode=block");
            }
        }
    }

    protected WebswingSecurityConfig getSecurityConfig() {
        log.info("Loading master security module.(" + this.getConfig().getSecurity() + ").");
        WebswingSecurityConfig secConfig = super.getSecurityConfig();
        if (BuiltInModules.INHERITED.name().equals(secConfig.getModule())) {
            log.error("Master security module INHERITED is not valid. Falling back to default module PROPERTY_FILE.");
            SecuredPathConfig newconfig = this.getConfig();
            newconfig.getSecurity().put("module", BuiltInModules.PROPERTY_FILE.name());
            secConfig = (WebswingSecurityConfig)newconfig.getValueAs("security", WebswingSecurityConfig.class);
        }
        return secConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadApplications() {
        log.info("Loading configured Applications.");
        Map map = this.instanceManagers;
        synchronized (map) {
            for (String path : this.configService.getPaths()) {
                SecuredPathConfig configPath = this.configService.getConfiguration(path);
                String pathMapping = GlobalUrlHandler.toPath((String)path);
                if (GlobalUrlHandler.toPath((String)"/").equals(pathMapping)) continue;
                SwingInstanceManager childHandler = (SwingInstanceManager)this.instanceManagers.get(pathMapping);
                if (childHandler == null) {
                    this.installApplication(configPath);
                    continue;
                }
                log.error("Application with path '" + pathMapping + "' already exists! Application skipped.", (Throwable)new IllegalStateException("Invalid Application configuration."));
            }
        }
    }

    public SwingInstanceManager installApplication(SecuredPathConfig swing) {
        log.info("Installing application " + swing.getPath());
        SwingInstanceManager app = this.appFactory.createApp((UrlHandler)this, swing.getPath());
        this.registerFirstChildUrlHandler((UrlHandler)app);
        return app;
    }

    public void uninstallApplication(SwingInstanceManager appToRemove) {
        log.info("Removing application " + appToRemove.getPathMapping());
        appToRemove.destroy();
        this.removeChildUrlHandler((UrlHandler)appToRemove);
    }

    private void handleException(Exception e, HttpServletRequest req, HttpServletResponse res) {
        log.debug("Failed to process request. " + req.getPathInfo(), (Throwable)e);
        try {
            if (e instanceof WsException) {
                if (!res.isCommitted()) {
                    WsException wse = (WsException)e;
                    res.sendError(wse.getReponseCode(), wse.getLocalizedMessage());
                }
            } else {
                log.error("Failed to process request. " + req.getPathInfo(), (Throwable)e);
                if (!res.isCommitted()) {
                    res.setStatus(500);
                    e.printStackTrace(new PrintStream((OutputStream)res.getOutputStream()));
                }
            }
        }
        catch (IOException e1) {
            log.error("Failed send error response to client. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFirstChildUrlHandler(UrlHandler handler) {
        super.registerFirstChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.put(manager.getPathMapping(), manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChildUrlHandler(UrlHandler handler) {
        super.registerChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.put(manager.getPathMapping(), manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildUrlHandler(UrlHandler handler) {
        super.removeChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.remove(manager.getPathMapping(), manager);
            }
        }
    }

    protected String getPath() {
        return "";
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingInstance findInstanceBySessionId(String uuid) {
        Map map = this.instanceManagers;
        synchronized (map) {
            for (SwingInstanceManager im : this.instanceManagers.values()) {
                SwingInstance instance = im.findInstanceBySessionId(uuid);
                if (instance == null) continue;
                return instance;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingInstance findInstanceByClientId(String clientId) {
        Map map = this.instanceManagers;
        synchronized (map) {
            for (SwingInstanceManager im : this.instanceManagers.values()) {
                SwingInstance instance = im.findInstanceByClientId(clientId);
                if (instance == null) continue;
                return instance;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SwingInstance> getAllInstances() {
        ArrayList<SwingInstance> result = new ArrayList<SwingInstance>();
        Map map = this.instanceManagers;
        synchronized (map) {
            for (SwingInstanceManager im : this.instanceManagers.values()) {
                result.addAll(im.getAllInstances());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SwingInstance> getAllClosedInstances() {
        ArrayList<SwingInstance> result = new ArrayList<SwingInstance>();
        Map map = this.instanceManagers;
        synchronized (map) {
            for (SwingInstanceManager im : this.instanceManagers.values()) {
                result.addAll(im.getAllClosedInstances());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SwingInstanceManager> getApplications() {
        ArrayList<SwingInstanceManager> result = new ArrayList<SwingInstanceManager>();
        Map map = this.instanceManagers;
        synchronized (map) {
            result.addAll(this.instanceManagers.values());
        }
        return result;
    }

    public URL getWebResource(String resource) {
        if (!this.isCustomIndexPage() && StringUtils.equals((String)"/index.html", (String)GlobalUrlHandler.toPath((String)resource))) {
            resource = System.getProperty("webswing.defaultWelcomePage", "/selector/index.html");
        }
        return super.getWebResource(resource);
    }

    private boolean isCustomIndexPage() {
        String customFolder = this.getConfig().getWebFolder();
        if (StringUtils.isBlank((String)customFolder)) {
            return false;
        }
        File customFolderFile = this.resolveFile(customFolder);
        return customFolderFile.isDirectory() && new File(customFolderFile, "index.html").isFile();
    }

    @GET
    @Path(value="/apps")
    public List<ApplicationInfoMsg> getApplicationInfo(HttpServletRequest req) throws WsException {
        this.checkMasterPermission(WebswingAction.rest_getApps);
        ArrayList<ApplicationInfoMsg> result = new ArrayList<ApplicationInfoMsg>();
        for (SwingInstanceManager mgr : this.getApplications()) {
            ApplicationInfoMsg applicationInfoMsg;
            if (!mgr.isEnabled() || !mgr.isUserAuthorized() || (applicationInfoMsg = mgr.getApplicationInfoMsg()) == null) continue;
            result.add(applicationInfoMsg);
        }
        return result;
    }

    @GET
    @Path(value="/info")
    public ApplicationInfo getApplicationInfo() throws WsException {
        this.checkPermission(WebswingAction.rest_getAppInfo);
        ApplicationInfo app = new ApplicationInfo();
        app.setPath(this.getPathMapping());
        app.setEnabled(this.isEnabled());
        app.setUrl(this.getFullPathMapping());
        app.setName("Server");
        File icon = this.resolveFile(this.getConfig().getIcon());
        app.setIcon(CommonUtil.loadImage((File)icon));
        app.setConfig(this.getConfig());
        app.setVariables(this.varSubs.getVariableMap());
        app.setStatus(this.getStatus());
        return app;
    }

    @GET
    @Path(value="/rest/paths")
    public List<String> getPaths(HttpServletRequest req) throws WsException {
        this.checkPermission(WebswingAction.rest_getPaths);
        ArrayList<String> result = new ArrayList<String>();
        for (SwingInstanceManager appManager : this.getApplications()) {
            result.add(appManager.getFullPathMapping());
        }
        return result;
    }

    @GET
    @Path(value="/rest/version")
    public String getVersion() throws WsException {
        return super.getVersion();
    }

    @GET
    @Path(value="/rest/config")
    public MetaObject getConfigMeta() throws WsException {
        MetaObject meta = super.getConfigMeta();
        return meta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/rest/remove")
    public void removeSwingApp(@PathParam(value="") String path) throws Exception {
        this.checkMasterPermission(WebswingAction.rest_removeApp);
        if (StringUtils.isEmpty((String)path)) throw new WsException("Unable to remove App '" + path + "'", 400);
        SwingInstanceManager swingManager = (SwingInstanceManager)this.instanceManagers.get(path);
        if (swingManager == null) return;
        if (swingManager.isEnabled()) throw new WsException("Unable to Remove App '" + path + "' while running. Stop the app first");
        this.configService.removeConfiguration(path);
    }

    @GET
    @Path(value="/rest/create")
    public void createSwingApp(@PathParam(value="") String path) throws Exception {
        this.checkMasterPermission(WebswingAction.rest_createApp);
        if (!StringUtils.isEmpty((String)path)) {
            SwingInstanceManager swingManager = (SwingInstanceManager)this.instanceManagers.get(path);
            if (swingManager != null) {
                throw new WsException("Unable to Create App '" + path + "'. Application already exits.");
            }
        } else {
            throw new WsException("Unable to create App '" + path + "'", 400);
        }
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("enabled", false);
        this.configService.setConfiguration(path, config);
        this.configService.setConfiguration(path, null);
    }

    @POST
    @Path(value="/rest/config")
    public void saveConfig(Map<String, Object> config) throws Exception {
        this.checkMasterPermission(WebswingAction.rest_setConfig);
        config.put("path", "/");
        this.configService.setConfiguration("/", config);
    }

    @GET
    @Path(value="/rest/permissions")
    public Map<String, Boolean> getPermissions() throws Exception {
        Map perm = super.getPermissions();
        boolean multiApplicationMode = this.configService.isMultiApplicationMode();
        perm.put("start", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_startApp}));
        perm.put("stop", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_stopApp}));
        perm.put("remove", multiApplicationMode && this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_removeApp}));
        perm.put("create", multiApplicationMode && this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_createApp}));
        perm.put("configEdit", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig, WebswingAction.rest_setConfig}));
        perm.put("logsView", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_viewLogs}));
        return perm;
    }

    @POST
    @Path(value="/rest/metaConfig")
    public MetaObject getMeta(Map<String, Object> json) throws WsException {
        return super.getMeta(json);
    }

    @GET
    @Path(value="/rest/variables")
    public Map<String, String> getVariables(@PathParam(value="") String type) throws WsException {
        return super.getVariables(type);
    }

    @POST
    @Path(value="/rest/logs")
    public LogResponse getLogs(@PathParam(value="") String type, LogRequest request) throws WsException {
        this.checkMasterPermission(WebswingAction.rest_viewLogs);
        if (type.startsWith("/")) {
            type = type.substring(1);
        }
        return LogReaderUtil.readLog((String)type, (LogRequest)request);
    }

    @GET
    @Path(value="/rest/logs")
    public InputStream downloadLog(@PathParam(value="") String type) throws WsException {
        this.checkMasterPermission(WebswingAction.rest_viewLogs);
        if (type.startsWith("/")) {
            type = type.substring(1);
        }
        return LogReaderUtil.getZippedLog((String)type);
    }

    @GET
    @Path(value="/rest/CSRFToken")
    public String generateCsrfToken() {
        return super.generateCsrfToken();
    }

    static /* synthetic */ Map access$000(GlobalUrlHandler x0) {
        return x0.instanceManagers;
    }
}

