/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgIn;
import org.webswing.model.c2s.UploadEventMsgIn;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.files.FileDescriptor;
import org.webswing.server.services.files.FileTransferHandler;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;

public class FileTransferHandlerImpl
extends AbstractUrlHandler
implements FileTransferHandler {
    private static final Logger log = LoggerFactory.getLogger(FileTransferHandlerImpl.class);
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private final SwingInstanceManager manager;
    private Map<String, FileDescriptor> fileMap = new ConcurrentHashMap();
    private ScheduledExecutorService validatorService = Executors.newSingleThreadScheduledExecutor();

    public FileTransferHandlerImpl(SwingInstanceManager parent) {
        super((UrlHandler)parent);
        this.manager = parent;
    }

    protected String getPath() {
        return "file";
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        try {
            if (req.getMethod().equals("GET")) {
                this.handleDownload(req, res);
                return true;
            }
            if (req.getMethod().equals("POST")) {
                this.handleUpload(req, res);
                return true;
            }
        }
        catch (Exception e) {
            log.error("FileTransfer failed.", (Throwable)e);
            throw new WsException("Failed to process file transfer " + req.getMethod(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, WsException {
        FileDescriptor fd;
        String fileId = request.getParameter("id");
        String userId = this.getUser() != null ? this.getUser().getUserId() : "null";
        this.checkPermission(WebswingAction.file_download);
        if (!this.fileMap.containsKey(fileId) || ((FileDescriptor)this.fileMap.get((Object)fileId)).file == null) {
            response.sendError(404);
            return;
        }
        if (!userId.equals(((FileDescriptor)this.fileMap.get((Object)fileId)).userId)) {
            response.sendError(403);
            return;
        }
        FileDescriptor fileDescriptor = fd = (FileDescriptor)this.fileMap.get(fileId);
        synchronized (fileDescriptor) {
            if (fd.waitForFile) {
                try {
                    fd.wait(Long.getLong("webswing.fileServletWaitTimeout", 300000L));
                }
                catch (InterruptedException e) {
                    response.sendError(404);
                    fd.waitForFileTask.cancel(false);
                    return;
                }
            }
        }
        if (this.fileMap.get(fileId) == null || !((FileDescriptor)this.fileMap.get((Object)fileId)).file.exists()) {
            response.sendError(404);
            return;
        }
        File file = fd.file;
        response.reset();
        response.setBufferSize(10240);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Length", String.valueOf(file.length()));
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(file), 10240);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            this.close(output);
            this.close(input);
            throw throwable;
        }
        this.close((Closeable)output);
        this.close((Closeable)input);
    }

    private void handleUpload(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException, WsException {
        block9: {
            this.checkPermission(WebswingAction.file_upload);
            try {
                String uuid = request.getParameter("uuid");
                if (uuid != null) {
                    SwingInstance instance = this.manager.findInstanceBySessionId(uuid);
                    if (instance != null) {
                        double maxMB = instance.getAppConfig().getUploadMaxSize();
                        long maxsize = (long)(maxMB * 1024.0 * 1024.0);
                        Part filePart = request.getPart("files[]");
                        String filename = this.getFilename(filePart);
                        if (maxsize > 0L && filePart.getSize() > maxsize) {
                            resp.setStatus(400);
                            resp.getWriter().write(String.format("File '%s' is too large. (Max. file size is %.1fMB)", filename, maxMB));
                        } else {
                            String tempDir = System.getProperty("webswing.tempDirPath");
                            String tempName = UUID.randomUUID().toString();
                            InputStream filecontent = filePart.getInputStream();
                            File f = new File(URI.create(tempDir + "/" + tempName));
                            FileOutputStream output = new FileOutputStream(f);
                            IOUtils.copy((InputStream)filecontent, (OutputStream)output);
                            output.close();
                            filecontent.close();
                            log.info("File " + filename + " uploaded (size:" + filePart.getSize() + ") to " + f.getAbsolutePath());
                            UploadEventMsgIn msg = new UploadEventMsgIn();
                            msg.setFileName(filename);
                            msg.setTempFileLocation(f.getAbsolutePath());
                            boolean sent = instance.sendToSwing(null, (MsgIn)msg);
                            if (!sent) {
                                log.error("Failed to send upload notification to app session. File:" + filename + "+ClientID:" + instance.getClientId());
                                f.delete();
                            } else {
                                resp.getWriter().write("{\"files\":[{\"name\":\"" + filename + "\"}]}");
                            }
                        }
                        break block9;
                    }
                    throw new Exception("Related App instance not found.(" + uuid + ")");
                }
                throw new Exception("UUID not specified in request");
            }
            catch (Exception e) {
                if (e.getCause() instanceof EOFException) {
                    log.warn("File upload canceled by user: " + e.getMessage());
                }
                resp.setStatus(500);
                resp.getWriter().write("Upload finished with error...");
                log.error("Error while uploading file: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.validatorService.shutdownNow();
        super.destroy();
    }

    public void init() {
        this.validatorService = Executors.newSingleThreadScheduledExecutor();
        super.init();
    }

    private void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getFilename(Part part) {
        for (String cd : part.getHeader("Content-Disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return filename.substring(filename.lastIndexOf(47) + 1).substring(filename.lastIndexOf(92) + 1);
        }
        return null;
    }

    public boolean registerFile(File file, String id, long validForTime, TimeUnit timeUnit, String validForUser, String instanceId, boolean waitForFile, String overwriteDetails) {
        return this.registerFileInternal(file, id, validForTime, timeUnit, validForUser, instanceId, false, waitForFile, overwriteDetails);
    }

    private boolean registerFileInternal(File file, String id, long validForTime, TimeUnit timeUnit, String validForUser, String instanceId, boolean temp, boolean waitForFile, String overwriteDetails) {
        FileDescriptor fd = new FileDescriptor(file, validForUser);
        fd.temporary = temp;
        fd.waitForFile = waitForFile;
        fd.overwriteDetails = overwriteDetails;
        fd.instanceId = instanceId;
        if (this.notifyWaitingForSameFile(fd)) {
            return false;
        }
        this.fileMap.put(id, fd);
        if (validForTime > 0L) {
            ScheduledFuture<?> invalidateTask;
            fd.invalidateScheduleTask = invalidateTask = this.validatorService.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, validForTime, timeUnit);
        }
        if (waitForFile) {
            fd.waitForFileTask = this.validatorService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 1L, 1L, TimeUnit.SECONDS);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyWaitingForSameFile(FileDescriptor newFd) {
        for (String id : this.fileMap.keySet()) {
            FileDescriptor fd = (FileDescriptor)this.fileMap.get(id);
            if (!fd.instanceId.equals(newFd.instanceId) || !fd.userId.equals(newFd.userId) || !fd.file.equals(newFd.file) || !fd.waitForFile) continue;
            FileDescriptor fileDescriptor = fd;
            synchronized (fileDescriptor) {
                fd.waitForFile = false;
                fd.notifyAll();
                fd.waitForFileTask.cancel(false);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Map access$000(FileTransferHandlerImpl x0) {
        return x0.fileMap;
    }
}

