/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingmanager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.util.ServerUtil;

public class SwingInstanceSet {
    Set<SwingInstance> instances = new HashSet();

    public synchronized void add(SwingInstance swingInstance) {
        this.instances.add(swingInstance);
    }

    public boolean contains(SwingInstance swingInstance) {
        return this.instances.contains(swingInstance);
    }

    public synchronized void remove(String instanceId) {
        this.instances.remove(this.findByInstanceId(instanceId));
    }

    public int size() {
        return this.instances.size();
    }

    public synchronized SwingInstance findBySessionId(String sessionId) {
        for (SwingInstance i : this.instances) {
            if (sessionId == null || !sessionId.equals(i.getSessionId()) && !sessionId.equals(i.getMirrorSessionId())) continue;
            return i;
        }
        return null;
    }

    public synchronized SwingInstance findByClientId(String clientId) {
        for (SwingInstance i : this.instances) {
            if (clientId == null || !clientId.equals(i.getClientId())) continue;
            return i;
        }
        return null;
    }

    public synchronized SwingInstance findByInstanceId(ConnectionHandshakeMsgIn h, WebSocketConnection r) {
        for (SwingInstance i : this.instances) {
            String idForMode = ServerUtil.resolveInstanceIdForMode((WebSocketConnection)r, (ConnectionHandshakeMsgIn)h, (SwingConfig)i.getAppConfig());
            if (idForMode == null || !idForMode.equals(i.getInstanceId())) continue;
            return i;
        }
        return null;
    }

    public synchronized SwingInstance findByInstanceId(String instanceId) {
        for (SwingInstance i : this.instances) {
            if (instanceId == null || !instanceId.equals(i.getInstanceId())) continue;
            return i;
        }
        return null;
    }

    public synchronized List<SwingInstance> getAllInstances() {
        return new ArrayList<SwingInstance>(this.instances);
    }
}

