/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingmanager;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgOut;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.model.s2c.SimpleEventMsgOut;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.admin.Sessions;
import org.webswing.server.common.model.admin.SwingSession;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.files.FileTransferHandler;
import org.webswing.server.services.files.FileTransferHandlerService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.AuthorizationConfig;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.stats.StatisticsLogger;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swinginstance.SwingInstanceService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.SwingInstanceSet;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.services.websocket.WebSocketService;

public class SwingInstanceManagerImpl
extends PrimaryUrlHandler
implements SwingInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(SwingInstanceManagerImpl.class);
    private final String path;
    private final SwingInstanceService instanceFactory;
    private final WebSocketService websocket;
    private final LoginHandlerService loginService;
    private final ResourceHandlerService resourceService;
    private StatisticsLogger statsLogger;
    private FileTransferHandler fileHandler;
    private SwingInstanceSet runningInstances = new SwingInstanceSet();
    private SwingInstanceSet closedInstances = new SwingInstanceSet();

    public SwingInstanceManagerImpl(UrlHandler parent, String path, SwingInstanceService instanceFactory, WebSocketService websocket, FileTransferHandlerService fileService, LoginHandlerService loginService, ResourceHandlerService resourceService, SecurityModuleService securityModuleService, ConfigurationService configService, StatisticsLoggerService loggerService) {
        super(parent, securityModuleService, configService);
        this.path = path;
        this.instanceFactory = instanceFactory;
        this.websocket = websocket;
        this.loginService = loginService;
        this.resourceService = resourceService;
        this.statsLogger = loggerService.createLogger();
        this.fileHandler = fileService.create((SwingInstanceManager)this);
    }

    public void init() {
        this.registerChildUrlHandler((UrlHandler)this.websocket.createBinaryWebSocketHandler((PrimaryUrlHandler)this, (SwingInstanceManager)this));
        this.registerChildUrlHandler((UrlHandler)this.websocket.createJsonWebSocketHandler((PrimaryUrlHandler)this, (SwingInstanceManager)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLoginHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLogoutHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.fileHandler);
        this.registerChildUrlHandler((UrlHandler)this.resourceService.create((UrlHandler)this, (SecurityContext)this));
        super.init();
    }

    public void destroy() {
        for (SwingInstance i : this.runningInstances.getAllInstances()) {
            i.kill(0);
        }
        super.destroy();
    }

    protected String getPath() {
        return this.path;
    }

    public void connectView(ConnectionHandshakeMsgIn handshake, WebSocketConnection r) {
        try {
            this.checkAuthorization();
            if (!this.isEnabled()) {
                throw new WsException("This application is disabled.");
            }
        }
        catch (WsException e1) {
            log.error("User authorization failed. {}", (Object)e1.getMessage());
            r.broadcastMessage((MsgOut)SimpleEventMsgOut.unauthorizedAccess.buildMsgOut());
            return;
        }
        try {
            SwingInstance instance;
            if (handshake.isMirrored()) {
                this.checkPermissionLocalOrMaster(WebswingAction.websocket_startMirrorView);
                instance = this.runningInstances.findByInstanceId(handshake.getClientId());
            } else {
                instance = this.runningInstances.findByInstanceId(handshake, r);
            }
            if (instance != null) {
                instance.connectSwingInstance(r, handshake);
            } else {
                if (handshake.isMirrored()) {
                    throw new WsException("Instance not found!");
                }
                this.startSwingInstance(r, handshake);
            }
        }
        catch (WsException e) {
            log.error("Failed to connect to instance. ", (Throwable)e);
            r.broadcastMessage((MsgOut)SimpleEventMsgOut.configurationError.buildMsgOut());
        }
    }

    private void startSwingInstance(WebSocketConnection r, ConnectionHandshakeMsgIn h) {
        if (r.hasPermission(WebswingAction.websocket_startSwingApplication)) {
            if (!h.isMirrored()) {
                if (!this.reachedMaxConnections()) {
                    try {
                        SwingInstance swingInstance = this.instanceFactory.create((SwingInstanceManager)this, this.fileHandler, h, this.getSwingConfig(), r);
                        this.runningInstances.add(swingInstance);
                    }
                    catch (Exception e) {
                        log.error("Failed to create Application instance.", (Throwable)e);
                    }
                } else {
                    r.broadcastMessage((MsgOut)SimpleEventMsgOut.tooManyClientsNotification.buildMsgOut());
                }
            } else {
                r.broadcastMessage((MsgOut)SimpleEventMsgOut.configurationError.buildMsgOut());
            }
        } else {
            log.error("Authorization error: User " + r.getUser() + " is not authorized to connect to application " + this.getSwingConfig().getName() + (h.isMirrored() ? " [Mirrored view only available for admin role]" : ""));
        }
    }

    protected void killAll() {
        for (SwingInstance si : this.runningInstances.getAllInstances()) {
            si.shutdown(true);
        }
    }

    private boolean reachedMaxConnections() {
        if (this.getSwingConfig().getMaxClients() < 0) {
            return false;
        }
        if (this.getSwingConfig().getMaxClients() == 0) {
            return true;
        }
        return this.runningInstances.size() >= this.getSwingConfig().getMaxClients();
    }

    public void notifySwingClose(SwingInstance swingInstance) {
        if (!this.closedInstances.contains(swingInstance)) {
            this.closedInstances.add(swingInstance);
        }
        this.runningInstances.remove(swingInstance.getInstanceId());
        swingInstance.logWarningHistory();
        this.statsLogger.removeInstance(swingInstance.getClientId());
    }

    public SwingInstance findInstanceBySessionId(String uuid) {
        return this.runningInstances.findBySessionId(uuid);
    }

    public SwingInstance findInstanceByClientId(String clientId) {
        return this.runningInstances.findByClientId(clientId);
    }

    public List<SwingInstance> getAllInstances() {
        return this.runningInstances.getAllInstances();
    }

    public List<SwingInstance> getAllClosedInstances() {
        return this.closedInstances.getAllInstances();
    }

    public List<SwingInstanceManager> getApplications() {
        return Arrays.asList(this);
    }

    public ApplicationInfoMsg getApplicationInfoMsg() {
        if (this.getConfig().getSwingConfig() == null) {
            return null;
        }
        ApplicationInfoMsg app = new ApplicationInfoMsg();
        app.setName(this.getSwingConfig().getName());
        app.setUrl(this.getFullPathMapping());
        File icon = this.resolveFile(this.getConfig().getIcon());
        app.setBase64Icon(CommonUtil.loadImage((File)icon));
        return app;
    }

    @GET
    @Path(value="/start")
    public void start() throws WsException {
        this.checkMasterPermission(WebswingAction.rest_startApp);
        if (!this.isEnabled()) {
            super.initConfiguration();
        }
    }

    @GET
    @Path(value="/stop")
    public void stop() throws WsException {
        this.checkMasterPermission(WebswingAction.rest_stopApp);
        if (this.isEnabled()) {
            super.disable();
        }
    }

    @GET
    @Path(value="/info")
    public ApplicationInfo getApplicationInfo() throws WsException {
        this.checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
        ApplicationInfo app = new ApplicationInfo();
        app.setPath(this.getPathMapping());
        app.setEnabled(this.isEnabled());
        app.setUrl(this.getFullPathMapping());
        app.setName(this.getSwingConfig().getName());
        File icon = this.resolveFile(this.getConfig().getIcon());
        app.setIcon(CommonUtil.loadImage((File)icon));
        app.setConfig(this.getConfig());
        app.setVariables(this.varSubs.getVariableMap());
        app.setRunningInstances(this.runningInstances.size());
        int connected = 0;
        for (SwingInstance si : this.runningInstances.getAllInstances()) {
            if (si.getSessionId() == null) continue;
            ++connected;
        }
        app.setConnectedInstances(connected);
        app.setFinishedInstances(this.closedInstances.size());
        int maxRunningInstances = this.getSwingConfig().getMaxClients();
        app.setMaxRunningInstances(maxRunningInstances);
        app.setStatus(this.getStatus());
        app.setStats(this.statsLogger.getSummaryStats());
        app.setWarnings(this.statsLogger.getSummaryWarnings());
        return app;
    }

    @GET
    @Path(value="/apps")
    public List<ApplicationInfoMsg> getApplicationInfo(HttpServletRequest req) throws WsException {
        this.checkPermission(WebswingAction.rest_getApps);
        return Arrays.asList(this.getApplicationInfoMsg());
    }

    @GET
    @Path(value="/rest/paths")
    public List<String> getApplications(HttpServletRequest req) throws WsException {
        this.checkPermissionLocalOrMaster(WebswingAction.rest_getPaths);
        return Arrays.asList(this.getFullPathMapping());
    }

    @GET
    @Path(value="/rest/version")
    public String getVersion() throws WsException {
        return super.getVersion();
    }

    @GET
    @Path(value="/rest/config")
    public MetaObject getConfigMeta() throws WsException {
        MetaObject meta = super.getConfigMeta();
        return meta;
    }

    @POST
    @Path(value="/rest/config")
    public void setConfig(Map<String, Object> config) throws Exception {
        super.setConfig(config);
    }

    @GET
    @Path(value="/rest/permissions")
    public Map<String, Boolean> getPermissions() throws Exception {
        return super.getPermissions();
    }

    @GET
    @Path(value="/rest/sessions")
    public Sessions getSessions() throws WsException {
        this.checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
        Sessions result = new Sessions();
        for (SwingInstance si : this.getAllInstances()) {
            result.getSessions().add(si.toSwingSession(false));
        }
        for (SwingInstance si : this.getAllClosedInstances()) {
            result.getClosedSessions().add(si.toSwingSession(false));
        }
        return result;
    }

    @GET
    @Path(value="/rest/session")
    public SwingSession getSession(@PathParam(value="") String id) throws WsException {
        SwingInstance instance;
        this.checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if ((instance = this.runningInstances.findByInstanceId(id)) != null) {
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/record")
    public SwingSession startRecording(@PathParam(value="") String id) throws WsException {
        SwingInstance instance;
        this.checkPermissionLocalOrMaster(WebswingAction.rest_startRecording);
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if ((instance = this.runningInstances.findByInstanceId(id)) != null) {
            instance.startRecording();
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/threadDump")
    public String getThreadDump(@PathParam(value="") String id, @QueryParam(value="id") String timestamp) throws WsException {
        SwingInstance instance;
        this.checkPermissionLocalOrMaster(WebswingAction.rest_getThreadDump);
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if ((instance = this.runningInstances.findByInstanceId(id)) != null) {
            return instance.getThreadDump(timestamp);
        }
        List instaces = this.closedInstances.getAllInstances();
        for (SwingInstance i : instaces) {
            String td;
            if (!id.equals(i.getInstanceId()) || (td = i.getThreadDump(timestamp)) == null) continue;
            return td;
        }
        throw new WsException("Not found", 404);
    }

    @POST
    @Path(value="/rest/threadDump")
    public void requestThreadDump(@PathParam(value="") String id) throws WsException {
        SwingInstance instance;
        this.checkPermissionLocalOrMaster(WebswingAction.rest_requestThreadDump);
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if ((instance = this.runningInstances.findByInstanceId(id)) != null) {
            instance.requestThreadDump();
        }
    }

    @DELETE
    @Path(value="/rest/session")
    public void shutdown(@PathParam(value="") String id, @QueryParam(value="force") String forceKill) throws WsException {
        SwingInstance instance;
        boolean force = Boolean.parseBoolean(forceKill);
        if (force) {
            this.checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdown);
        } else {
            this.checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdownForce);
        }
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if ((instance = this.runningInstances.findByInstanceId(id)) == null) {
            throw new WsException("Instance with id " + id + " not found.");
        }
        instance.shutdown(force);
    }

    @POST
    @Path(value="/rest/metaConfig")
    public MetaObject getMeta(Map<String, Object> json) throws WsException {
        return super.getMeta(json);
    }

    @GET
    @Path(value="/rest/variables")
    public Map<String, String> getVariables(@PathParam(value="") String type) throws WsException {
        return super.getVariables(type);
    }

    @GET
    @Path(value="/rest/CSRFToken")
    public String generateCsrfToken() throws WsException {
        this.checkPermissionLocalOrMaster(WebswingAction.rest_getApps);
        return super.generateCsrfToken();
    }

    @GET
    @Path(value="/rest/ping")
    public void ping() {
    }

    public void logStatValue(String instance, String name, Number value) {
        this.statsLogger.log(instance, name, value);
    }

    public Map<String, Map<Long, Number>> getInstanceStats(String instance) {
        return this.statsLogger.getInstanceStats(instance);
    }

    public Map<String, Number> getInstanceMetrics(String clientId) {
        return this.statsLogger.getInstanceMetrics(clientId);
    }

    public List<String> getInstanceWarnings(String instance) {
        return this.statsLogger.getInstanceWarnings(instance);
    }

    public List<String> getInstanceWarningHistory(String instance) {
        return this.statsLogger.getInstanceWarningHistory(instance);
    }

    private void checkAuthorization() throws WsException {
        if (!this.isUserAuthorized()) {
            throw new WsException("User '" + this.getUser() + "' is not authorized to access application " + this.getPathMapping(), 401);
        }
    }

    public boolean isUserAuthorized() {
        AbstractWebswingUser user = this.getUser();
        if (user == null) {
            return false;
        }
        AuthorizationConfig authorizationConfig = this.getSecurityConfig().getAuthorizationConfig();
        if (authorizationConfig == null || authorizationConfig.getRoles().size() == 0 && authorizationConfig.getUsers().size() == 0) {
            return true;
        }
        VariableSubstitutor subs = VariableSubstitutor.forSwingApp((SecuredPathConfig)this.getConfig());
        for (String role : authorizationConfig.getRoles()) {
            String resolvedRole = subs.replace(role);
            if (!user.hasRole(resolvedRole)) continue;
            return true;
        }
        for (String u : authorizationConfig.getUsers()) {
            String resolvedUser = subs.replace(u);
            if (!user.getUserId().equals(resolvedUser)) continue;
            return true;
        }
        return false;
    }
}

