/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.webswing.server.GlobalUrlHandler;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.RestService;
import org.webswing.server.services.rest.RestUrlHandler;
import org.webswing.server.services.rest.RestUrlHandlerImpl;
import org.webswing.server.services.rest.resources.GlobalRestService;
import org.webswing.server.services.rest.resources.SwingAppRestService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingprocess.SwingProcessService;

@Singleton
public class RestServiceImpl
implements RestService {
    private final ConfigurationService configService;
    private final SwingProcessService processService;

    @Inject
    public RestServiceImpl(ConfigurationService configService, SwingProcessService processService) {
        this.configService = configService;
        this.processService = processService;
    }

    @Override
    public RestUrlHandler createGlobalRestHandler(GlobalUrlHandler parent) {
        return new RestUrlHandlerImpl(parent, this.createRestInjectionBinder(parent), GlobalRestService.class);
    }

    @Override
    public RestUrlHandler createSwingAppRestHandler(PrimaryUrlHandler parent) {
        return new RestUrlHandlerImpl(parent, this.createRestInjectionBinder(parent), SwingAppRestService.class);
    }

    @Override
    public RestUrlHandler createRestHandler(UrlHandler parent, Class ... resources) {
        return new RestUrlHandlerImpl(parent, this.createRestInjectionBinder(parent), resources);
    }

    protected AbstractBinder createRestInjectionBinder(final UrlHandler parent) {
        AbstractBinder binding = new AbstractBinder(){

            protected void configure() {
                this.bind(parent).to(parent.getClass());
                if (parent instanceof PrimaryUrlHandler) {
                    this.bind(parent).to(PrimaryUrlHandler.class);
                }
                if (parent instanceof GlobalUrlHandler) {
                    this.bind(parent).to(GlobalUrlHandler.class);
                }
                if (parent instanceof SwingInstanceManager) {
                    this.bind(parent).to(SwingInstanceManager.class);
                }
                this.bind(RestServiceImpl.this.configService).to(ConfigurationService.class);
                this.bind(RestServiceImpl.this.processService).to(SwingProcessService.class);
            }
        };
        return binding;
    }
}

