/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.model.meta.VariableSetName;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.toolkit.util.GitRepositoryState;

public abstract class BaseRestService {
    private static final String default_version = "unresolved";

    protected abstract PrimaryUrlHandler getHandler();

    protected abstract ConfigurationService getConfigService();

    @GET
    @Path(value="/apps")
    public List<ApplicationInfoMsg> getApps() throws WsException {
        this.getHandler().checkPermission(WebswingAction.rest_getApps);
        return this.getAppsImpl();
    }

    protected abstract List<ApplicationInfoMsg> getAppsImpl();

    @GET
    @Path(value="/info")
    public ApplicationInfo getAppInfo() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
        return this.getAppInfoImpl();
    }

    protected ApplicationInfo getAppInfoImpl() {
        PrimaryUrlHandler h = this.getHandler();
        ApplicationInfo app = new ApplicationInfo();
        app.setPath(h.getPathMapping());
        app.setEnabled(h.isEnabled());
        app.setUrl(h.getFullPathMapping());
        File icon = h.resolveFile(h.getConfig().getIcon());
        app.setIcon(CommonUtil.loadImage((File)icon));
        app.setConfig(h.getConfig());
        app.setVariables(h.getVariableMap());
        app.setStatus(h.getStatus());
        return app;
    }

    @GET
    @Path(value="/rest/paths")
    public List<String> getPaths() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getPaths);
        return this.getPathsImpl();
    }

    protected abstract List<String> getPathsImpl();

    @POST
    @Path(value="/rest/config")
    public void saveConfig(Map<String, Object> config) throws Exception {
        this.getHandler().checkMasterPermission(WebswingAction.rest_setConfig);
        this.saveConfigImpl(config);
    }

    protected void saveConfigImpl(Map<String, Object> config) throws Exception {
        this.getConfigService().setConfiguration(this.getHandler().getPathMapping(), config);
    }

    @GET
    @Path(value="/rest/config")
    public MetaObject getConfigMeta() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        return this.getConfigService().describeConfiguration(this.getHandler().getPathMapping(), null, (ConfigContext)this.getHandler());
    }

    @GET
    @Path(value="/rest/variables/{type}")
    public Map<String, String> getVariables(@PathParam(value="type") String type) throws WsException {
        VariableSetName key;
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        try {
            key = VariableSetName.valueOf((String)type);
        }
        catch (Exception e) {
            key = VariableSetName.Basic;
        }
        switch (key) {
            case SwingInstance: {
                String userName = this.getHandler().getUser() == null ? "<webswing user>" : this.getHandler().getUser().getUserId();
                VariableSubstitutor vs = VariableSubstitutor.forSwingInstance((SecuredPathConfig)this.getHandler().getConfig(), (String)userName, null, (String)"<webswing client Id>", (String)"<webswing client IP address>", (String)"<webswing client locale>", (String)"<webswing custom args>");
                return vs.getVariableMap();
            }
            case SwingApp: {
                VariableSubstitutor vs = VariableSubstitutor.forSwingApp((SecuredPathConfig)this.getHandler().getConfig());
                return vs.getVariableMap();
            }
        }
        VariableSubstitutor vs = VariableSubstitutor.basic();
        return vs.getVariableMap();
    }

    @POST
    @Path(value="/rest/metaConfig")
    public MetaObject getMeta(Map<String, Object> json) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        return this.getConfigService().describeConfiguration(this.getHandler().getPathMapping(), json, (ConfigContext)this.getHandler());
    }

    @GET
    @Path(value="/rest/permissions")
    public Map<String, Boolean> getPermissions() throws Exception {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.master_basic_access);
        return this.getPermissionsImpl();
    }

    protected Map<String, Boolean> getPermissionsImpl() throws Exception {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        permissions.put("dashboard", this.isPermited(WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo));
        permissions.put("configView", this.isPermited(WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig));
        permissions.put("configSwingEdit", this.isMasterPermited(WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig, WebswingAction.rest_setConfig));
        permissions.put("sessions", this.isPermited(WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getSession));
        permissions.put("configEdit", false);
        permissions.put("start", false);
        permissions.put("stop", false);
        permissions.put("remove", false);
        permissions.put("logsView", false);
        return permissions;
    }

    @GET
    @Path(value="/rest/version")
    @Produces(value={"text/plain"})
    public String getVersion() throws WsException {
        String describe = GitRepositoryState.getInstance().getDescribe();
        if (describe == null) {
            return default_version;
        }
        return describe;
    }

    @GET
    @Path(value="/rest/CSRFToken")
    @Produces(value={"text/plain"})
    public String generateCsrfToken() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.websocket_connect);
        return this.getHandler().generateCsrfToken();
    }

    @GET
    @Path(value="/rest/ping")
    public void ping() {
    }

    protected boolean isPermited(WebswingAction ... actions) {
        for (WebswingAction action : actions) {
            boolean master;
            boolean local;
            boolean bl = local = this.getHandler().getUser() != null && this.getHandler().getUser().isPermitted(action.name());
            if (local || (master = this.isMasterPermited(actions))) continue;
            return false;
        }
        return true;
    }

    protected boolean isMasterPermited(WebswingAction ... actions) {
        for (WebswingAction action : actions) {
            boolean master;
            boolean bl = master = this.getHandler().getMasterUser() != null && this.getHandler().getMasterUser().isPermitted(action.name());
            if (master) continue;
            return false;
        }
        return true;
    }
}

