/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.admin.Sessions;
import org.webswing.server.common.model.admin.SwingSession;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestService;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;

@Path(value="")
@Produces(value={"application/json"})
public class SwingAppRestService
extends BaseRestService {
    @Inject
    SwingInstanceManager manager;
    @Inject
    PrimaryUrlHandler handler;
    @Inject
    ConfigurationService configService;

    @Override
    protected List<ApplicationInfoMsg> getAppsImpl() {
        return Arrays.asList(this.manager.getApplicationInfoMsg());
    }

    @Override
    protected ApplicationInfo getAppInfoImpl() {
        ApplicationInfo app = super.getAppInfoImpl();
        app.setName(this.handler.getSwingConfig().getName());
        List<SwingInstance> allRunning = this.manager.getSwingInstanceHolder().getAllInstances();
        app.setRunningInstances(allRunning.size());
        int connected = 0;
        for (SwingInstance si : allRunning) {
            if (si.getConnectionId() == null) continue;
            ++connected;
        }
        app.setConnectedInstances(connected);
        app.setFinishedInstances(this.manager.getSwingInstanceHolder().getAllClosedInstances().size());
        int maxRunningInstances = this.handler.getSwingConfig().getMaxClients();
        app.setMaxRunningInstances(maxRunningInstances);
        app.setStats(this.manager.getStatsReader().getSummaryStats());
        app.setWarnings(this.manager.getStatsReader().getSummaryWarnings());
        return app;
    }

    @Override
    protected List<String> getPathsImpl() {
        return Arrays.asList(this.handler.getFullPathMapping());
    }

    @GET
    @Path(value="/start")
    public Response start() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_startApp);
        if (!this.getHandler().isEnabled()) {
            this.getHandler().initConfiguration();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/stop")
    public Response stop() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_stopApp);
        if (this.getHandler().isEnabled()) {
            this.getHandler().disable();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/rest/sessions")
    public Sessions getSessions() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
        Sessions result = new Sessions();
        for (SwingInstance si : this.manager.getSwingInstanceHolder().getAllInstances()) {
            result.getSessions().add(si.toSwingSession(false));
        }
        for (SwingInstance si : this.manager.getSwingInstanceHolder().getAllClosedInstances()) {
            result.getClosedSessions().add(si.toSwingSession(false));
        }
        return result;
    }

    @GET
    @Path(value="/rest/session/{id}")
    public SwingSession getSession(@PathParam(value="id") String id) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/metrics/{uuid}")
    public SwingSession getMetrics(@PathParam(value="uuid") String uuid) throws WsException {
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByConnectionId(uuid);
        if (instance != null && this.getHandler().getUser().getUserId().equals(instance.getUserId())) {
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/record/{id}")
    public SwingSession startRecording(@PathParam(value="id") String id) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_startRecording);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            instance.startRecording();
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/threadDump/{path}")
    public String getThreadDump(@PathParam(value="path") String id, @QueryParam(value="id") String timestamp) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getThreadDump);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            return instance.getThreadDump(timestamp);
        }
        List<SwingInstance> instaces = this.manager.getSwingInstanceHolder().getAllClosedInstances();
        for (SwingInstance i : instaces) {
            String td;
            if (!id.equals(i.getInstanceId()) || (td = i.getThreadDump(timestamp)) == null) continue;
            return td;
        }
        throw new WsException("Not found", 404);
    }

    @POST
    @Path(value="/rest/threadDump/{path}")
    public void requestThreadDump(@PathParam(value="path") String id) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_requestThreadDump);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            instance.requestThreadDump();
        }
    }

    @DELETE
    @Path(value="/rest/session/{id}")
    public void shutdown(@PathParam(value="id") String id, @QueryParam(value="force") String forceKill) throws WsException {
        boolean force = Boolean.parseBoolean(forceKill);
        if (force) {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdown);
        } else {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdownForce);
        }
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance == null) {
            throw new WsException("Instance with id " + id + " not found.");
        }
        instance.shutdown(force);
    }

    @Override
    protected PrimaryUrlHandler getHandler() {
        return this.handler;
    }

    @Override
    protected ConfigurationService getConfigService() {
        return this.configService;
    }
}

