/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swinginstance;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.model.SessionRecordingHeader;
import org.webswing.server.services.swinginstance.SwingInstance;

public class SessionRecorder {
    private static final Logger log = LoggerFactory.getLogger(SessionRecorder.class);
    private boolean failed = false;
    private FileOutputStream out;
    private SessionRecordingHeader header;
    private String fileName;
    private long lastFrame;

    public SessionRecorder(SwingInstance swingInstance) {
        try {
            URI uri = URI.create(System.getProperty("webswing.tempDirPath") + URLEncoder.encode(swingInstance.getInstanceId(), "UTF-8") + ".wss");
            File file = new File(uri);
            this.fileName = file.getCanonicalPath();
            log.info("Starting session recording for " + swingInstance.getInstanceId() + " into file:" + file);
            if (this.out == null) {
                this.out = new FileOutputStream(file);
                this.header = new SessionRecordingHeader();
                this.header.setClientId(swingInstance.getInstanceId());
                this.header.setStartDate(new Date());
                this.lastFrame = this.header.getStartDate().getTime();
                byte[] version = ByteBuffer.allocate(4).putInt(1).array();
                byte[] headerbytes = SessionRecorder.serializeObject(this.header);
                this.out.write(version);
                this.saveFrame(headerbytes);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Failed to create session recording file.", (Throwable)e);
            this.failed = true;
        }
        catch (IOException e) {
            this.failed = true;
        }
    }

    private static byte[] serializeObject(Serializable o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            log.error("Failed to serialize object.", (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void saveFrame(byte[] serialized) {
        block5: {
            if (!this.failed) {
                try {
                    if (this.out == null) break block5;
                    byte[] length = ByteBuffer.allocate(4).putInt(serialized.length).array();
                    long now = new Date().getTime();
                    byte[] delay = ByteBuffer.allocate(4).putInt((int)(now - this.lastFrame)).array();
                    this.lastFrame = now;
                    try {
                        this.out.write(delay);
                        this.out.write(length);
                        this.out.write(serialized);
                        this.out.flush();
                    }
                    catch (IOException e) {
                        log.error("Failed to write to session recording file.", (Throwable)e);
                        throw e;
                    }
                }
                catch (Exception e) {
                    this.failed = true;
                    this.close();
                }
            }
        }
    }

    public void close() {
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        catch (IOException e) {
            log.error("Failed to close recording file.", (Throwable)e);
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getFileName() {
        return this.fileName;
    }
}

