/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import java.util.Date;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.util.ServerUtil;

public class WebSocketUserInfo {
    private final String userId;
    private final String userBrowser;
    private final String customArgs;
    private final int debugPort;
    private final String userIp;
    private final String userOs;
    private Date disconnectedSince;

    WebSocketUserInfo(WebSocketConnection conn) {
        this.userId = conn.getUserId();
        this.customArgs = ServerUtil.getCustomArgs(conn.getRequest());
        this.debugPort = ServerUtil.getDebugPort(conn.getRequest());
        this.userIp = ServerUtil.getClientIp(conn);
        this.userOs = ServerUtil.getClientOs(conn);
        this.userBrowser = ServerUtil.getClientBrowser(conn);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCustomArgs() {
        return this.customArgs;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getUserOs() {
        return this.userOs;
    }

    public String getUserBrowser() {
        return this.userBrowser;
    }

    public Date getDisconnectedSince() {
        return this.disconnectedSince;
    }

    public void setDisconnected() {
        this.disconnectedSince = new Date();
    }
}

