/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.rest.LogRequest;
import org.webswing.server.common.model.rest.LogResponse;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;

public class LogReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(LogReaderUtil.class);
    private static final String WEBSWING_LOG_FILE_TYPE_PREFIX = "webswing.log.file.";

    public static LogResponse readLog(String type, LogRequest request) throws WsException {
        File f = LogReaderUtil.findLogFile(type);
        RandomAccessFile fileHandler = null;
        try {
            fileHandler = new RandomAccessFile(f, "r");
            long startIndex = LogReaderUtil.getStartIndex(fileHandler.length(), request);
            if (startIndex > 0L) {
                for (long filePointer = startIndex - 1L; filePointer < fileHandler.length(); ++filePointer) {
                    fileHandler.seek(filePointer);
                    byte readByte = fileHandler.readByte();
                    if (readByte == 10) break;
                }
            }
            startIndex = fileHandler.getFilePointer();
            byte[] b = new byte[LogReaderUtil.getReadSize(startIndex, fileHandler.length(), request)];
            fileHandler.readFully(b);
            LogResponse result = new LogResponse();
            result.setStartOffset(startIndex);
            result.setEndOffset(fileHandler.getFilePointer());
            result.setLog(new String(b));
            LogResponse logResponse = result;
            return logResponse;
        }
        catch (IOException e) {
            throw new WsException("Failed to read log file. " + e.getMessage());
        }
        finally {
            if (fileHandler != null) {
                try {
                    fileHandler.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getReadSize(long start, long fileSize, LogRequest r) {
        return (int)Math.min(r.getMax(), fileSize - start);
    }

    private static long getStartIndex(long fileSize, LogRequest r) {
        long offset;
        long l = offset = r.getOffset() == -1L ? fileSize - 1L : r.getOffset();
        if (r.isBackwards()) {
            return offset - Math.min(offset, r.getMax());
        }
        return offset;
    }

    private static File findLogFile(String type) {
        String filename = System.getProperty(WEBSWING_LOG_FILE_TYPE_PREFIX + type);
        if (filename != null) {
            filename = VariableSubstitutor.basic().replace(filename);
            File file = Paths.get(filename, new String[0]).toAbsolutePath().normalize().toFile();
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getZippedLog(String type) throws WsException {
        File f = LogReaderUtil.findLogFile(type);
        String tempDir = System.getProperty("webswing.tempDirPath");
        File zip = new File(URI.create(tempDir + type + ".zip"));
        if (f != null) {
            FileInputStream in = null;
            FileOutputStream fos = null;
            ZipOutputStream out = null;
            try {
                Object b;
                in = new FileInputStream(f);
                fos = new FileOutputStream(zip);
                out = new ZipOutputStream(fos);
                if (zip.canWrite()) {
                    int count;
                    out.putNextEntry(new ZipEntry(f.getName()));
                    b = new byte[1024];
                    while ((count = in.read((byte[])b)) > 0) {
                        out.write((byte[])b, 0, count);
                    }
                } else {
                    throw new IOException("Can not write to file " + zip.getAbsolutePath());
                }
                b = new FileInputStream(zip);
                return b;
            }
            catch (IOException e) {
                log.error("Failed to zip the log file.", (Throwable)e);
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            throw new WsException("Failed to download the zipped " + type + " log.");
        }
        return null;
    }
}

