/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.base;

import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.security.SecurableService;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.util.SecurityUtil;
import org.webswing.server.util.ServerUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractUrlHandler
implements UrlHandler,
SecurableService {
    private static final Logger log = LoggerFactory.getLogger(AbstractUrlHandler.class);
    private final UrlHandler parent;
    private final LinkedList<UrlHandler> childHandlers = new LinkedList();

    public AbstractUrlHandler(UrlHandler parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LinkedList linkedList = this.childHandlers;
        synchronized (linkedList) {
            for (UrlHandler handler : this.childHandlers) {
                try {
                    handler.init();
                }
                catch (Exception e) {
                    log.error("Failed to initialize child handler: " + handler.getClass().getName(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LinkedList linkedList = this.childHandlers;
        synchronized (linkedList) {
            for (UrlHandler handler : this.childHandlers) {
                try {
                    handler.destroy();
                }
                catch (Exception e) {
                    log.error("Failed to destroy child handler: " + handler.getClass().getName(), (Throwable)e);
                }
            }
            this.childHandlers.clear();
        }
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        String pathinfo = this.getPathInfo(req);
        LinkedList localHandlerList = new LinkedList(this.childHandlers);
        for (UrlHandler child : localHandlerList) {
            boolean served;
            if (!this.isSubPath(AbstractUrlHandler.toPath((String)child.getPathMapping()), pathinfo) || !(served = child.serve(req, res))) continue;
            return true;
        }
        return false;
    }

    public Object secureServe(HttpServletRequest req, HttpServletResponse res) throws WsException {
        return this.serve(req, res);
    }

    public String getFullPathMapping() {
        String handlerPath = AbstractUrlHandler.toPath((String)this.getPathMapping());
        if (this.parent != null) {
            String parentMapping = this.parent.getFullPathMapping();
            handlerPath = parentMapping + handlerPath;
        } else {
            handlerPath = ServerUtil.getContextPath((ServletContext)this.getServletContext()) + handlerPath;
        }
        return handlerPath;
    }

    public String getPathInfo(HttpServletRequest req) {
        String requestPath;
        String fullHandlerPath = this.getFullPathMapping();
        if (this.isSubPath(fullHandlerPath, requestPath = AbstractUrlHandler.toPath((String)(ServerUtil.getContextPath((ServletContext)this.getServletContext()) + req.getPathInfo())))) {
            return AbstractUrlHandler.toPath((String)requestPath.substring(fullHandlerPath.length()));
        }
        return "/";
    }

    protected abstract String getPath();

    public String getPathMapping() {
        String path = AbstractUrlHandler.toPath((String)this.getPath());
        return path;
    }

    public boolean isSubPath(String subpath, String path) {
        return CommonUtil.isSubPath((String)subpath, (String)path);
    }

    public static String toPath(String path) {
        return CommonUtil.toPath((String)path);
    }

    public void registerFirstChildUrlHandler(UrlHandler handler) {
        this.childHandlers.addFirst(handler);
    }

    public void registerChildUrlHandler(UrlHandler handler) {
        this.childHandlers.add(handler);
    }

    public void removeChildUrlHandler(UrlHandler handler) {
        if (this.childHandlers.contains(handler)) {
            this.childHandlers.remove(handler);
            handler.destroy();
        }
    }

    public ServletContext getServletContext() {
        return this.parent.getServletContext();
    }

    public String getSecuredPath() {
        SecuredPathHandler provider;
        if (SecuredPathHandler.class.isAssignableFrom(this.getClass()) && (provider = (SecuredPathHandler)this).get() != null) {
            return this.getFullPathMapping();
        }
        if (this.parent == null) {
            return this.getFullPathMapping();
        }
        return this.parent.getSecuredPath();
    }

    public SecuredPathHandler getSecurityProvider() {
        SecuredPathHandler provider;
        if (SecuredPathHandler.class.isAssignableFrom(this.getClass()) && (provider = (SecuredPathHandler)this).get() != null) {
            return provider;
        }
        if (this.parent == null) {
            return (SecuredPathHandler)this;
        }
        return this.parent.getSecurityProvider();
    }

    public long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    public AbstractWebswingUser getUser() {
        return SecurityUtil.getUser((UrlHandler)this);
    }

    public AbstractWebswingUser getMasterUser() {
        return SecurityUtil.getUser((String)this.getRootHandler().getSecuredPath());
    }

    public UrlHandler getRootHandler() {
        if (this.parent != null) {
            return this.parent.getRootHandler();
        }
        return this;
    }

    public void checkPermission(WebswingAction action) throws WsException {
        AbstractWebswingUser user = this.getUser();
        this.checkPermission(user, action);
    }

    public void checkMasterPermission(WebswingAction action) throws WsException {
        AbstractWebswingUser user = this.getMasterUser();
        this.checkPermission(user, action);
    }

    public void checkPermissionLocalOrMaster(WebswingAction a) throws WsException {
        try {
            this.checkPermission(a);
        }
        catch (WsException e) {
            this.checkMasterPermission(a);
        }
    }

    private void checkPermission(AbstractWebswingUser user, WebswingAction action) throws WsException {
        if (user != null && user.isPermitted(action.name())) {
            return;
        }
        throw new WsException("User '" + user + "' is not allowed to execute action '" + action + "'", 401);
    }
}

