/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.extension;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.extension.DefaultExtensionProvider;
import org.webswing.server.extension.ExtensionClassLoader;
import org.webswing.server.extension.ExtensionDependencies;
import org.webswing.server.extension.ExtensionProvider;
import org.webswing.server.extension.ExtensionService;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.RestService;
import org.webswing.server.services.rest.RestUrlHandler;
import org.webswing.server.services.swingprocess.SwingProcessService;

@Singleton
public class ExtensionServiceImpl
implements ExtensionService,
ExtensionDependencies {
    private final ExtensionClassLoader extensionLoader;
    private final SwingProcessService processService;
    private final ConfigurationService configService;
    private final RestService restService;
    private ExtensionProvider provider;
    private Logger logger = LoggerFactory.getLogger(ExtensionServiceImpl.class);

    @Inject
    public ExtensionServiceImpl(ExtensionClassLoader extensionLoader, SwingProcessService processService, ConfigurationService configuService, RestService restService) {
        this.extensionLoader = extensionLoader;
        this.processService = processService;
        this.configService = configuService;
        this.restService = restService;
    }

    public void start() throws WsInitException {
        String providerClassName = System.getProperty("webswing.extensionProvider", DefaultExtensionProvider.class.getName());
        this.logger.info("Initializing extension provider {}", (Object)providerClassName);
        try {
            Class providerClass = this.extensionLoader.loadClass(providerClassName);
            try {
                Constructor constructor = providerClass.getDeclaredConstructor(ExtensionDependencies.class);
                this.provider = (ExtensionProvider)constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                this.provider = (ExtensionProvider)providerClass.newInstance();
            }
        }
        catch (Exception e) {
            this.logger.error("Could not instantiate extension provider {}", (Object)providerClassName, (Object)e);
            throw new WsInitException("Could not instantiate extension provider " + providerClassName, (Throwable)e);
        }
    }

    public void stop() {
    }

    public List<UrlHandler> createExtHandlers(PrimaryUrlHandler parent) {
        return this.provider.createExtensionHandlers(parent);
    }

    public SwingProcessService getProcessService() {
        return this.processService;
    }

    public ConfigurationService getConfigService() {
        return this.configService;
    }

    public RestUrlHandler createRestHandler(UrlHandler parent, Class ... resources) {
        return this.restService.createRestHandler(parent, resources);
    }

    protected ExtensionProvider getProvider() {
        return this.provider;
    }
}

