/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.WebswingObjectMapper;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.security.SecurableService;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.util.SecurityUtil;
import org.webswing.server.util.ServerUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractUrlHandler
implements UrlHandler,
SecurableService {
    private static final Logger log = LoggerFactory.getLogger(AbstractUrlHandler.class);
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private final UrlHandler parent;
    private final LinkedList<UrlHandler> childHandlers = new LinkedList();

    public AbstractUrlHandler(UrlHandler parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LinkedList linkedList = this.childHandlers;
        synchronized (linkedList) {
            for (UrlHandler handler : this.childHandlers) {
                try {
                    handler.init();
                }
                catch (Exception e) {
                    log.error("Failed to initialize child handler: " + handler.getClass().getName(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LinkedList linkedList = this.childHandlers;
        synchronized (linkedList) {
            for (UrlHandler handler : this.childHandlers) {
                try {
                    handler.destroy();
                }
                catch (Exception e) {
                    log.error("Failed to destroy child handler: " + handler.getClass().getName(), (Throwable)e);
                }
            }
            this.childHandlers.clear();
        }
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        String pathinfo = this.getPathInfo(req);
        LinkedList localHandlerList = new LinkedList(this.childHandlers);
        for (UrlHandler child : localHandlerList) {
            boolean served;
            if (!this.isSubPath(AbstractUrlHandler.toPath((String)child.getPathMapping()), pathinfo) || !(served = child.serve(req, res))) continue;
            return true;
        }
        return this.serveRestMethod(req, res);
    }

    protected boolean serveRestMethod(HttpServletRequest req, HttpServletResponse res) throws WsException {
        String path;
        String httpMethod = req.getMethod();
        Method method = this.findRestHandlerMethod(httpMethod, path = this.getPathInfo(req));
        if (method != null) {
            Object result;
            method.setAccessible(true);
            Object[] args = this.resolveRestParameters(method, req);
            try {
                result = method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e1) {
                result = e1.getTargetException();
            }
            catch (Exception e) {
                result = e;
            }
            this.writeRestResponse(method, req, res, result);
            return true;
        }
        return false;
    }

    public Object secureServe(HttpServletRequest req, HttpServletResponse res) throws WsException {
        return this.serve(req, res);
    }

    public String getFullPathMapping() {
        String handlerPath = AbstractUrlHandler.toPath((String)this.getPathMapping());
        if (this.parent != null) {
            String parentMapping = this.parent.getFullPathMapping();
            handlerPath = parentMapping + handlerPath;
        } else {
            handlerPath = ServerUtil.getContextPath((ServletContext)this.getServletContext()) + handlerPath;
        }
        return handlerPath;
    }

    public String getPathInfo(HttpServletRequest req) {
        String requestPath;
        String fullHandlerPath = this.getFullPathMapping();
        if (this.isSubPath(fullHandlerPath, requestPath = AbstractUrlHandler.toPath((String)(ServerUtil.getContextPath((ServletContext)this.getServletContext()) + req.getPathInfo())))) {
            return AbstractUrlHandler.toPath((String)requestPath.substring(fullHandlerPath.length()));
        }
        return "/";
    }

    protected abstract String getPath();

    public String getPathMapping() {
        String path = AbstractUrlHandler.toPath((String)this.getPath());
        return path;
    }

    public boolean isSubPath(String subpath, String path) {
        return CommonUtil.isSubPath((String)subpath, (String)path);
    }

    public static String toPath(String path) {
        return CommonUtil.toPath((String)path);
    }

    public void registerFirstChildUrlHandler(UrlHandler handler) {
        this.childHandlers.addFirst(handler);
    }

    public void registerChildUrlHandler(UrlHandler handler) {
        this.childHandlers.add(handler);
    }

    public void removeChildUrlHandler(UrlHandler handler) {
        if (this.childHandlers.contains(handler)) {
            this.childHandlers.remove(handler);
            handler.destroy();
        }
    }

    public ServletContext getServletContext() {
        return this.parent.getServletContext();
    }

    public String getSecuredPath() {
        SecuredPathHandler provider;
        if (SecuredPathHandler.class.isAssignableFrom(this.getClass()) && (provider = (SecuredPathHandler)this).get() != null) {
            return this.getFullPathMapping();
        }
        if (this.parent == null) {
            return this.getFullPathMapping();
        }
        return this.parent.getSecuredPath();
    }

    public SecuredPathHandler getSecurityProvider() {
        SecuredPathHandler provider;
        if (SecuredPathHandler.class.isAssignableFrom(this.getClass()) && (provider = (SecuredPathHandler)this).get() != null) {
            return provider;
        }
        if (this.parent == null) {
            return (SecuredPathHandler)this;
        }
        return this.parent.getSecurityProvider();
    }

    public long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    public AbstractWebswingUser getUser() {
        return SecurityUtil.getUser((UrlHandler)this);
    }

    public AbstractWebswingUser getMasterUser() {
        return SecurityUtil.getUser((UrlHandler)this.getRootHandler());
    }

    public UrlHandler getRootHandler() {
        if (this.parent != null) {
            return this.parent.getRootHandler();
        }
        return this;
    }

    public void checkPermission(WebswingAction action) throws WsException {
        AbstractWebswingUser user = this.getUser();
        this.checkPermission(user, action);
    }

    public void checkMasterPermission(WebswingAction action) throws WsException {
        AbstractWebswingUser user = this.getMasterUser();
        this.checkPermission(user, action);
    }

    public void checkPermissionLocalOrMaster(WebswingAction a) throws WsException {
        try {
            this.checkPermission(a);
        }
        catch (WsException e) {
            this.checkMasterPermission(a);
        }
    }

    private void checkPermission(AbstractWebswingUser user, WebswingAction action) throws WsException {
        if (user != null && user.isPermitted(action.name())) {
            return;
        }
        throw new WsException("User '" + user + "' is not allowed to execute action '" + action + "'", 401);
    }

    private Method findRestHandlerMethod(String httpMethod, String path2) {
        Class methodAnnotation = AbstractUrlHandler.httpMethod2RestAnnotation((String)httpMethod);
        Method match = null;
        if (methodAnnotation != null) {
            int extent = path2.length();
            for (Method method : this.getClass().getDeclaredMethods()) {
                Path pathAnnotation;
                if (method.getAnnotation(methodAnnotation) == null || (pathAnnotation = method.getAnnotation(Path.class)) == null || !this.isSubPath(pathAnnotation.value(), path2) || path2.length() - pathAnnotation.value().length() >= extent) continue;
                match = method;
                extent = path2.length() - pathAnnotation.value().length();
            }
        }
        return match;
    }

    private static Class<? extends Annotation> httpMethod2RestAnnotation(String httpMethod) {
        if (httpMethod.equals("GET")) {
            return GET.class;
        }
        if (httpMethod.equals("PUT")) {
            return PUT.class;
        }
        if (httpMethod.equals("POST")) {
            return POST.class;
        }
        if (httpMethod.equals("DELETE")) {
            return DELETE.class;
        }
        return null;
    }

    private Object[] resolveRestParameters(Method method, HttpServletRequest req) {
        Object[] result = new Object[method.getParameterCount()];
        Parameter[] params = method.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getType().isAssignableFrom(HttpServletRequest.class)) {
                result[i] = req;
                continue;
            }
            QueryParam paramAnno = params[i].getAnnotation(QueryParam.class);
            if (paramAnno != null) {
                result[i] = req.getParameter(paramAnno.value());
                continue;
            }
            if (params[i].getAnnotation(PathParam.class) != null && String.class.isAssignableFrom(params[i].getType())) {
                String path2 = method.getAnnotation(Path.class).value();
                result[i] = this.getPathInfo(req).substring(path2.length());
                continue;
            }
            if (String.class.isAssignableFrom(params[i].getType())) {
                try {
                    result[i] = IOUtils.toString((Reader)req.getReader());
                }
                catch (IOException e) {
                    result[i] = null;
                }
                continue;
            }
            try {
                String content = IOUtils.toString((Reader)req.getReader());
                result[i] = WebswingObjectMapper.get().readValue(content, params[i].getType());
                continue;
            }
            catch (IOException e) {
                result[i] = null;
            }
        }
        return result;
    }

    private void writeRestResponse(Method method, HttpServletRequest req, HttpServletResponse res, Object result) throws WsException {
        if (result != null && result instanceof Throwable) {
            if (result instanceof WsException) {
                throw (WsException)((Object)result);
            }
            log.error("Invocation of REST method failed.", (Throwable)result);
            throw new WsException("Invocation of REST method failed.", 500);
        }
        res.setStatus(200);
        res.setHeader("Cache-Control", "no-store, must-revalidate");
        res.setHeader("Expires", "0");
        if (!method.getReturnType().equals(Void.TYPE) && result != null) {
            try {
                if (method.getReturnType().equals(String.class)) {
                    IOUtils.write((String)result.toString(), (OutputStream)res.getOutputStream());
                } else if (method.getReturnType().equals(InputStream.class)) {
                    IOUtils.copy((InputStream)((InputStream)result), (OutputStream)res.getOutputStream());
                } else {
                    WebswingObjectMapper.get().writerWithDefaultPrettyPrinter().writeValue((OutputStream)res.getOutputStream(), result);
                }
            }
            catch (Exception e) {
                log.error("Failed to serialize REST execution result." + req.getRequestURI(), (Throwable)e);
                throw new WsException("Serializing of REST result failed.", 500);
            }
        }
    }
}

