/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingmanager;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.files.FileTransferHandlerService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.swinginstance.SwingInstanceService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.SwingInstanceManagerImpl;
import org.webswing.server.services.swingmanager.SwingInstanceManagerService;
import org.webswing.server.services.websocket.WebSocketService;

@Singleton
public class SwingInstanceManagerServiceImpl
implements SwingInstanceManagerService {
    private final WebSocketService websocket;
    private final SwingInstanceService instanceService;
    private final FileTransferHandlerService fileService;
    private final LoginHandlerService loginService;
    private final ResourceHandlerService resourceHandler;
    private final SecurityModuleService securityModuleService;
    private final ConfigurationService configService;
    private final StatisticsLoggerService loggerService;

    @Inject
    public SwingInstanceManagerServiceImpl(SwingInstanceService instanceFactory, WebSocketService websocket, FileTransferHandlerService fileHandler, LoginHandlerService loginHandler, ResourceHandlerService resourceHandler, SecurityModuleService securityModuleService, ConfigurationService configService, StatisticsLoggerService loggerService) {
        this.instanceService = instanceFactory;
        this.websocket = websocket;
        this.fileService = fileHandler;
        this.loginService = loginHandler;
        this.resourceHandler = resourceHandler;
        this.securityModuleService = securityModuleService;
        this.configService = configService;
        this.loggerService = loggerService;
    }

    public SwingInstanceManager createApp(UrlHandler parent, String path) {
        return new SwingInstanceManagerImpl(parent, path, this.instanceService, this.websocket, this.fileService, this.loginService, this.resourceHandler, this.securityModuleService, this.configService, this.loggerService);
    }
}

