/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webswing.model.MsgOut;

public class ProtoMapper {
    public static final String basicProtoPackage = "org.webswing.server.model.proto.Webswing";
    private Map<Class<?>, Class<?>> classProtoMap = new HashMap();

    public byte[] encodeProto(MsgOut msg) throws IOException {
        Message result = this.buildMessage((Object)msg);
        return result.toByteArray();
    }

    public <T> T decodeProto(byte[] bytes, Class<T> msgInClass) throws IOException {
        Object result = this.decodeMessage(bytes, msgInClass);
        return (T)result;
    }

    private <T> T decodeMessage(byte[] bytes, Class<T> c) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            Class protoClass = this.resolveProtoCounterpartClass(c);
            GeneratedMessage protoMsg = (GeneratedMessage)protoClass.getDeclaredMethod("parseFrom", byte[].class).invoke(null, new Object[]{bytes});
            return (T)this.decodeMessage((Message)protoMsg, c);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("decoding " + c.getClass() + " from ProtoBuffer format failed!", e);
        }
    }

    private <T> T decodeMessage(Message protoMsg, Class<T> c) throws IOException {
        try {
            T result = c.newInstance();
            Map valueMap = protoMsg.getAllFields();
            for (Descriptors.FieldDescriptor fd : valueMap.keySet()) {
                Object value;
                Field field = c.getDeclaredField(fd.getName());
                field.setAccessible(true);
                if (fd.isRepeated()) {
                    if (field.getType() == List.class && field.getGenericType() instanceof ParameterizedType) {
                        ArrayList<Object> decodedList = new ArrayList<Object>();
                        ParameterizedType type = (ParameterizedType)field.getGenericType();
                        Class param = (Class)type.getActualTypeArguments()[0];
                        for (Object o : (List)valueMap.get(fd)) {
                            Object value2;
                            if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                                decodedList.add(this.decodeMessage((Message)o, param));
                                continue;
                            }
                            if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
                                value2 = this.resolveEnum((Descriptors.EnumValueDescriptor)o, param);
                                decodedList.add(value2);
                                continue;
                            }
                            if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
                                value2 = ((ByteString)o).toByteArray();
                                decodedList.add(value2);
                                continue;
                            }
                            decodedList.add(o);
                        }
                        field.set(result, decodedList);
                        continue;
                    }
                    throw new IOException("Field '" + fd.getName() + "' of " + c + " has to be List with generics type!");
                }
                if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                    Object o = this.decodeMessage((Message)valueMap.get(fd), field.getType());
                    field.set(result, o);
                    continue;
                }
                if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
                    value = this.resolveEnum((Descriptors.EnumValueDescriptor)valueMap.get(fd), field.getType());
                    field.set(result, value);
                    continue;
                }
                if (fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
                    value = ((ByteString)valueMap.get(fd)).toByteArray();
                    field.set(result, value);
                    continue;
                }
                field.set(result, valueMap.get(fd));
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException("decoding " + c.getClass() + " from ProtoBuffer format failed!", e);
        }
    }

    private Message buildMessage(Object msg) throws IOException {
        if (msg == null) {
            return null;
        }
        try {
            Class<?> c = msg.getClass();
            Class protoClass = this.resolveProtoCounterpartClass(c);
            Message.Builder b = null;
            try {
                b = (Message.Builder)protoClass.getDeclaredMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Not able to resolve ProtoBuffer builder for " + protoClass.getName() + ".", e);
            }
            if (b != null) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object value = field.get(msg);
                    if (Modifier.isStatic(field.getModifiers()) || value == null) continue;
                    String fieldName = field.getName();
                    Descriptors.FieldDescriptor protoField = b.getDescriptorForType().findFieldByName(fieldName);
                    if (protoField == null) {
                        throw new IOException("Field '" + fieldName + "' not found in " + protoClass);
                    }
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        Collection list = (Collection)value;
                        for (Object val : list) {
                            this.resolveAndSetMessageValue(b, protoField, val, true);
                        }
                        continue;
                    }
                    this.resolveAndSetMessageValue(b, protoField, value, false);
                }
            }
            return b.build();
        }
        catch (Exception e) {
            throw new IOException("encoding " + msg.getClass() + " to ProtoBuffer format failed!", e);
        }
    }

    private Enum<?> resolveEnum(Descriptors.EnumValueDescriptor pe, Class<?> type) throws IOException {
        if (pe == null) {
            return null;
        }
        try {
            List<?> enumCons = Arrays.asList(type.getEnumConstants());
            for (Object e : enumCons) {
                Enum enm = (Enum)e;
                if (!pe.getName().equals(enm.name())) continue;
                return enm;
            }
        }
        catch (Exception e) {
            throw new IOException("Resolving enum " + type + " from ProtoBuffer format failed!", e);
        }
        return null;
    }

    private Descriptors.EnumValueDescriptor resolveEnum(Enum<?> enm) throws IOException {
        if (enm == null) {
            return null;
        }
        try {
            Class protoClass = this.resolveProtoCounterpartClass(enm.getClass());
            if (protoClass.isEnum()) {
                List protoEnumCons = Arrays.asList(protoClass.getEnumConstants());
                for (Object pe : protoEnumCons) {
                    ProtocolMessageEnum penm = (ProtocolMessageEnum)pe;
                    if (!penm.getValueDescriptor().getName().equals(enm.name())) continue;
                    return penm.getValueDescriptor();
                }
            }
            throw new IOException("Could not resolve proto counterpart for " + enm.getClass() + "." + enm);
        }
        catch (Exception e) {
            throw new IOException("resolving Enum " + enm.getClass() + " to ProtoBuffer format failed!", e);
        }
    }

    private Class<?> resolveProtoCounterpartClass(Class<?> c) throws ClassNotFoundException {
        if (!this.classProtoMap.containsKey(c)) {
            ClassLoader cl = c.getClassLoader();
            String className = c.getName().substring(c.getName().lastIndexOf(".") + 1);
            String protoClassName = "org.webswing.server.model.proto.Webswing$" + className.replaceAll("\\$", "Proto\\$") + "Proto";
            Class<?> protoClass = cl.loadClass(protoClassName);
            this.classProtoMap.put(c, protoClass);
        }
        Class protoClass = (Class)this.classProtoMap.get(c);
        return protoClass;
    }

    private void resolveAndSetMessageValue(Message.Builder b, Descriptors.FieldDescriptor protoField, Object value, boolean list) throws IOException {
        if (protoField.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
            this.setField(b, protoField, (Object)this.buildMessage(value), list);
        } else if (protoField.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.ENUM)) {
            this.setField(b, protoField, (Object)this.resolveEnum((Enum)value), list);
        } else if (protoField.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING)) {
            this.setField(b, protoField, (Object)ByteString.readFrom((InputStream)new ByteArrayInputStream((byte[])value)), list);
        } else {
            this.setField(b, protoField, value, list);
        }
    }

    private void setField(Message.Builder b, Descriptors.FieldDescriptor protoField, Object message, boolean list) throws IOException {
        try {
            if (list) {
                b.addRepeatedField(protoField, message);
            } else {
                b.setField(protoField, message);
            }
        }
        catch (Exception e) {
            throw new IOException("Could not set " + message.getClass() + " to " + protoField.getFullName(), e);
        }
    }
}

