/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.webswing.server.services.stats.logger.Aggregation;
import org.webswing.server.services.stats.logger.InstanceStats;
import org.webswing.server.services.stats.logger.MetricRule;
import org.webswing.server.services.stats.logger.Warning;
import org.webswing.server.services.stats.logger.WarningRule;

public class InstanceStats {
    private static final int MAX_WARNING_HISTORY_SIZE = 20;
    private DateFormat format = new SimpleDateFormat("HH:mm:ss");
    private Map<String, Map<Long, Number>> statisticsLog = new ConcurrentHashMap();
    private Map<String, Long> lastTimestampMap = new ConcurrentHashMap();
    private Map<String, List<Number>> lastTimestampNumbers = new ConcurrentHashMap();
    private Map<String, Number> lastMetrics = new ConcurrentHashMap();
    private Map<String, Warning> warnings = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<String> warningHistory = new ConcurrentLinkedQueue();

    public void processMetric(MetricRule rule, String name, Number value, WarningRule warnRule) {
        long timestamp = rule.getInterval() == 0L ? System.currentTimeMillis() : System.currentTimeMillis() / rule.getInterval() * rule.getInterval();
        Map valueMap = (Map)this.statisticsLog.get(name);
        if (valueMap == null) {
            valueMap = new /* Unavailable Anonymous Inner Class!! */;
            this.statisticsLog.put(name, valueMap);
        }
        if (rule.getInterval() == 0L) {
            valueMap.put(timestamp, value);
            this.lastMetrics.put(name, value);
            this.processWarningRule(name, warnRule);
        } else {
            Long last = (Long)this.lastTimestampMap.get(name);
            if (last != null && last != timestamp && this.lastTimestampNumbers.get(name) != null) {
                List list = (List)this.lastTimestampNumbers.remove(name);
                Number aggregated = this.calculateValue(rule, list);
                valueMap.put(last, aggregated);
                this.lastMetrics.put(name, aggregated);
                this.processWarningRule(name, warnRule);
            }
            this.lastTimestampMap.put(name, timestamp);
            if (this.lastTimestampNumbers.get(name) == null) {
                this.lastTimestampNumbers.put(name, new ArrayList());
            }
            ((List)this.lastTimestampNumbers.get(name)).add(value);
        }
    }

    private void processWarningRule(String name, WarningRule warnRule) {
        if (warnRule != null) {
            Warning warning = warnRule.checkWarning(this.lastMetrics);
            if (warning == null && this.warnings.containsKey(name)) {
                Warning value = (Warning)this.warnings.remove(name);
                String date = this.format.format(new Date());
                this.warningHistory.add(value + " (until " + date + ")");
                if (this.warningHistory.size() > 20) {
                    this.warningHistory.poll();
                }
            }
            if (warning != null) {
                if (this.warnings.containsKey(name)) {
                    ((Warning)this.warnings.get(name)).update(warning);
                } else {
                    this.warnings.put(name, warning);
                }
            }
        }
    }

    private Number calculateValue(MetricRule rule, List<Number> list) {
        Number result = 0;
        if (list != null && list.size() > 0) {
            block4: for (Number number : list) {
                switch (2.$SwitchMap$org$webswing$server$services$stats$logger$Aggregation[rule.getAggregation().ordinal()]) {
                    case 1: {
                        result = Math.min(number.doubleValue(), ((Number)result).doubleValue());
                        continue block4;
                    }
                    case 2: {
                        result = Math.max(number.doubleValue(), ((Number)result).doubleValue());
                        continue block4;
                    }
                }
                result = ((Number)result).doubleValue() + number.doubleValue();
            }
            if (rule.getAggregation().equals((Object)Aggregation.AVG)) {
                result = ((Number)result).doubleValue() / (double)list.size();
            }
            if (rule.getAggregation().equals((Object)Aggregation.AVG_PER_SEC)) {
                result = ((Number)result).doubleValue() / (double)(rule.getInterval() / 1000L);
            }
        }
        return result;
    }

    public Map<String, Number> getMetrics() {
        List<Aggregation> aggregations = Arrays.asList(Aggregation.MIN, Aggregation.MAX, Aggregation.AVG);
        HashMap<String, Number> metrics = new HashMap<String, Number>(this.lastMetrics);
        MetricRule rule = new MetricRule(Aggregation.MIN, 0L, 0);
        for (String name : this.statisticsLog.keySet()) {
            ArrayList valueList = new ArrayList(((Map)this.statisticsLog.get(name)).values());
            for (Aggregation a : aggregations) {
                rule.setAggregation(a);
                metrics.put(name + "." + a, this.calculateValue(rule, valueList));
            }
        }
        return metrics;
    }

    public List<String> getWarnings() {
        ArrayList<String> result = new ArrayList<String>();
        for (Warning w : this.warnings.values()) {
            result.add(w.toString());
        }
        return result;
    }

    public Map<String, Map<Long, Number>> getStatistics() {
        return this.statisticsLog;
    }

    public List<String> getWarningHistory() {
        ArrayList<String> result = new ArrayList<String>(this.warningHistory);
        Collections.reverse(result);
        return result;
    }
}

