/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.ConfigUtil;
import org.webswing.server.common.util.WebswingObjectMapper;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.ConfigurationProvider;
import org.webswing.server.services.config.ConfigurationUpdateHandler;
import org.webswing.toolkit.util.DeamonThreadFactory;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationProvider.class);
    private ScheduledExecutorService configReloader = Executors.newSingleThreadScheduledExecutor(DeamonThreadFactory.getInstance((String)"Webswing Config Monitor"));
    protected Map<String, Object> configuration = new HashMap<String, Object>();
    private long fileLastModified;
    private ConfigurationUpdateHandler updateHandler;

    public DefaultConfigurationProvider() throws WsInitException {
        this.loadConfiguration();
        int interval = Integer.getInteger("webswing.configReloadIntervalMs", 1000);
        if (interval > 0) {
            this.configReloader.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultConfigurationProvider.this.reloadConfiguration();
                    }
                    catch (Throwable t) {
                        log.error("Failed to reload configuration.", t);
                    }
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    public DefaultConfigurationProvider(ConfigurationUpdateHandler updateHandler) throws WsInitException {
        this();
        this.updateHandler = updateHandler;
    }

    @Override
    public List<String> getPaths() {
        return new ArrayList<String>(this.configuration.keySet());
    }

    @Override
    public Map<String, Object> getConfiguration(String path) {
        Map pathConfig = (Map)this.configuration.get(path);
        return this.cloneJsonObject(pathConfig);
    }

    private Map<String, Object> cloneJsonObject(Map<String, Object> obj) {
        if (obj != null && obj instanceof Map) {
            try {
                String serialized = WebswingObjectMapper.get().writeValueAsString(obj);
                return (Map)WebswingObjectMapper.get().readValue(serialized, Map.class);
            }
            catch (IOException e) {
                log.error("Failed to clone configuration object", (Throwable)e);
            }
        }
        return obj;
    }

    @Override
    public SecuredPathConfig toSecuredPathConfig(String path, Map<String, Object> configuration) {
        HashMap<String, String> copy = configuration == null ? new HashMap<String, String>() : new HashMap<String, Object>(configuration);
        copy.put("path", CommonUtil.toPath((String)path));
        SecuredPathConfig pathConfig = (SecuredPathConfig)ConfigUtil.instantiateConfig(copy, SecuredPathConfig.class, (Object[])new Object[0]);
        return pathConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveConfiguration(String path, Map<String, Object> configuration) throws Exception {
        try {
            File configFile = this.getConfigFile();
            Map json = (Map)WebswingObjectMapper.get().readValue(configFile, Map.class);
            configuration.put("path", path);
            json.put(path, configuration);
            DefaultConfigurationProvider defaultConfigurationProvider = this;
            synchronized (defaultConfigurationProvider) {
                WebswingObjectMapper.get().writerWithDefaultPrettyPrinter().writeValue(configFile, (Object)json);
                this.fileLastModified = 0L;
                this.reloadConfiguration();
            }
        }
        catch (Exception e) {
            log.error("Failed to save Webswing configuration :", (Throwable)e);
            throw new Exception("Failed to save Webswing configuration :", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguration(String path) throws Exception {
        try {
            File configFile = this.getConfigFile();
            Map json = (Map)WebswingObjectMapper.get().readValue(configFile, Map.class);
            json.remove(path);
            DefaultConfigurationProvider defaultConfigurationProvider = this;
            synchronized (defaultConfigurationProvider) {
                WebswingObjectMapper.get().writerWithDefaultPrettyPrinter().writeValue(configFile, (Object)json);
                this.fileLastModified = 0L;
                this.reloadConfiguration();
            }
        }
        catch (Exception e) {
            log.error("Failed to save Webswing configuration :", (Throwable)e);
            throw new Exception("Failed to save Webswing configuration :", e);
        }
    }

    @Override
    public void validateConfiguration(String path, Map<String, Object> configuration) throws Exception {
        SecuredPathConfig c = this.toSecuredPathConfig(path, configuration);
        try {
            WebswingObjectMapper.get().writeValueAsString((Object)c);
        }
        catch (Exception e) {
            throw new WsException("Configuration Json is not valid.", (Throwable)e);
        }
    }

    @Override
    public MetaObject describeConfiguration(String path, Map<String, Object> json, ConfigContext ctx, ClassLoader cl) throws WsException {
        if (json == null) {
            json = this.getConfiguration(path);
        }
        SecuredPathConfig securedPathConfig = this.toSecuredPathConfig(path, json);
        try {
            MetaObject result = ConfigUtil.getConfigMetadata((Object)securedPathConfig, (ClassLoader)cl, (ConfigContext)ctx);
            result.setData(json);
            return result;
        }
        catch (Exception e) {
            log.error("Failed to generate configuration descriptor.", (Throwable)e);
            throw new WsException("Failed to generate configuration descriptor.");
        }
    }

    protected synchronized void loadConfiguration() throws WsInitException {
        try {
            File config = this.getConfigFile();
            if (config != null && config.exists()) {
                if (this.isConfigFileModified(config, this.fileLastModified)) {
                    this.fileLastModified = config.lastModified();
                    Map json = (Map)WebswingObjectMapper.get().readValue(config, Map.class);
                    this.configuration = this.fixPaths(config, json);
                }
            } else if (this.fileLastModified != -1L) {
                this.fileLastModified = -1L;
                throw new WsInitException("Configuration file " + (config != null ? config.getPath() : null) + " does not exist!");
            }
        }
        catch (Exception e) {
            throw new WsInitException("Webswing application configuration failed to load:", (Throwable)e);
        }
    }

    private Map<String, Object> fixPaths(File config, Map<String, Object> json) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        boolean changed = false;
        for (String key : json.keySet()) {
            String path = CommonUtil.toPath((String)key).toLowerCase();
            path = StringUtils.isEmpty((CharSequence)path) ? "/" : path;
            result.put(path, json.get(key));
            if (StringUtils.equals((CharSequence)path, (CharSequence)key)) continue;
            changed = true;
        }
        if (changed) {
            try {
                WebswingObjectMapper.get().writerWithDefaultPrettyPrinter().writeValue(config, result);
            }
            catch (IOException e) {
                log.error("Failed save fixed paths in configuration file. ", (Throwable)e);
            }
        }
        return result;
    }

    private boolean isConfigFileModified(File config, long lastModified) {
        long currentLastModified = config.lastModified();
        return currentLastModified != lastModified;
    }

    protected File getConfigFile() throws WsInitException {
        return CommonUtil.getConfigFile();
    }

    @Override
    public Map<String, Object> createDefaultConfiguration(String path) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("path", path);
        return result;
    }

    @Override
    public boolean isMultiApplicationMode() {
        return true;
    }

    private void reloadConfiguration() throws WsInitException {
        if (this.updateHandler != null) {
            Map<String, Object> oldConfig = this.configuration;
            this.loadConfiguration();
            Map<String, Object> newConfig = this.configuration;
            if (oldConfig != newConfig) {
                this.notifyChanges(oldConfig, newConfig);
            }
        }
    }

    private void notifyChanges(Map<String, Object> oldConfig, Map<String, Object> newConfig) {
        for (String path : newConfig.keySet()) {
            if (ObjectUtils.notEqual((Object)oldConfig.get(path), (Object)newConfig.get(path))) {
                if (newConfig.get(path) instanceof Map) {
                    try {
                        this.updateHandler.notifyConfigChanged(path, this.toSecuredPathConfig(path, (Map)newConfig.get(path)));
                        log.info("App configuration for path '" + path + "' changed.");
                    }
                    catch (Exception e) {
                        log.error("Failed to update app configuration for path '" + path + "'.", (Throwable)e);
                    }
                } else {
                    log.warn("Path '" + path + "' has invalid configuration value.");
                }
            }
            oldConfig.remove(path);
        }
        for (String path : oldConfig.keySet()) {
            try {
                this.updateHandler.notifyConfigDeleted(path);
                log.error("Deleted app configuration '" + path + "'.");
            }
            catch (Exception e) {
                log.error("Failed to delete app configuration'" + path + "'.", (Throwable)e);
            }
        }
    }
}

