/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats.logger;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.services.stats.StatisticsLogger;
import org.webswing.server.services.stats.logger.Aggregation;
import org.webswing.server.services.stats.logger.InstanceStats;
import org.webswing.server.services.stats.logger.MetricRule;
import org.webswing.server.services.stats.logger.SummaryStats;
import org.webswing.server.services.stats.logger.WarningRule;

public class DefaultStatisticsLogger
implements StatisticsLogger {
    private static final Logger log = LoggerFactory.getLogger(DefaultStatisticsLogger.class);
    private static final MetricRule DEFAULT_RULE_AVG = new MetricRule(Aggregation.AVG, TimeUnit.SECONDS.toMillis(10L), 60);
    private static final MetricRule DEFAULT_RULE_AVG_PER_SEC = new MetricRule(Aggregation.AVG_PER_SEC, TimeUnit.SECONDS.toMillis(10L), 60);
    private static final MetricRule DEFAULT_RULE_FLAG = new MetricRule(Aggregation.AVG_PER_SEC, 0L, 1);
    private static final Map<String, MetricRule> rules = new HashMap<String, MetricRule>();
    private static final Map<String, WarningRule> warningRules = new HashMap<String, WarningRule>();
    Map<String, InstanceStats> instanceMap = new HashMap<String, InstanceStats>();

    @Override
    public void log(String instance, String name, Number value) {
        if (value != null) {
            log.trace("{},{},{}", new Object[]{instance, name, value});
            this.processMetric(instance, name, value);
        }
    }

    public void processMetric(String instance, String name, Number value) {
        InstanceStats instanceStats = this.instanceMap.get(instance);
        if (instanceStats == null) {
            instanceStats = new InstanceStats();
            this.instanceMap.put(instance, instanceStats);
        }
        MetricRule rule = this.findRule(name);
        WarningRule warn = warningRules.get(name);
        instanceStats.processMetric(rule, name, value, warn);
    }

    private MetricRule findRule(String name) {
        MetricRule rule = rules.get(name);
        if (rule == null) {
            return DEFAULT_RULE_AVG;
        }
        return rule;
    }

    @Override
    public Map<String, Map<Long, Number>> getSummaryStats() {
        SummaryStats stats = new SummaryStats();
        for (String name : summaryRulesMap.keySet()) {
            List summaryAggreg = (List)summaryRulesMap.get(name);
            for (Aggregation aggregation : summaryAggreg) {
                stats.aggregate(this.instanceMap.values(), name, aggregation);
            }
        }
        return stats.getStatistics();
    }

    @Override
    public Map<String, List<String>> getSummaryWarnings() {
        HashMap<String, List<String>> summary = new HashMap<String, List<String>>();
        for (String instanceId : this.instanceMap.keySet()) {
            List<String> warnings = this.instanceMap.get(instanceId).getWarnings();
            if (warnings == null || warnings.size() <= 0) continue;
            summary.put(instanceId, warnings);
        }
        return summary;
    }

    @Override
    public Map<String, Map<Long, Number>> getInstanceStats(String instance) {
        InstanceStats stats = this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getStatistics();
        }
        return null;
    }

    @Override
    public Map<String, Number> getInstanceMetrics(String instance) {
        InstanceStats stats = this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getMetrics();
        }
        return null;
    }

    @Override
    public List<String> getInstanceWarnings(String instance) {
        InstanceStats stats = this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getWarnings();
        }
        return null;
    }

    @Override
    public List<String> getInstanceWarningHistory(String instance) {
        InstanceStats stats = this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getWarningHistory();
        }
        return null;
    }

    @Override
    public void removeInstance(String instance) {
        this.instanceMap.remove(instance);
    }

    @Override
    public Collection<InstanceStats> getAllInstanceStats() {
        return this.instanceMap.values();
    }

    static {
        rules.put("inboundSize", DEFAULT_RULE_AVG_PER_SEC);
        rules.put("outboundSize", DEFAULT_RULE_AVG_PER_SEC);
        rules.put("webSocketConnected", DEFAULT_RULE_FLAG);
        rules.put("edtThreadBlockedForSeconds", DEFAULT_RULE_FLAG);
        warningRules.put("memoryUsed", WarningRule.memoryUtilizationRule(0.8));
        warningRules.put("latency", WarningRule.thresholdRule("latency", 700.0));
        warningRules.put("latencyPing", WarningRule.thresholdRule("latencyPing", 500.0));
        warningRules.put("webSocketConnected", WarningRule.thresholdRule("webSocketConnected", 2.0, "WebSocket connection failed. Falling back to long-polling."));
        warningRules.put("edtThreadBlockedForSeconds", WarningRule.thresholdRule("edtThreadBlockedForSeconds", 10.0, "EDT blocked for %d seconds. See Thread dump for details."));
        summaryRulesMap.put("memoryAllocated", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("memoryUsed", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("inboundSize", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("outboundSize", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("cpuUtilization", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("cpuUtilizationSession", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("cpuUtilizationServer", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("latencyPing", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latencyNetworkTransfer", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latencyClientRendering", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latencyServerRendering", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latency", Arrays.asList(Aggregation.MAX));
    }
}

