/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Toolkit;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.util.Logger;

public class Main {
    public static void main(String[] args) {
        try {
            Class<?> mainClass;
            Main.initializeDefaultSystemProperties();
            boolean client = System.getProperty("webswing.clientId") != null;
            System.setProperty("webswing.createNewTemp", Main.getCreateNewTemp(args));
            System.setProperty("webswing.cleanTempDir", Main.getBoolParam(args, "-tc", true));
            ProtectionDomain domain = Main.class.getProtectionDomain();
            URL location = domain.getCodeSource().getLocation();
            System.setProperty("webswing.warLocation", location.toExternalForm());
            ArrayList<URL> urls = new ArrayList<URL>();
            if (client) {
                Main.populateClasspathFromDir("WEB-INF/swing-lib", urls);
                Main.initializeExtLibServices(urls);
                Main.retainOnlyLauncherUrl(urls);
            } else {
                Main.initTempDirPath(args);
                Main.populateClasspathFromDir("WEB-INF/server-lib", urls);
            }
            URLClassLoader defaultCL = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
            Thread.currentThread().setContextClassLoader(defaultCL);
            if (client) {
                mainClass = defaultCL.loadClass("org.webswing.SwingMain");
            } else {
                try {
                    mainClass = defaultCL.loadClass("org.webswing.ServerMain");
                }
                catch (ClassNotFoundException e) {
                    InputStream readme = Main.class.getClassLoader().getResourceAsStream("WEB-INF/server-lib/README.txt");
                    if (readme != null) {
                        Scanner s = new Scanner(readme).useDelimiter("\\A");
                        String result = s.hasNext() ? s.next() : "";
                        throw new Exception(result, e);
                    }
                    throw new Exception("Unexpected error.", e);
                }
            }
            Method method = mainClass.getMethod("main", args.getClass());
            method.setAccessible(true);
            try {
                method.invoke(null, new Object[]{args});
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (Exception e) {
            Logger.fatal((String)"Uncaught exception.", (Object[])new Object[]{e});
            System.exit(1);
        }
    }

    public static void initializeDefaultSystemProperties() {
        try {
            InputStream propFile = Main.class.getClassLoader().getResourceAsStream("WEB-INF/classes/webswing.properties");
            Properties p = new Properties(System.getProperties());
            p.load(propFile);
            for (Map.Entry<Object, Object> prop : p.entrySet()) {
                if (System.getProperties().containsKey(prop.getKey())) continue;
                System.getProperties().put(prop.getKey(), prop.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCreateNewTemp(String[] args) {
        return Main.getBoolParam(args, "-d", false);
    }

    public static String getBoolParam(String[] args, String param, Boolean def) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(param) || i + 1 >= args.length) continue;
            return args[i + 1];
        }
        return def.toString();
    }

    private static void retainOnlyLauncherUrl(List<URL> urls) {
        Iterator<URL> i = urls.iterator();
        while (i.hasNext()) {
            if (i.next().getFile().contains("webswing-app-launcher")) continue;
            i.remove();
        }
    }

    private static void initializeExtLibServices(List<URL> urls) throws Exception {
        ClassLoader parent = null;
        try {
            parent = (ClassLoader)ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        URLClassLoader extLibClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        Class<?> classLoaderUtilClass = extLibClassLoader.loadClass("org.webswing.util.ClassLoaderUtil");
        Method initializeServicesMethod = classLoaderUtilClass.getMethod("initializeServices", new Class[0]);
        initializeServicesMethod.invoke(null, new Object[0]);
        ((WebToolkit)Toolkit.getDefaultToolkit()).init();
    }

    private static void populateClasspathFromDir(String dir, List<URL> urls) throws IOException {
        for (URL f : Main.getFilesFromPath(Main.class.getClassLoader().getResource(dir))) {
            urls.add(f);
        }
    }

    public static List<URL> getFilesFromPath(URL r) throws IOException {
        ArrayList<URL> urls;
        block5: {
            File dir;
            block4: {
                urls = new ArrayList<URL>();
                String tempDirPath = Main.getTempDir().getAbsolutePath();
                if (!r.getPath().contains("!")) break block4;
                String[] splitPath = r.getPath().split("\\!/");
                String jar = splitPath[0];
                String path = splitPath[1];
                JarFile jarFile = new JarFile(new File(URI.create(jar)));
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".jar") || !jarEntry.getName().startsWith(path)) continue;
                    urls.add(Main.jarEntryAsFile(jarFile, jarEntry, tempDirPath).toURI().toURL());
                }
                break block5;
            }
            try {
                dir = new File(r.toURI());
            }
            catch (URISyntaxException e) {
                dir = new File(r.getPath());
            }
            if (!dir.isDirectory()) break block5;
            for (File f : dir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                urls.add(f.toURI().toURL());
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File jarEntryAsFile(JarFile jarFile, JarEntry jarEntry, String tempDirPath) throws IOException {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            File file;
            String name = jarEntry.getName();
            if (name.contains("/")) {
                int i = (name = name.replace('/', '_')).lastIndexOf(".");
                String extension = i > -1 ? name.substring(i) : "";
                name = name.substring(0, name.length() - extension.length()) + extension;
            }
            if (!(file = new File(tempDirPath + File.separator + name).getAbsoluteFile()).exists()) {
                int readCount;
                file.createNewFile();
                file.deleteOnExit();
                input = jarFile.getInputStream(jarEntry);
                output = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((readCount = input.read(buffer)) != -1) {
                    ((OutputStream)output).write(buffer, 0, readCount);
                }
            }
            File file2 = file;
            return file2;
        }
        finally {
            Main.close(input);
            Main.close(output);
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getTempDir() {
        if (System.getProperty("webswing.tempDirPath") == null) {
            String baseName;
            File baseDir = new File(System.getProperty("webswing.tempDirBase", System.getProperty("java.io.tmpdir"))).getAbsoluteFile();
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd-HH-mm-ss");
            if (Boolean.parseBoolean(System.getProperty("webswing.createNewTemp", ""))) {
                baseName = sdf.format(new Date()) + "-";
                for (int counter = 0; counter < 10; ++counter) {
                    File tempDir = new File(baseDir, baseName + counter);
                    if (!tempDir.mkdir()) continue;
                    System.setProperty("webswing.tempDirPath", tempDir.toURI().toString());
                    return tempDir;
                }
            } else {
                String baseName2 = "release";
                File tempDir = new File(baseDir, baseName2).getAbsoluteFile();
                if (!tempDir.exists()) {
                    tempDir.mkdir();
                } else if (Boolean.parseBoolean(System.getProperty("webswing.cleanTempDir", "true"))) {
                    for (File f : tempDir.listFiles()) {
                        if (Main.delete(f)) continue;
                        throw new IllegalStateException("Not possible to clean the temp folder. Make sure no other instance of webswing is running or use '-d true' option to create a new temp folder.");
                    }
                }
                System.setProperty("webswing.tempDirPath", tempDir.toURI().toString());
                return tempDir;
            }
            throw new IllegalStateException("Failed to create directory within 10 attempts (tried " + baseName + " to " + baseName + 99 + ')');
        }
        return new File(URI.create(System.getProperty("webswing.tempDirPath")));
    }

    public static File getRootDir() {
        if (System.getProperty("webswing.rootDir") == null) {
            File defaultRoot = new File(System.getProperty("user.dir"));
            System.setProperty("webswing.rootDirUri", defaultRoot.toURI().toString());
            System.setProperty("webswing.rootDir", defaultRoot.getAbsolutePath());
            return defaultRoot;
        }
        String pathOrUri = System.getProperty("webswing.rootDir");
        try {
            File file = new File(URI.create(pathOrUri));
            if (file.exists()) {
                System.setProperty("webswing.rootDirUri", file.toURI().toString());
                System.setProperty("webswing.rootDir", file.getAbsolutePath());
                return file;
            }
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + "not found.");
        }
        catch (IllegalArgumentException e) {
            File absoluteConfigFile = new File(pathOrUri).getAbsoluteFile();
            if (absoluteConfigFile.exists()) {
                System.setProperty("webswing.rootDirUri", absoluteConfigFile.toURI().toString());
                System.setProperty("webswing.rootDir", absoluteConfigFile.getAbsolutePath());
                return absoluteConfigFile;
            }
            throw new IllegalArgumentException("File " + absoluteConfigFile.getAbsolutePath() + " not found.");
        }
    }

    private static boolean delete(File f) {
        if (f.isDirectory()) {
            for (File fx : f.listFiles()) {
                if (Main.delete(fx)) continue;
                return false;
            }
        }
        return f.delete();
    }

    private static void initTempDirPath(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length - 1; ++i) {
                if (!"-t".equals(args[i]) && !"-temp".equals(args[i])) continue;
                System.setProperty("webswing.tempDirBase", args[i + 1]);
                return;
            }
        }
        System.setProperty("webswing.tempDirBase", "tmp");
    }
}

