/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.admin.BasicApplicationInfo;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.model.meta.VariableSetName;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestService;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.toolkit.util.GitRepositoryState;

public abstract class BaseRestService {
    private static final String default_version = "unresolved";

    protected abstract PrimaryUrlHandler getHandler();

    protected abstract ConfigurationService getConfigService();

    @GET
    @Path(value="/apps")
    public List<ApplicationInfoMsg> getApps() throws WsException {
        this.getHandler().checkPermission(WebswingAction.rest_getApps);
        return this.getAppsImpl();
    }

    protected abstract List<ApplicationInfoMsg> getAppsImpl();

    @GET
    @Path(value="/info")
    public ApplicationInfo getAppInfo() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
        return this.getAppInfoImpl();
    }

    protected ApplicationInfo getAppInfoImpl() {
        PrimaryUrlHandler h = this.getHandler();
        ApplicationInfo app = new ApplicationInfo();
        app.setPath(h.getPathMapping());
        app.setUrl(h.getFullPathMapping());
        app.setEnabled(h.isEnabled());
        app.setConfig(h.getConfig());
        app.setVariables(h.getVariableMap());
        app.setStatus(h.getStatus());
        return app;
    }

    @GET
    @Path(value="/rest/paths")
    public List<BasicApplicationInfo> getPaths() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getPaths);
        return this.getPathsImpl();
    }

    protected abstract List<BasicApplicationInfo> getPathsImpl();

    @POST
    @Path(value="/rest/config")
    public void saveConfig(Map<String, Object> config) throws Exception {
        this.getHandler().checkMasterPermission(WebswingAction.rest_setConfig);
        this.saveConfigImpl(config);
    }

    protected void saveConfigImpl(Map<String, Object> config) throws Exception {
        this.getConfigService().setConfiguration(this.getHandler().getPathMapping(), config);
    }

    @GET
    @Path(value="/rest/config")
    public MetaObject getConfigMeta() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        return this.getConfigService().describeConfiguration(this.getHandler().getPathMapping(), null, (ConfigContext)this.getHandler());
    }

    private VariableSubstitutor getVariableSubstitutorByType(String type) {
        VariableSubstitutor variableSubstitutor;
        VariableSetName variableType;
        try {
            variableType = VariableSetName.valueOf((String)type);
        }
        catch (Exception e) {
            variableType = VariableSetName.Basic;
        }
        switch (1.$SwitchMap$org$webswing$server$common$model$meta$VariableSetName[variableType.ordinal()]) {
            case 1: {
                String userName = this.getHandler().getUser() == null ? "<webswing user>" : this.getHandler().getUser().getUserId();
                variableSubstitutor = VariableSubstitutor.forSwingInstance((SecuredPathConfig)this.getHandler().getConfig(), (String)userName, null, (String)"<webswing client Id>", (String)"<webswing client IP address>", (String)"<webswing client locale>", (String)"<webswing custom args>");
                break;
            }
            case 2: {
                variableSubstitutor = VariableSubstitutor.forSwingApp((SecuredPathConfig)this.getHandler().getConfig());
                break;
            }
            default: {
                variableSubstitutor = VariableSubstitutor.basic();
            }
        }
        return variableSubstitutor;
    }

    @GET
    @Path(value="/rest/variables/search/{type}")
    public Map<String, String> searchVariables(@PathParam(value="type") String type, @QueryParam(value="search") String searchSequence) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        int VARIABLES_RESULT_COUNT = 10;
        if (searchSequence == null) {
            searchSequence = "";
        }
        searchSequence = searchSequence.toLowerCase();
        TreeMap<String, String> searchResultStartBy = new TreeMap<String, String>();
        TreeMap<String, String> searchResultContains = new TreeMap<String, String>();
        TreeMap variables = new TreeMap(this.getVariableSubstitutorByType(type).getVariableMap());
        for (Map.Entry variable : variables.entrySet()) {
            if (searchResultStartBy.size() + searchResultContains.size() == 10) break;
            String variableLowerCase = ((String)variable.getKey()).toLowerCase();
            if (variableLowerCase.startsWith(searchSequence)) {
                searchResultStartBy.put((String)variable.getKey(), (String)variable.getValue());
                continue;
            }
            if (variableLowerCase.contains(searchSequence)) {
                searchResultContains.put((String)variable.getKey(), (String)variable.getValue());
                continue;
            }
            String valueLowerCase = ((String)variable.getValue()).toLowerCase();
            if (!valueLowerCase.contains(searchSequence)) continue;
            searchResultContains.put((String)variable.getKey(), (String)variable.getValue());
        }
        LinkedHashMap<String, String> allResults = new LinkedHashMap<String, String>();
        allResults.putAll(searchResultStartBy);
        allResults.putAll(searchResultContains);
        return allResults;
    }

    @GET
    @Path(value="/rest/variables/resolve/{type}")
    @Produces(value={"text/plain"})
    public String resolve(@PathParam(value="type") String type, @QueryParam(value="resolve") String stringToResolve) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        if (stringToResolve == null) {
            return null;
        }
        return this.getVariableSubstitutorByType(type).replace(stringToResolve);
    }

    @POST
    @Path(value="/rest/metaConfig")
    public MetaObject getMeta(Map<String, Object> json) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        return this.getConfigService().describeConfiguration(this.getHandler().getPathMapping(), json, (ConfigContext)this.getHandler());
    }

    @GET
    @Path(value="/rest/permissions")
    public Map<String, Boolean> getPermissions() throws Exception {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.master_basic_access);
        return this.getPermissionsImpl();
    }

    protected Map<String, Boolean> getPermissionsImpl() throws Exception {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        permissions.put("dashboard", this.isPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo}));
        permissions.put("configView", this.isPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig}));
        permissions.put("configSwingEdit", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig, WebswingAction.rest_setConfig}));
        permissions.put("sessions", this.isPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getSession}));
        permissions.put("configEdit", false);
        permissions.put("start", false);
        permissions.put("stop", false);
        permissions.put("remove", false);
        permissions.put("logsView", false);
        return permissions;
    }

    @GET
    @Path(value="/rest/version")
    @Produces(value={"text/plain"})
    public String getVersion() throws WsException {
        String describe = GitRepositoryState.getInstance().getDescribe();
        if (describe == null) {
            return default_version;
        }
        return describe;
    }

    @GET
    @Path(value="/rest/CSRFToken")
    @Produces(value={"text/plain"})
    public String generateCsrfToken() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.websocket_connect);
        return this.getHandler().generateCsrfToken();
    }

    @GET
    @Path(value="/rest/ping")
    public void ping() {
    }

    protected boolean isPermited(WebswingAction ... actions) {
        for (WebswingAction action : actions) {
            boolean master;
            boolean local;
            boolean bl = local = this.getHandler().getUser() != null && this.getHandler().getUser().isPermitted(action.name());
            if (local || (master = this.isMasterPermited(actions))) continue;
            return false;
        }
        return true;
    }

    protected boolean isMasterPermited(WebswingAction ... actions) {
        for (WebswingAction action : actions) {
            boolean master;
            boolean bl = master = this.getHandler().getMasterUser() != null && this.getHandler().getMasterUser().isPermitted(action.name());
            if (master) continue;
            return false;
        }
        return true;
    }
}

