/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.GlobalUrlHandler;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.admin.BasicApplicationInfo;
import org.webswing.server.common.model.admin.Sessions;
import org.webswing.server.common.model.rest.LogRequest;
import org.webswing.server.common.model.rest.LogResponse;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestService;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.util.LogReaderUtil;
import org.webswing.server.util.LoggerStatisticsUtil;

@Path(value="")
@Produces(value={"application/json"})
public class GlobalRestService
extends BaseRestService {
    @Inject
    GlobalUrlHandler handler;
    @Inject
    ConfigurationService configService;
    @Inject
    StatisticsLoggerService loggerService;

    protected List<ApplicationInfoMsg> getAppsImpl() {
        ArrayList<ApplicationInfoMsg> result = new ArrayList<ApplicationInfoMsg>();
        for (SwingInstanceManager mgr : this.getGlobalHandler().getApplications()) {
            ApplicationInfoMsg applicationInfoMsg;
            if (!mgr.isEnabled() || !mgr.isUserAuthorized() || (applicationInfoMsg = mgr.getApplicationInfoMsg()) == null) continue;
            result.add(applicationInfoMsg);
        }
        return result;
    }

    protected ApplicationInfo getAppInfoImpl() {
        ApplicationInfo app = super.getAppInfoImpl();
        app.setName("Server");
        return app;
    }

    protected List<BasicApplicationInfo> getPathsImpl() {
        ArrayList<BasicApplicationInfo> result = new ArrayList<BasicApplicationInfo>();
        for (SwingInstanceManager appManager : this.getGlobalHandler().getApplications()) {
            BasicApplicationInfo app = new BasicApplicationInfo();
            app.setPath(appManager.getPathMapping());
            app.setUrl(appManager.getFullPathMapping());
            app.setEnabled(appManager.isEnabled());
            if (appManager.getConfig() != null && appManager.getConfig().getSwingConfig() != null) {
                app.setName(appManager.getConfig().getSwingConfig().getName());
            }
            List allRunning = appManager.getSwingInstanceHolder().getAllInstances();
            app.setRunningInstances(allRunning.size());
            result.add(app);
        }
        return result;
    }

    protected Map<String, Boolean> getPermissionsImpl() throws Exception {
        Map perm = super.getPermissionsImpl();
        boolean multiApplicationMode = this.configService.isMultiApplicationMode();
        perm.put("start", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_startApp}));
        perm.put("stop", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_stopApp}));
        perm.put("remove", multiApplicationMode && this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_removeApp}));
        perm.put("create", multiApplicationMode && this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_createApp}));
        perm.put("configEdit", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig, WebswingAction.rest_setConfig}));
        perm.put("logsView", this.isMasterPermited(new WebswingAction[]{WebswingAction.rest_viewLogs}));
        return perm;
    }

    protected void saveConfigImpl(Map<String, Object> config) throws Exception {
        config.put("path", "/");
        this.configService.setConfiguration("/", config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/rest/remove{appPath: .+?}")
    public void removeSwingApp(@PathParam(value="appPath") String path) throws Exception {
        this.getHandler().checkMasterPermission(WebswingAction.rest_removeApp);
        if (StringUtils.isEmpty((String)path)) throw new WsException("Unable to remove App '" + path + "'", 400);
        SwingInstanceManager swingManager = this.getGlobalHandler().getApplication(path);
        if (swingManager == null) return;
        if (swingManager.isEnabled()) throw new WsException("Unable to Remove App '" + path + "' while running. Stop the app first");
        this.configService.removeConfiguration(path);
    }

    @GET
    @Path(value="/rest/create{appPath: .+?}")
    public void createSwingApp(@PathParam(value="appPath") String path) throws Exception {
        this.getHandler().checkMasterPermission(WebswingAction.rest_createApp);
        if (!StringUtils.isEmpty((String)path)) {
            SwingInstanceManager swingManager = this.getGlobalHandler().getApplication(path);
            if (swingManager != null) {
                throw new WsException("Unable to Create App '" + path + "'. Application already exits.");
            }
        } else {
            throw new WsException("Unable to create App '" + path + "'", 400);
        }
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("enabled", false);
        this.configService.setConfiguration(path, config);
        this.configService.setConfiguration(path, null);
    }

    @POST
    @Path(value="/rest/logs/{type}")
    public LogResponse getLogs(@PathParam(value="type") String type, LogRequest request) throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
        return LogReaderUtil.readLog((String)type, (LogRequest)request);
    }

    @GET
    @Path(value="/rest/logs/{type}")
    public Response downloadLog(@PathParam(value="type") String type) throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
        Response.ResponseBuilder builder = Response.ok((Object)LogReaderUtil.getZippedLog((String)type), (String)"application/octet-stream");
        builder.header("content-disposition", (Object)("attachment; filename = " + type + ".zip"));
        return builder.build();
    }

    @GET
    @Path(value="/rest/logs/sessionApps")
    public List<ApplicationInfoMsg> getAppsForSessionLogView() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
        this.getHandler().checkMasterPermission(WebswingAction.rest_getApps);
        return this.getGlobalHandler().getApplications().stream().filter(app -> app.getConfig().getSwingConfig().isSessionLogging()).map(app -> app.getApplicationInfoMsg()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/rest/sessions")
    public Sessions getSessions() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_getSession);
        Sessions result = new Sessions();
        this.getGlobalHandler().getApplications().forEach(app -> app.getSwingInstanceHolder().getAllInstances().forEach(si -> result.getSessions().add(si.toSwingSession(false))));
        this.getGlobalHandler().getApplications().forEach(app -> app.getSwingInstanceHolder().getAllClosedInstances().forEach(si -> result.getClosedSessions().add(si.toSwingSession(false))));
        return result;
    }

    @GET
    @Path(value="/rest/stats")
    public Map<String, Map<Long, Number>> getStats() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_getStats);
        List allStats = this.getGlobalHandler().getApplications().stream().map(app -> app.getStatsReader().getAllInstanceStats()).flatMap(Collection::stream).collect(Collectors.toList());
        allStats.addAll(this.loggerService.getServerLogger().getAllInstanceStats());
        return LoggerStatisticsUtil.mergeSummaryInstanceStats(allStats);
    }

    protected PrimaryUrlHandler getHandler() {
        return this.handler;
    }

    GlobalUrlHandler getGlobalHandler() {
        return this.handler;
    }

    protected ConfigurationService getConfigService() {
        return this.configService;
    }
}

