/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.stats.StatisticsLogger;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.stats.logger.DefaultStatisticsLogger;

@Singleton
public class StatisticsLoggerServiceImpl
implements StatisticsLoggerService {
    public static final String SERVER_LOGGER_INSTANCE_NAME = "server";
    private static final long SERVER_LOGGER_PERIOD = 1000L;
    private Timer timer;
    private StatisticsLogger serverLogger = new DefaultStatisticsLogger();

    @Inject
    public StatisticsLoggerServiceImpl() {
    }

    @Override
    public void start() throws WsInitException {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double cpuUsage = CpuMonitor.getCpuUtilization();
                StatisticsLoggerServiceImpl.this.getServerLogger().log(StatisticsLoggerServiceImpl.SERVER_LOGGER_INSTANCE_NAME, "cpuUtilization", cpuUsage);
                StatisticsLoggerServiceImpl.this.getServerLogger().log(StatisticsLoggerServiceImpl.SERVER_LOGGER_INSTANCE_NAME, "cpuUtilizationServer", cpuUsage);
            }
        }, 1000L, 1000L);
    }

    @Override
    public void stop() {
        this.timer.cancel();
    }

    @Override
    public StatisticsLogger createLogger() {
        return new DefaultStatisticsLogger();
    }

    @Override
    public StatisticsLogger getServerLogger() {
        return this.serverLogger;
    }

    private static class CpuMonitor {
        static long previousCPUTime = 0L;
        static long previousTime = 0L;

        private CpuMonitor() {
        }

        static double getCpuUtilization() {
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            long currentCpuTime = operatingSystemMXBean.getProcessCpuTime();
            long now = ManagementFactory.getRuntimeMXBean().getUptime();
            long cpuTimeDelta = currentCpuTime - previousCPUTime;
            previousCPUTime = currentCpuTime;
            long timeDelta = now - previousTime;
            previousTime = now;
            int processors = Runtime.getRuntime().availableProcessors();
            if (timeDelta == 0L || processors == 0) {
                return 0.0;
            }
            double cpuUsage = (double)TimeUnit.NANOSECONDS.toMillis(cpuTimeDelta) / (double)timeDelta;
            return Math.max(0.0, cpuUsage /= (double)processors) * 100.0;
        }

        static {
            CpuMonitor.getCpuUtilization();
        }
    }
}

