/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swinginstance;

import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import main.Main;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.FileSize;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileSize;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgIn;
import org.webswing.model.MsgInternal;
import org.webswing.model.MsgOut;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.c2s.ParamMsg;
import org.webswing.model.c2s.SimpleEventMsgIn;
import org.webswing.model.c2s.TimestampsMsgIn;
import org.webswing.model.internal.ApiCallMsgInternal;
import org.webswing.model.internal.ApiEventMsgInternal;
import org.webswing.model.internal.ExitMsgInternal;
import org.webswing.model.internal.JvmStatsMsgInternal;
import org.webswing.model.internal.OpenFileResultMsgInternal;
import org.webswing.model.internal.PrinterJobResultMsgInternal;
import org.webswing.model.internal.ThreadDumpMsgInternal;
import org.webswing.model.internal.ThreadDumpRequestMsgInternal;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.CursorChangeEventMsg;
import org.webswing.model.s2c.LinkActionMsg;
import org.webswing.model.s2c.SimpleEventMsgOut;
import org.webswing.server.common.model.AppletLauncherConfig;
import org.webswing.server.common.model.DesktopLauncherConfig;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.model.admin.SwingInstanceStatus;
import org.webswing.server.common.model.admin.SwingSession;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.EncodedMessage;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.files.FileTransferHandler;
import org.webswing.server.services.jvmconnection.JvmConnection;
import org.webswing.server.services.jvmconnection.JvmConnectionService;
import org.webswing.server.services.jvmconnection.JvmListener;
import org.webswing.server.services.recorder.SessionRecorder;
import org.webswing.server.services.recorder.SessionRecorderService;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.modules.AbstractSecurityModule;
import org.webswing.server.services.stats.StatisticsReader;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingprocess.ProcessExitListener;
import org.webswing.server.services.swingprocess.SwingProcess;
import org.webswing.server.services.swingprocess.SwingProcessConfig;
import org.webswing.server.services.swingprocess.SwingProcessImpl;
import org.webswing.server.services.swingprocess.SwingProcessService;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.services.websocket.WebSocketUserInfo;
import org.webswing.server.util.FontUtils;
import org.webswing.server.util.LogReaderUtil;
import org.webswing.server.util.ServerUtil;
import org.webswing.toolkit.api.WebswingApi;

public class SwingInstanceImpl
implements Serializable,
SwingInstance,
JvmListener {
    private static final long serialVersionUID = -4640770499863974871L;
    private static final String LAUNCHER_CONFIG = "launcherConfig";
    private static final String WEB_TOOLKIT_CLASS_NAME = "org.webswing.toolkit.WebToolkit";
    private static final String WEB_GRAPHICS_ENV_CLASS_NAME = "org.webswing.toolkit.ge.WebGraphicsEnvironment";
    private static final String WEB_PRINTER_JOB_CLASS_NAME = "org.webswing.toolkit.WebPrinterJobWrapper";
    private static final String SHELL_FOLDER_MANAGER = "sun.awt.shell.PublicShellFolderManager";
    private static final String JAVA9_PATCHED_JSOBJECT_MODULE_MARKER = "netscape.javascript.WebswingPatchedJSObjectJarMarker";
    private static final String JAVA_FX_PATH = System.getProperty("java.home") + "/lib/ext/jfxrt.jar";
    private static final String JAVA_FX_TOOLKIT_CLASS_NAME = "org.webswing.javafx.toolkit.WebsinwgFxToolkitFactory";
    private static final long DEFAULT_LOG_SIZE = 0xA00000L;
    private static final Logger log = LoggerFactory.getLogger(SwingInstance.class);
    private final String instanceId;
    private final String ownerId;
    private WebSocketConnection webConnection;
    private WebSocketConnection mirroredWebConnection;
    private final SwingInstanceManager manager;
    private final FileTransferHandler fileHandler;
    private SwingProcess process;
    private JvmConnection jvmConnection;
    private SessionRecorder sessionRecorder;
    private SwingConfig config;
    private VariableSubstitutor subs;
    private final Date startedAt = new Date();
    private WebSocketUserInfo lastConnection = null;
    private Date endedAt = null;
    private List<String> warningHistoryLog;
    private Map<Long, ThreadDumpMsgInternal> threadDumps = new ConcurrentHashMap<Long, ThreadDumpMsgInternal>();

    public SwingInstanceImpl(SwingInstanceManager manager, FileTransferHandler fileHandler, SwingProcessService processService, JvmConnectionService connectionService, SessionRecorderService recorderService, ConnectionHandshakeMsgIn h, SwingConfig config, WebSocketConnection websocket) throws WsException {
        this.manager = manager;
        this.fileHandler = fileHandler;
        this.webConnection = websocket;
        this.config = config;
        this.ownerId = ServerUtil.resolveOwnerIdForSessionMode(websocket, h, config);
        this.instanceId = ServerUtil.generateInstanceId(websocket, h, manager.getPathMapping());
        AbstractWebswingUser user = websocket.getUser();
        WebSocketUserInfo info = websocket.getUserInfo();
        this.subs = VariableSubstitutor.forSwingInstance((SecuredPathConfig)manager.getConfig(), (String)user.getUserId(), (Map)user.getUserAttributes(), (String)this.getInstanceId(), (String)info.getUserIp(), (String)h.getLocale(), (String)h.getTimeZone(), (String)info.getCustomArgs());
        this.sessionRecorder = recorderService.create(this, manager);
        try {
            this.jvmConnection = connectionService.connect(this.instanceId, this);
            this.process = this.start(processService, config, h, websocket);
            this.notifyUserConnected();
        }
        catch (Exception e) {
            this.notifyExiting();
            throw new WsException("Failed to create App instance.", (Throwable)e);
        }
        if (ServerUtil.isRecording(websocket.getRequest())) {
            this.sessionRecorder.startRecording();
        }
        this.logStatValue("webSocketConnected", websocket.isWebsocketTransport() ? 1 : 2);
    }

    @Override
    public void connectSwingInstance(WebSocketConnection r, ConnectionHandshakeMsgIn h) {
        if (h.isMirrored()) {
            this.connectMirroredWebSession(r);
        } else if (h.getConnectionId() != null && h.getConnectionId().equals(this.getConnectionId())) {
            this.sendToSwing(r, (MsgIn)h);
        } else {
            boolean result = this.connectPrimaryWebSession(r);
            if (result) {
                r.broadcastMessage((MsgOut)SimpleEventMsgOut.continueOldSession.buildMsgOut());
            } else {
                r.broadcastMessage((MsgOut)SimpleEventMsgOut.applicationAlreadyRunning.buildMsgOut());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectPrimaryWebSession(WebSocketConnection resource) {
        if (resource != null) {
            if (this.webConnection != null && this.config.isAllowStealSession()) {
                WebSocketConnection webSocketConnection = this.webConnection;
                synchronized (webSocketConnection) {
                    this.webConnection.broadcastMessage((MsgOut)SimpleEventMsgOut.sessionStolenNotification.buildMsgOut());
                }
                this.notifyUserDisconnected();
                this.webConnection = null;
            }
            if (this.webConnection == null) {
                this.webConnection = resource;
                this.logStatValue("webSocketConnected", resource.isWebsocketTransport() ? 1 : 2);
                this.notifyUserConnected();
                return true;
            }
        }
        return false;
    }

    private void disconnectPrimaryWebSession() {
        if (this.webConnection != null) {
            this.notifyUserDisconnected();
            this.lastConnection = this.webConnection.getUserInfo();
            this.lastConnection.setDisconnected();
            this.webConnection = null;
            this.logStatValue("webSocketConnected", 0);
        }
    }

    @Override
    public void shutdown(boolean force) {
        if (force) {
            this.kill(0);
        } else {
            SimpleEventMsgIn simpleEventMsgIn = new SimpleEventMsgIn();
            simpleEventMsgIn.setType(SimpleEventMsgIn.SimpleEventType.killSwing);
            this.sendToSwing(null, (MsgIn)simpleEventMsgIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectMirroredWebSession(WebSocketConnection resource) {
        if (resource != null) {
            if (this.mirroredWebConnection != null) {
                WebSocketConnection webSocketConnection = this.mirroredWebConnection;
                synchronized (webSocketConnection) {
                    this.mirroredWebConnection.broadcastMessage((MsgOut)SimpleEventMsgOut.sessionStolenNotification.buildMsgOut());
                }
                this.notifyMirrorViewDisconnected();
            }
            this.mirroredWebConnection = resource;
            this.notifyMirrorViewConnected();
        }
    }

    private void disconnectMirroredWebSession() {
        if (this.mirroredWebConnection != null) {
            this.notifyMirrorViewDisconnected();
            this.mirroredWebConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToWeb(MsgOut o) {
        WebSocketConnection webSocketConnection;
        EncodedMessage serialized = new EncodedMessage(o);
        if (this.sessionRecorder != null && this.sessionRecorder.isRecording()) {
            this.sessionRecorder.saveFrame(serialized.getProtoMessage());
        }
        if (this.webConnection != null) {
            webSocketConnection = this.webConnection;
            synchronized (webSocketConnection) {
                this.webConnection.broadcastMessage(serialized);
                int length = serialized.getLength(this.webConnection.isBinary());
                this.logStatValue("outboundSize", length);
            }
        }
        if (this.mirroredWebConnection != null) {
            webSocketConnection = this.mirroredWebConnection;
            synchronized (webSocketConnection) {
                this.mirroredWebConnection.broadcastMessage(serialized);
            }
        }
    }

    @Override
    public boolean sendToSwing(WebSocketConnection r, MsgIn h) {
        if (this.isRunning()) {
            if (h instanceof SimpleEventMsgIn) {
                SimpleEventMsgIn m = (SimpleEventMsgIn)h;
                if (m.getType().equals((Object)SimpleEventMsgIn.SimpleEventType.paintAck)) {
                    if (this.webConnection != null && r.uuid().equals(this.webConnection.uuid()) || this.webConnection == null && this.mirroredWebConnection != null && r.uuid().equals(this.mirroredWebConnection.uuid())) {
                        this.jvmConnection.send((Serializable)h);
                    }
                } else if (m.getType().equals((Object)SimpleEventMsgIn.SimpleEventType.unload)) {
                    if (this.webConnection != null && r.uuid().equals(this.webConnection.uuid())) {
                        this.jvmConnection.send((Serializable)h);
                    }
                    this.disconnectPrimaryWebSession();
                    this.disconnectMirroredWebSession();
                } else {
                    this.jvmConnection.send((Serializable)h);
                }
            } else if (h instanceof TimestampsMsgIn) {
                this.processTimestampMessage((TimestampsMsgIn)h);
                this.jvmConnection.send((Serializable)h);
            } else {
                this.jvmConnection.send((Serializable)h);
            }
            return true;
        }
        return false;
    }

    private void processTimestampMessage(TimestampsMsgIn h) {
        if (StringUtils.isNotEmpty((String)h.getSendTimestamp())) {
            long currentTime = System.currentTimeMillis();
            long sendTime = Long.parseLong(h.getSendTimestamp());
            if (StringUtils.isNotEmpty((String)h.getRenderingTime()) && StringUtils.isNotEmpty((String)h.getStartTimestamp())) {
                long renderingTime = Long.parseLong(h.getRenderingTime());
                long startTime = Long.parseLong(h.getStartTimestamp());
                this.logStatValue("latencyServerRendering", sendTime - startTime);
                this.logStatValue("latencyClientRendering", renderingTime);
                this.logStatValue("latency", currentTime - startTime);
                this.logStatValue("latencyNetworkTransfer", currentTime - sendTime - renderingTime);
            }
        }
        if (h.getPing() > 0) {
            this.logStatValue("latencyPing", h.getPing());
        }
    }

    @Override
    public void onJvmMessage(Serializable o) {
        if (o instanceof MsgInternal) {
            if (o instanceof ApiCallMsgInternal) {
                ApiCallMsgInternal query = (ApiCallMsgInternal)o;
                AbstractWebswingUser currentUser = this.webConnection != null ? this.webConnection.getUser() : null;
                switch (query.getMethod()) {
                    case HasRole: {
                        if (currentUser == null) {
                            query.setResult(null);
                        } else {
                            Boolean result = currentUser.hasRole((String)((Object)query.getArgs()[0]));
                            query.setResult((Serializable)result);
                        }
                        this.jvmConnection.send((Serializable)query);
                        break;
                    }
                    case IsPermitted: {
                        if (currentUser == null) {
                            query.setResult(null);
                        } else {
                            Boolean result = currentUser.isPermitted((String)((Object)query.getArgs()[0]));
                            query.setResult((Serializable)result);
                        }
                        this.jvmConnection.send((Serializable)query);
                        break;
                    }
                }
            } else if (o instanceof PrinterJobResultMsgInternal) {
                PrinterJobResultMsgInternal pj = (PrinterJobResultMsgInternal)o;
                boolean success = this.fileHandler.registerFile(pj.getPdfFile(), pj.getId(), 30L, TimeUnit.MINUTES, this.getUserId(), this.getInstanceId(), pj.isTempFile(), false, null);
                if (success) {
                    AppFrameMsgOut f = new AppFrameMsgOut();
                    LinkActionMsg linkAction = new LinkActionMsg(LinkActionMsg.LinkActionType.print, pj.getId());
                    f.setLinkAction(linkAction);
                    this.sendToWeb((MsgOut)f);
                }
            } else if (o instanceof OpenFileResultMsgInternal) {
                OpenFileResultMsgInternal fr = (OpenFileResultMsgInternal)o;
                String extension = this.getFileExtension(fr.getFile());
                String id = UUID.randomUUID().toString() + extension;
                boolean success = this.fileHandler.registerFile(fr.getFile(), id, 30L, TimeUnit.MINUTES, this.getUserId(), this.getInstanceId(), false, fr.isWaitForFile(), fr.getOverwriteDetails());
                if (success) {
                    AppFrameMsgOut f = new AppFrameMsgOut();
                    LinkActionMsg linkAction = new LinkActionMsg(LinkActionMsg.LinkActionType.file, id);
                    f.setLinkAction(linkAction);
                    this.sendToWeb((MsgOut)f);
                }
            } else if (o instanceof JvmStatsMsgInternal) {
                JvmStatsMsgInternal s = (JvmStatsMsgInternal)o;
                double cpuUsage = s.getCpuUsage();
                this.logStatValue("memoryAllocated", s.getHeapSize());
                this.logStatValue("memoryUsed", s.getHeapSizeUsed());
                this.logStatValue("cpuUtilization", cpuUsage);
                this.logStatValue("cpuUtilizationSession", cpuUsage);
                this.logStatValue("edtThreadBlockedForSeconds", s.getEdtPingSeconds());
                if (this.getAppConfig().isMonitorEdtEnabled() && s.getEdtPingSeconds() > Math.max(2, this.getAppConfig().getLoadingAnimationDelay())) {
                    this.sendToWeb((MsgOut)SimpleEventMsgOut.applicationBusy.buildMsgOut());
                }
            } else if (o instanceof ExitMsgInternal) {
                this.close();
                ExitMsgInternal e = (ExitMsgInternal)o;
                this.kill(e.getWaitForExit());
            } else if (o instanceof ThreadDumpMsgInternal) {
                ThreadDumpMsgInternal e = (ThreadDumpMsgInternal)o;
                this.threadDumps.put(e.getTimestamp(), e);
            }
        } else if (o instanceof AppFrameMsgOut && ((AppFrameMsgOut)o).getCursorChange() != null) {
            CursorChangeEventMsg cmsg = ((AppFrameMsgOut)o).getCursorChange();
            if (cmsg.getCurFile() != null) {
                File cur = new File(cmsg.getCurFile());
                boolean success = this.fileHandler.registerFile(cur, cur.getName(), 1L, TimeUnit.DAYS, this.getUserId(), this.getInstanceId(), false, false, null);
                cmsg.setCurFile(cur.getName());
            }
            this.sendToWeb((MsgOut)o);
        } else if (o instanceof MsgOut) {
            this.sendToWeb((MsgOut)o);
        }
    }

    private void close() {
        if (this.config.isAutoLogout()) {
            this.sendToWeb((MsgOut)SimpleEventMsgOut.shutDownAutoLogoutNotification.buildMsgOut());
            if (this.webConnection != null) {
                this.webConnection.logoutUser();
            } else if (this.lastConnection != null) {
                this.lastConnection.logoutUser();
            }
        }
        if (StringUtils.isNotBlank((String)this.config.getGoodbyeUrl())) {
            String url = this.subs.replace(this.config.getGoodbyeUrl());
            if (url.startsWith("/")) {
                url = AbstractSecurityModule.getContextPath((ServletContext)this.manager.getServletContext()) + url;
            }
            AppFrameMsgOut result = new AppFrameMsgOut();
            result.setLinkAction(new LinkActionMsg(LinkActionMsg.LinkActionType.redirect, url));
            this.sendToWeb((MsgOut)result);
        } else {
            this.sendToWeb((MsgOut)SimpleEventMsgOut.shutDownNotification.buildMsgOut());
        }
        this.jvmConnection.close();
        this.notifyExiting();
        if (this.process != null && this.config.isIsolatedFs() && this.config.isClearTransferDir()) {
            String transferDir = this.process.getConfig().getProperties().get("webswing.transfer.dir");
            try {
                if (transferDir.indexOf(File.pathSeparator) != -1) {
                    throw new IOException("Can not clear upload folder if multiple roots are defined. Turn off the option in Webswing config. [" + transferDir + "]");
                }
                if (transferDir != null) {
                    FileUtils.deleteDirectory((File)new File(transferDir));
                    log.info("Transfer dir for session [" + this.process.getConfig().getName() + "] cleared. [" + transferDir + "]");
                }
            }
            catch (IOException e) {
                log.error("Failed to delete transfer dir " + transferDir, (Throwable)e);
            }
        }
    }

    @Override
    public void notifyExiting() {
        this.endedAt = new Date();
        if (this.isRunning()) {
            this.process.setProcessExitListener(null);
        }
        try {
            if (this.sessionRecorder != null && this.sessionRecorder.isRecording()) {
                this.sessionRecorder.stopRecording();
            }
        }
        catch (WsException e) {
            log.error("Stop Recording:", (Throwable)e);
        }
        this.manager.notifySwingClose(this);
    }

    @Override
    public void startRecording() throws WsException {
        this.sessionRecorder.startRecording();
        this.sendToSwing(this.webConnection, (MsgIn)new SimpleEventMsgIn(SimpleEventMsgIn.SimpleEventType.repaint));
    }

    @Override
    public void stopRecording() throws WsException {
        this.sessionRecorder.stopRecording();
    }

    @Override
    public SwingSession toSwingSession(boolean stats) {
        SwingSession session = new SwingSession();
        session.setId(this.getInstanceId());
        session.setApplet(Boolean.valueOf(SwingConfig.LauncherType.Applet.equals((Object)this.getAppConfig().getLauncherType())));
        session.setApplication(this.getAppConfig().getName());
        session.setApplicationUrl(this.manager.getFullPathMapping());
        session.setConnected(Boolean.valueOf(this.getConnectionId() != null));
        WebSocketUserInfo info = this.webConnection == null ? this.lastConnection : this.webConnection.getUserInfo();
        session.setDisconnectedSince(info.getDisconnectedSince());
        session.setUser(info.getUserId());
        session.setUserIp(info.getUserIp());
        session.setUserOs(info.getUserOs());
        session.setUserBrowser(info.getUserBrowser());
        session.setStartedAt(this.getStartedAt());
        session.setEndedAt(this.getEndedAt());
        session.setStatus(this.getStatus());
        StatisticsReader statReader = this.manager.getStatsReader();
        if (stats) {
            session.setStats(statReader.getInstanceStats(this.getInstanceId()));
        }
        session.setMetrics(statReader.getInstanceMetrics(this.getInstanceId()));
        session.setWarnings(statReader.getInstanceWarnings(this.getInstanceId()));
        if (this.isRunning()) {
            session.setWarningHistory(statReader.getInstanceWarningHistory(this.getInstanceId()));
        } else {
            session.setWarningHistory(this.warningHistoryLog);
        }
        session.setRecorded(Boolean.valueOf(this.isRecording()));
        session.setRecordingFile(this.getRecordingFile());
        session.setThreadDumps(this.toMap(this.threadDumps));
        session.setLoggingEnabled(this.getAppConfig().isSessionLogging());
        return session;
    }

    @Override
    public void kill(int delayMs) {
        if (this.process != null) {
            this.process.destroy(delayMs);
        }
    }

    private SwingProcess start(SwingProcessService processService, SwingConfig appConfig, ConnectionHandshakeMsgIn handshake, WebSocketConnection websocket) throws Exception {
        Integer screenWidth = handshake.getDesktopWidth();
        Integer screenHeight = handshake.getDesktopHeight();
        SwingProcess swing = null;
        try {
            SwingProcessConfig swingConfig = new SwingProcessConfig();
            swingConfig.setName(this.getInstanceId());
            swingConfig.setApplicationName(this.getAppConfig().getName());
            String java = this.getAbsolutePath(this.subs.replace(appConfig.getJreExecutable()), false);
            swingConfig.setJreExecutable(java);
            String homeDir = this.getAbsolutePath(this.subs.replace(appConfig.getUserDir()), true);
            swingConfig.setBaseDir(homeDir);
            swingConfig.setMainClass(Main.class.getName());
            swingConfig.setClassPath(new File(URI.create(CommonUtil.getWarFileLocation())).getAbsolutePath());
            String javaVersion = this.subs.replace(appConfig.getJavaVersion());
            boolean useJFX = this.config.isJavaFx();
            String webToolkitClass = WEB_TOOLKIT_CLASS_NAME;
            String webFxToolkitFactory = JAVA_FX_TOOLKIT_CLASS_NAME;
            String javaFxBootClasspath = "";
            String javaFxAppClasspath = "";
            String webGraphicsEnvClass = WEB_GRAPHICS_ENV_CLASS_NAME;
            String j9modules = "";
            if (javaVersion.startsWith("1.8")) {
                webToolkitClass = webToolkitClass + "8";
                webFxToolkitFactory = webFxToolkitFactory + "8";
                webGraphicsEnvClass = webGraphicsEnvClass + "8";
                if (useJFX) {
                    if (!new File(JAVA_FX_PATH).exists()) {
                        log.warn("JavaFx library not found in '" + new File(JAVA_FX_PATH).getCanonicalPath() + "'. ");
                        useJFX = false;
                    }
                    javaFxBootClasspath = javaFxBootClasspath + File.pathSeparator + CommonUtil.getBootClassPathForClass((String)JAVA_FX_TOOLKIT_CLASS_NAME) + File.pathSeparator + CommonUtil.getBootClassPathForClass((String)webFxToolkitFactory) + File.pathSeparator + "\"" + new File(JAVA_FX_PATH).getCanonicalPath() + "\"";
                }
            } else if (javaVersion.startsWith("11")) {
                webToolkitClass = webToolkitClass + "11";
                webFxToolkitFactory = webFxToolkitFactory + "11";
                webGraphicsEnvClass = webGraphicsEnvClass + "11";
                if (useJFX) {
                    javaFxAppClasspath = javaFxAppClasspath + CommonUtil.getBootClassPathForClass((String)JAVA_FX_TOOLKIT_CLASS_NAME, (boolean)false) + ";" + CommonUtil.getBootClassPathForClass((String)webFxToolkitFactory, (boolean)false) + ";";
                }
                j9modules = " --patch-module jdk.jsobject=" + CommonUtil.getBootClassPathForClass((String)JAVA9_PATCHED_JSOBJECT_MODULE_MARKER);
                j9modules = j9modules + " --patch-module java.desktop=" + CommonUtil.getBootClassPathForClass((String)SHELL_FOLDER_MANAGER);
                j9modules = j9modules + " --add-reads jdk.jsobject=ALL-UNNAMED ";
                j9modules = j9modules + " --add-opens java.base/java.net=ALL-UNNAMED ";
                j9modules = j9modules + " --add-opens java.desktop/java.awt=ALL-UNNAMED ";
                j9modules = j9modules + " --add-opens java.desktop/sun.awt.windows=ALL-UNNAMED ";
                j9modules = j9modules + " --add-opens java.desktop/java.awt.event=ALL-UNNAMED ";
            } else {
                log.error("Java version " + javaVersion + " not supported in this version of Webswing.");
                throw new RuntimeException("Java version not supported. (Versions starting with 1.8 and 11 are supported.)");
            }
            String webSwingToolkitApiJarPath = CommonUtil.getBootClassPathForClass((String)WebswingApi.class.getName());
            String webSwingToolkitJarPath = CommonUtil.getBootClassPathForClass((String)WEB_TOOLKIT_CLASS_NAME);
            String webSwingToolkitJarPathSpecific = CommonUtil.getBootClassPathForClass((String)webToolkitClass);
            String shellFolderMgrJarPath = File.pathSeparator + CommonUtil.getBootClassPathForClass((String)SHELL_FOLDER_MANAGER);
            String bootCp = "-Xbootclasspath/a:" + webSwingToolkitApiJarPath + File.pathSeparatorChar + webSwingToolkitJarPathSpecific + File.pathSeparatorChar + webSwingToolkitJarPath + shellFolderMgrJarPath;
            if (useJFX) {
                bootCp = bootCp + javaFxBootClasspath;
            }
            int debugPort = websocket.getUserInfo().getDebugPort();
            String debug = appConfig.isDebug() && debugPort != 0 ? " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=" + debugPort + ",server=y,suspend=y " : "";
            String vmArgs = appConfig.getVmArgs() == null ? "" : this.subs.replace(appConfig.getVmArgs());
            swingConfig.setJvmArgs(j9modules + bootCp + debug + " -noverify " + vmArgs);
            swingConfig.addProperty("webswing.clientId", this.getInstanceId());
            swingConfig.addProperty("webswing.appId", this.manager.getPathMapping());
            swingConfig.addProperty("webswing.jmsQueueId", this.instanceId);
            swingConfig.addProperty("webswing.applicationHome", this.getAbsolutePath(".", false));
            swingConfig.addProperty("webswing.classPath", javaFxAppClasspath + this.subs.replace(CommonUtil.generateClassPathString((Collection)appConfig.getClassPathEntries())));
            swingConfig.addProperty("webswing.tempDirPath", System.getProperty("webswing.tempDirPath"));
            swingConfig.addProperty("webswing.jmsUrl", System.getProperty("webswing.jmsUrl", "nio://127.0.0.1:34455"));
            swingConfig.addProperty("webswing.theme", this.subs.replace(appConfig.getTheme()));
            swingConfig.addProperty("webswing.isolatedFs", appConfig.isIsolatedFs());
            swingConfig.addProperty("webswing.transfer.dir", this.getAbsolutePaths(this.subs.replace(appConfig.getTransferDir()), false));
            swingConfig.addProperty("webswing.allowDownload", appConfig.isAllowDownload());
            swingConfig.addProperty("webswing.allowAutoDownload", appConfig.isAllowAutoDownload());
            swingConfig.addProperty("webswing.allowUpload", appConfig.isAllowUpload());
            swingConfig.addProperty("webswing.transparentFileOpen", appConfig.isTransparentFileOpen());
            swingConfig.addProperty("webswing.transparentFileSave", appConfig.isTransparentFileSave());
            swingConfig.addProperty("webswing.allowDelete", appConfig.isAllowDelete());
            swingConfig.addProperty("webswing.allowLocalClipboard", appConfig.isAllowLocalClipboard());
            swingConfig.addProperty("webswing.allowJsLink", appConfig.isAllowJsLink());
            swingConfig.addProperty("webswing.initialUrl", handshake.getUrl());
            swingConfig.addProperty("webswing.messagingApiTopicName", "msgApiSharedTopic" + this.manager.getFullPathMapping());
            swingConfig.addProperty("webswing.directdraw", appConfig.isDirectdraw());
            swingConfig.addProperty("webswing.directdraw.supported", handshake.isDirectDrawSupported());
            swingConfig.addProperty("webswing.sessionTimeoutSec", appConfig.getSwingSessionTimeout());
            swingConfig.addProperty("webswing.sessionTimeoutIfInactive", appConfig.isTimeoutIfInactive());
            swingConfig.addProperty("awt.toolkit", webToolkitClass);
            swingConfig.addProperty("java.awt.headless", false);
            swingConfig.addProperty("java.awt.graphicsenv", webGraphicsEnvClass);
            swingConfig.addProperty("java.awt.printerjob", WEB_PRINTER_JOB_CLASS_NAME);
            swingConfig.addProperty("webswing.printerJobDelegate", appConfig.isAllowServerPrinting() ? PrinterJob.getPrinterJob().getClass().getCanonicalName() : "org.webswing.toolkit.WebPrinterJob");
            swingConfig.addProperty("sun.awt.fontconfig", FontUtils.createFontConfiguration(appConfig, this.subs));
            swingConfig.addProperty("webswing.screenWidth", screenWidth == null ? 300 : screenWidth);
            swingConfig.addProperty("webswing.screenHeight", screenHeight == null ? 300 : screenHeight);
            if (useJFX) {
                swingConfig.addProperty("webswing.fxToolkitFactory", webFxToolkitFactory);
                swingConfig.addProperty("glass.platform", "Web");
                swingConfig.addProperty("prism.order", "web");
                swingConfig.addProperty("prism.text", "t2k");
                swingConfig.addProperty("prism.lcdtext", "false");
                swingConfig.addProperty("javafx.live.resize", "false");
            }
            if (this.config.isSessionLogging()) {
                swingConfig.setLogAppender(this.createSessionLogAppender());
            }
            switch (appConfig.getLauncherType()) {
                case Applet: {
                    AppletLauncherConfig applet = (AppletLauncherConfig)appConfig.getValueAs(LAUNCHER_CONFIG, AppletLauncherConfig.class);
                    swingConfig.addProperty("webswing.appletDocumentBase", handshake.getDocumentBase());
                    swingConfig.addProperty("webswing.appletClass", applet.getAppletClass());
                    for (String key : applet.getParameters().keySet()) {
                        swingConfig.addProperty("webswing.appletParam_" + this.subs.replace(key), this.subs.replace((String)applet.getParameters().get(key)));
                    }
                    if (handshake.getParams() == null) break;
                    for (ParamMsg p : handshake.getParams()) {
                        swingConfig.addProperty("webswing.appletParam_" + p.getName(), p.getValue());
                    }
                    break;
                }
                case Desktop: {
                    DesktopLauncherConfig desktop = (DesktopLauncherConfig)appConfig.getValueAs(LAUNCHER_CONFIG, DesktopLauncherConfig.class);
                    swingConfig.setArgs(this.subs.replace(desktop.getArgs()));
                    swingConfig.addProperty("webswing.mainClass", this.subs.replace(desktop.getMainClass()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Launcher type not recognized.");
                }
            }
            swing = processService.create(swingConfig);
            swing.execute();
            swing.setProcessExitListener(new ProcessExitListener(){

                @Override
                public void onClose() {
                    SwingInstanceImpl.this.close();
                }
            });
        }
        catch (Exception e1) {
            this.close();
            throw new Exception(e1);
        }
        return swing;
    }

    private String getAbsolutePaths(String paths, boolean b) throws IOException {
        String result = "";
        for (String s : paths.split(File.pathSeparator)) {
            result = result + this.getAbsolutePath(s, b) + File.pathSeparator;
        }
        return result.substring(0, Math.max(0, result.length() - 1));
    }

    private String getAbsolutePath(String path, boolean create) throws IOException {
        File f;
        if (StringUtils.isBlank((String)path)) {
            path = ".";
        }
        if ((f = this.manager.resolveFile(path)) == null || !f.exists()) {
            boolean done;
            boolean absolute;
            String[] pathSegs = (path = path.replaceAll("\\\\", "/")).split("/");
            boolean bl = absolute = pathSegs[0].length() == 0 || pathSegs[0].contains(":");
            if (!absolute) {
                File home = this.manager.resolveFile(".");
                f = new File(home, path);
            } else {
                f = new File(path);
            }
            if (create && !(done = f.mkdirs())) {
                throw new IOException("Unable to create path. " + f.getAbsolutePath());
            }
        }
        return f.getCanonicalPath();
    }

    private Appender createSessionLogAppender() {
        String logDir = LogReaderUtil.getSessionLogDir(this.subs, this.config);
        if (StringUtils.isNotBlank((String)logDir)) {
            logDir = new File("").toURI().relativize(new File(logDir).toURI()).getPath();
        }
        String appUrlNormalized = LogReaderUtil.normalizeForFileName(this.manager.getApplicationInfoMsg().getUrl());
        String sessionIdNormalized = LogReaderUtil.normalizeForFileName(this.getInstanceId());
        String logFileName = logDir + "/webswing-" + sessionIdNormalized + "-" + appUrlNormalized + ".session.log";
        String globPattern = "webswing-*-" + appUrlNormalized + ".session.log*";
        BuiltConfiguration logConfig = (BuiltConfiguration)ConfigurationBuilderFactory.newConfigurationBuilder().build();
        String singleSize = this.subs.replace(this.config.getSessionLogFileSize());
        long maxLogRollingSize = FileSize.parse((String)singleSize, (long)0xA00000L) / 2L;
        SizeBasedTriggeringPolicy sizeBasedPolicy = SizeBasedTriggeringPolicy.createPolicy((String)(maxLogRollingSize + " B"));
        String maxSize = this.subs.replace(this.config.getSessionLogMaxFileSize());
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withName(SwingProcessImpl.class.getName())).withFileName(logFileName).withFilePattern(logFileName + ".%i").withAppend(true).withLayout((Layout)PatternLayout.newBuilder().withPattern("%d %-5p [%t] (%F:%L) %m%n").build())).withPolicy((TriggeringPolicy)sizeBasedPolicy).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax("1").withConfig((Configuration)logConfig).withCustomActions(new Action[]{DeleteAction.createDeleteAction((String)logDir, (boolean)false, (int)1, (boolean)false, (PathSorter)PathSortByModificationTime.createSorter((boolean)true), (PathCondition[])new PathCondition[]{IfFileName.createNameCondition((String)globPattern, null, (PathCondition[])new PathCondition[]{IfAccumulatedFileSize.createFileSizeCondition((String)maxSize, (PathCondition[])new PathCondition[0])})}, null, (Configuration)logConfig)}).build()).build();
        appender.start();
        return appender;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public SwingConfig getAppConfig() {
        return this.config;
    }

    @Override
    public String getConnectionId() {
        if (this.webConnection != null) {
            return this.webConnection.uuid();
        }
        return null;
    }

    public String getMirroredSessionId() {
        if (this.mirroredWebConnection != null) {
            return this.mirroredWebConnection.uuid();
        }
        return null;
    }

    public boolean isRunning() {
        return this.process != null && this.process.isRunning();
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public Date getEndedAt() {
        return this.endedAt;
    }

    @Override
    public boolean isRecording() {
        return this.sessionRecorder.isRecording();
    }

    public String getRecordingFile() {
        return this.sessionRecorder.getFileName();
    }

    public SwingInstanceStatus getStatus() {
        if (this.process == null) {
            return SwingInstanceStatus.NOT_STARTED;
        }
        if (this.isRunning()) {
            if (this.getEndedAt() == null) {
                return SwingInstanceStatus.RUNNING;
            }
            return SwingInstanceStatus.EXITING;
        }
        if (this.process.isForceKilled()) {
            return SwingInstanceStatus.FORCE_KILLED;
        }
        return SwingInstanceStatus.FINISHED;
    }

    @Override
    public void webSessionDisconnected(String connectionId) {
        if (this.getConnectionId() != null && this.getConnectionId().equals(connectionId)) {
            this.disconnectPrimaryWebSession();
        } else if (this.getMirroredSessionId() != null && this.getMirroredSessionId().equals(connectionId)) {
            this.disconnectMirroredWebSession();
        }
    }

    @Override
    public String getMirrorConnectionId() {
        return this.mirroredWebConnection != null ? this.mirroredWebConnection.uuid() : null;
    }

    @Override
    public void logStatValue(String name, Number value) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.manager.logStatValue(this.getInstanceId(), name, value);
        }
    }

    @Override
    public void logWarningHistory() {
        StatisticsReader statReader = this.manager.getStatsReader();
        List<String> current = statReader.getInstanceWarnings(this.getInstanceId());
        if (current != null) {
            current.addAll(statReader.getInstanceWarningHistory(this.getInstanceId()));
        }
        this.warningHistoryLog = current;
    }

    private Map<Long, String> toMap(Map<Long, ThreadDumpMsgInternal> dumps) {
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (ThreadDumpMsgInternal dump : dumps.values()) {
            result.put(dump.getTimestamp(), dump.getReason());
        }
        return result;
    }

    @Override
    public String getThreadDump(String id) {
        try {
            ThreadDumpMsgInternal dump = this.threadDumps.get(Long.parseLong(id));
            if (dump != null) {
                return FileUtils.readFileToString((File)new File(dump.getDump()));
            }
            return null;
        }
        catch (Exception e) {
            log.error("Failed to load threaddump", (Throwable)e);
            return null;
        }
    }

    @Override
    public void requestThreadDump() {
        if (this.isRunning()) {
            this.jvmConnection.send((Serializable)new ThreadDumpRequestMsgInternal());
        }
    }

    private void notifyUserConnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.UserConnected, this.webConnection);
    }

    private void notifyUserDisconnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.UserDisconnected, this.webConnection);
    }

    private void notifyMirrorViewConnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.MirrorViewConnected, this.mirroredWebConnection);
    }

    private void notifyMirrorViewDisconnected() {
        this.sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType.MirrorViewDisconnected, this.mirroredWebConnection);
    }

    private void sendUserApiEventMsg(ApiEventMsgInternal.ApiEventType type, WebSocketConnection r) {
        ApiEventMsgInternal event;
        if (r != null && r.getUser() != null) {
            AbstractWebswingUser connectedUser = r.getUser();
            event = new ApiEventMsgInternal(type, new Serializable[]{connectedUser.getUserId(), new HashMap(connectedUser.getUserAttributes())});
        } else {
            event = new ApiEventMsgInternal(type, new Serializable[]{null, null});
        }
        this.jvmConnection.send((Serializable)event);
    }

    @Override
    public String getUserId() {
        return this.webConnection == null ? this.lastConnection.getUserId() : this.webConnection.getUserId();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }
}

