/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.UnknownSessionException;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgOut;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.EncodedMessage;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.websocket.WebSocketUserInfo;
import org.webswing.server.util.SecurityUtil;

public class WebSocketConnection {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnection.class);
    private AtmosphereResource resource;
    private UrlHandler handler;
    private WebSocketUserInfo userInfo;

    public WebSocketConnection(AtmosphereResource resource, UrlHandler handler) {
        this.resource = resource;
        this.handler = handler;
        this.userInfo = new WebSocketUserInfo(this);
    }

    public boolean isBinary() {
        return this.resource.forceBinaryWrite();
    }

    public void write(byte[] protoMessage) {
        this.resource.write(protoMessage);
    }

    public void write(String jsonMessage) {
        this.resource.write(jsonMessage);
    }

    public String uuid() {
        return this.resource.uuid();
    }

    public HttpServletRequest getRequest() {
        return this.resource.getRequest();
    }

    public AbstractWebswingUser getUser() {
        try {
            return SecurityUtil.getUser(this);
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    public void logoutUser() {
        SecurityUtil.logoutUser(this);
    }

    public String getUserId() {
        AbstractWebswingUser user = this.getUser();
        String userId = user != null ? user.getUserId() : "null";
        return userId;
    }

    public void broadcastMessage(EncodedMessage o) {
        this.broadcast((Serializable)(this.isBinary() ? o.getProtoMessage() : (byte[])o.getJsonMessage()));
    }

    public void broadcastMessage(MsgOut o) {
        this.broadcastMessage(new EncodedMessage(o));
    }

    private void broadcast(Serializable serializable) {
        for (AtmosphereResource r : this.resource.getBroadcaster().getAtmosphereResources()) {
            if (!r.uuid().equals(this.resource.uuid())) continue;
            r.getBroadcaster().broadcast((Object)serializable, r);
        }
    }

    public UrlHandler getHandler() {
        return this.handler;
    }

    public boolean hasPermission(WebswingAction action) {
        return this.getUser() == null ? false : this.getUser().isPermitted(action.name());
    }

    public void disconnect() {
        try {
            this.resource.close();
        }
        catch (IOException e) {
            log.error("Failed to close websocket connection " + this.resource.uuid());
        }
    }

    public boolean isWebsocketTransport() {
        return AtmosphereResource.TRANSPORT.WEBSOCKET.equals((Object)this.resource.transport());
    }

    public WebSocketUserInfo getUserInfo() {
        return this.userInfo;
    }
}

