/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.resources;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.resources.ResourceHandler;
import org.webswing.server.services.resources.ResourceHandlerImpl;
import org.webswing.server.services.security.api.SecurityContext;

public class ResourceHandlerImpl
extends AbstractUrlHandler
implements ResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceHandlerImpl.class);
    private SecurityContext context;

    public ResourceHandlerImpl(UrlHandler parent, SecurityContext context) {
        super(parent);
        this.context = context;
    }

    protected String getPath() {
        return "";
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        try {
            if (req.getMethod().equals("GET") || req.getMethod().equals("PUT")) {
                return this.lookup(req).respondGet(req, res);
            }
            if (req.getMethod().equals("HEAD")) {
                return this.lookup(req).respondHead(req, res);
            }
            return false;
        }
        catch (IOException e) {
            throw new WsException("Failed to process resource.", (Throwable)e);
        }
    }

    public long getLastModified(HttpServletRequest req) {
        return this.lookup(req).getLastModified();
    }

    protected LookupResult lookup(HttpServletRequest req) {
        LookupResult r = (LookupResult)req.getAttribute("lookupResult-" + this.getFullPathMapping());
        if (r == null) {
            r = this.lookupNoCache(req);
            req.setAttribute("lookupResult-" + this.getFullPathMapping(), (Object)r);
        }
        return r;
    }

    protected LookupResult lookupNoCache(HttpServletRequest req) {
        String path = this.getPathInfo(req);
        return this.lookupNoCache(req, path);
    }

    protected LookupResult lookupNoCache(HttpServletRequest req, String path) {
        if (path.equals("")) {
            path = "/index.html";
        }
        if (this.isForbidden(path)) {
            return new ErrorResult(403, "Forbidden");
        }
        URL url = this.context.getWebResource(path + "/index.html");
        if (url != null && !req.getPathInfo().endsWith("/")) {
            return new RedirectResult(path + "/");
        }
        if (url == null) {
            url = this.context.getWebResource(path);
        }
        if (url == null) {
            return new ErrorResult(404, "Not found");
        }
        String mimeType = this.getMimeType(url.getPath());
        try {
            return new ResourceUrl(mimeType, url.openConnection());
        }
        catch (IOException e) {
            log.error("Failed to serve path " + path + " with resource " + url.toString(), (Throwable)e);
            return new ErrorResult(500, e.getMessage());
        }
    }

    protected boolean isForbidden(String path) {
        String lpath = path.toLowerCase();
        return lpath.startsWith("/web-inf/") || lpath.startsWith("/meta-inf/");
    }

    protected String getMimeType(String path) {
        String mime = this.getServletContext().getMimeType(path);
        return mime != null ? mime : "application/octet-stream";
    }
}

