/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.admin.InstanceManagerStatus;
import org.webswing.server.extension.ExtensionService;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationChangeEvent;
import org.webswing.server.services.config.ConfigurationChangeListener;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.rest.RestService;
import org.webswing.server.services.security.api.BuiltInModules;
import org.webswing.server.services.security.api.WebswingSecurityConfig;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.SwingInstanceManagerService;

@Singleton
public class GlobalUrlHandler
extends PrimaryUrlHandler
implements SecuredPathHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalUrlHandler.class);
    private static final String SERVERNAME = System.getProperty("webswing.brandingPrefix", "webswing.org");
    private final ConfigurationService configService;
    private final SwingInstanceManagerService appFactory;
    private final ResourceHandlerService resourceService;
    private final LoginHandlerService loginService;
    private ServletContext servletContext;
    private final ExtensionService extService;
    private final RestService restService;
    private Map<String, SwingInstanceManager> instanceManagers = new LinkedHashMap<String, SwingInstanceManager>();
    private final ConfigurationChangeListener changeListener = new ConfigurationChangeListener(){

        @Override
        public void onConfigChanged(ConfigurationChangeEvent e) {
            if ("/".equals(e.getPath())) {
                GlobalUrlHandler.this.initConfiguration();
            } else {
                SwingInstanceManager manager = (SwingInstanceManager)GlobalUrlHandler.this.instanceManagers.get(e.getPath());
                if (manager == null) {
                    GlobalUrlHandler.this.installApplication(e.getNewConfig()).init();
                } else if (manager.isEnabled()) {
                    manager.initConfiguration();
                }
            }
        }

        @Override
        public void onConfigDeleted(ConfigurationChangeEvent e) {
            if ("/".equals(e.getPath())) {
                GlobalUrlHandler.this.initConfiguration();
            } else {
                SwingInstanceManager manager = (SwingInstanceManager)GlobalUrlHandler.this.instanceManagers.get(e.getPath());
                if (manager != null) {
                    GlobalUrlHandler.this.uninstallApplication(manager);
                }
            }
        }
    };

    @Inject
    public GlobalUrlHandler(ConfigurationService config, SwingInstanceManagerService appFactory, ResourceHandlerService resourceService, SecurityModuleService securityService, LoginHandlerService loginService, ServletContext servletContext, ExtensionService extService, RestService restService) {
        super(null, securityService, config);
        this.configService = config;
        this.appFactory = appFactory;
        this.resourceService = resourceService;
        this.loginService = loginService;
        this.servletContext = servletContext;
        this.extService = extService;
        this.restService = restService;
    }

    @Override
    public void init() {
        this.registerChildUrlHandler(this.loginService.createLoginHandler(this));
        this.registerChildUrlHandler(this.loginService.createLogoutHandler(this));
        for (UrlHandler handler : this.extService.createExtHandlers(this)) {
            this.registerChildUrlHandler(handler);
        }
        this.registerChildUrlHandler(this.resourceService.create(this, this));
        this.registerChildUrlHandler(this.restService.createGlobalRestHandler(this));
        this.loadApplications();
        this.configService.registerChangeListener(this.changeListener);
        super.init();
        if (!InstanceManagerStatus.Status.Running.equals((Object)this.getStatus().getStatus())) {
            throw new RuntimeException("Failed to start primary handler.");
        }
    }

    @Override
    public void destroy() {
        this.configService.removeChangeListener(this.changeListener);
        this.instanceManagers.clear();
        super.destroy();
    }

    @Override
    public boolean serve(HttpServletRequest req, HttpServletResponse res) {
        try {
            this.setSecurityHeaders(req, res);
            boolean served = super.serve(req, res);
            if (!served) {
                throw new WsException("Not Found.", 404);
            }
        }
        catch (Exception e) {
            this.handleException(e, req, res);
        }
        return true;
    }

    private void setSecurityHeaders(HttpServletRequest req, HttpServletResponse res) {
        res.addHeader("Server", SERVERNAME);
        if (!Boolean.getBoolean("webswing.disableHttpSecurityHeaders")) {
            res.addHeader("X-Frame-Options", "SAMEORIGIN");
            res.addHeader("X-Content-Type-Options", "nosniff");
            res.addHeader("X-XSS-Protection", "1; mode=block");
            res.addHeader("Referrer-Policy", "strict-origin-when-cross-origin");
            if (StringUtils.equalsIgnoreCase((String)req.getScheme(), (String)"https")) {
                res.addHeader("Strict-Transport-Security", "1; mode=block");
            }
        }
    }

    @Override
    protected WebswingSecurityConfig getSecurityConfig() {
        log.info("Loading master security module.(" + this.getConfig().getSecurity() + ").");
        WebswingSecurityConfig secConfig = super.getSecurityConfig();
        if (BuiltInModules.INHERITED.name().equals(secConfig.getModule())) {
            log.error("Master security module INHERITED is not valid. Falling back to default module PROPERTY_FILE.");
            SecuredPathConfig newconfig = this.getConfig();
            newconfig.getSecurity().put("module", BuiltInModules.PROPERTY_FILE.name());
            secConfig = (WebswingSecurityConfig)newconfig.getValueAs("security", WebswingSecurityConfig.class);
        }
        return secConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadApplications() {
        log.info("Loading configured Applications.");
        Map<String, SwingInstanceManager> map = this.instanceManagers;
        synchronized (map) {
            for (String path : this.configService.getPaths()) {
                SecuredPathConfig configPath = this.configService.getConfiguration(path);
                String pathMapping = GlobalUrlHandler.toPath(path);
                if (GlobalUrlHandler.toPath("/").equals(pathMapping)) continue;
                SwingInstanceManager childHandler = this.instanceManagers.get(pathMapping);
                if (childHandler == null) {
                    this.installApplication(configPath);
                    continue;
                }
                log.error("Application with path '" + pathMapping + "' already exists! Application skipped.", (Throwable)new IllegalStateException("Invalid Application configuration."));
            }
        }
    }

    public SwingInstanceManager installApplication(SecuredPathConfig swing) {
        log.info("Installing application " + swing.getPath());
        SwingInstanceManager app = this.appFactory.createApp(this, swing.getPath());
        this.registerFirstChildUrlHandler(app);
        return app;
    }

    public void uninstallApplication(SwingInstanceManager appToRemove) {
        log.info("Removing application " + appToRemove.getPathMapping());
        appToRemove.destroy();
        this.removeChildUrlHandler(appToRemove);
    }

    private void handleException(Exception e, HttpServletRequest req, HttpServletResponse res) {
        log.debug("Failed to process request. " + req.getPathInfo(), (Throwable)e);
        try {
            if (e instanceof WsException) {
                if (!res.isCommitted()) {
                    WsException wse = (WsException)((Object)e);
                    res.sendError(wse.getReponseCode(), wse.getLocalizedMessage());
                }
            } else {
                log.error("Failed to process request. " + req.getPathInfo(), (Throwable)e);
                if (!res.isCommitted()) {
                    res.setStatus(500);
                    e.printStackTrace(new PrintStream((OutputStream)res.getOutputStream()));
                }
            }
        }
        catch (IOException e1) {
            log.error("Failed send error response to client. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFirstChildUrlHandler(UrlHandler handler) {
        super.registerFirstChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map<String, SwingInstanceManager> map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.put(manager.getPathMapping(), manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChildUrlHandler(UrlHandler handler) {
        super.registerChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map<String, SwingInstanceManager> map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.put(manager.getPathMapping(), manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildUrlHandler(UrlHandler handler) {
        super.removeChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map<String, SwingInstanceManager> map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.remove(manager.getPathMapping(), manager);
            }
        }
    }

    @Override
    protected String getPath() {
        return "";
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SwingInstanceManager> getApplications() {
        ArrayList<SwingInstanceManager> result = new ArrayList<SwingInstanceManager>();
        Map<String, SwingInstanceManager> map = this.instanceManagers;
        synchronized (map) {
            result.addAll(this.instanceManagers.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingInstanceManager getApplication(String path) {
        Map<String, SwingInstanceManager> map = this.instanceManagers;
        synchronized (map) {
            return this.instanceManagers.get(path);
        }
    }

    @Override
    public URL getWebResource(String resource) {
        if (!this.isCustomIndexPage() && StringUtils.equals((String)"/index.html", (String)GlobalUrlHandler.toPath(resource))) {
            resource = System.getProperty("webswing.defaultWelcomePage", "/selector/index.html");
        }
        return super.getWebResource(resource);
    }

    private boolean isCustomIndexPage() {
        String customFolder = this.getConfig().getWebFolder();
        if (StringUtils.isBlank((String)customFolder)) {
            return false;
        }
        File customFolderFile = this.resolveFile(customFolder);
        return customFolderFile.isDirectory() && new File(customFolderFile, "index.html").isFile();
    }
}

