/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingprocess;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jms.IllegalStateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.webswing.server.services.swingprocess.ProcessExitListener;
import org.webswing.server.services.swingprocess.SwingProcess;
import org.webswing.server.services.swingprocess.SwingProcessConfig;

public class SwingProcessImpl
implements SwingProcess {
    private final Logger log;
    private final Logger defaultLog;
    private final ScheduledExecutorService processHandlerThread;
    private static final long LOG_POLLING_PERIOD = 100L;
    private final SwingProcessConfig config;
    private Process process;
    private ScheduledFuture<?> logsProcessor;
    private InputStream out;
    private InputStream err;
    private StringBuilder bufferOut = new StringBuilder();
    private StringBuilder bufferErr = new StringBuilder();
    private byte[] buffer = new byte[4096];
    private boolean hasSessionLog;
    private String sessionLogDestination;
    private boolean destroying;
    private ScheduledFuture<?> delayedTermination;
    private boolean forceKilled = false;
    private ProcessExitListener closeListener;

    public SwingProcessImpl(SwingProcessConfig config, ScheduledExecutorService processHandlerThread) {
        this.config = config;
        this.defaultLog = (Logger)LogManager.getLogger((String)(SwingProcessImpl.class + "_" + config.getApplicationName()));
        this.processHandlerThread = processHandlerThread;
        Appender logAppender = config.getLogAppender();
        if (config.getLogAppender() != null) {
            this.log = (Logger)LogManager.getLogger((String)(SwingProcessImpl.class + "_" + config.getApplicationName() + "_" + config.getName()));
            Configuration loggerConfig = ((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration();
            loggerConfig.setLoggerAdditive(this.log, false);
            if (logAppender instanceof RollingFileAppender) {
                this.sessionLogDestination = new File(((RollingFileAppender)logAppender).getFileName()).getAbsolutePath();
            }
            this.log.addAppender(logAppender);
            this.hasSessionLog = true;
        } else {
            this.log = this.defaultLog;
        }
    }

    @Override
    public void execute() throws Exception {
        ProcessBuilder processBuilder;
        if (!this.isRunning()) {
            processBuilder = new ProcessBuilder(this.buildCommandline());
            if (this.verifyBaseDir()) {
                processBuilder.directory(new File(this.config.getBaseDir()));
            }
            this.log.info("Starting application process [" + this.config.getName() + "] from [" + this.config.getBaseDir() + "] :" + processBuilder.command());
            if (this.hasSessionLog) {
                this.defaultLog.info("Starting application process [" + this.config.getName() + "] from [" + this.config.getBaseDir() + "] :" + processBuilder.command());
                this.defaultLog.info("Logging into: " + this.sessionLogDestination);
                this.log.info("Logging into: " + this.sessionLogDestination);
            }
        } else {
            throw new IllegalStateException("Process is already running.");
        }
        this.process = processBuilder.start();
        this.logsProcessor = this.processHandlerThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (SwingProcessImpl.this.process != null) {
                    if (SwingProcessImpl.this.out == null || SwingProcessImpl.this.err == null) {
                        SwingProcessImpl.this.out = SwingProcessImpl.this.process.getInputStream();
                        SwingProcessImpl.this.err = SwingProcessImpl.this.process.getErrorStream();
                    }
                    try {
                        SwingProcessImpl.this.processStream(SwingProcessImpl.this.out, SwingProcessImpl.this.bufferOut, SwingProcessImpl.this.buffer, SwingProcessImpl.this.config.getName(), false);
                        SwingProcessImpl.this.processStream(SwingProcessImpl.this.err, SwingProcessImpl.this.bufferErr, SwingProcessImpl.this.buffer, SwingProcessImpl.this.config.getName(), true);
                    }
                    catch (Exception e) {
                        SwingProcessImpl.this.log.error("Failed to process process logs for application process " + SwingProcessImpl.this.config.getName(), (Throwable)e);
                        SwingProcessImpl.this.destroy();
                    }
                    if (!SwingProcessImpl.this.isRunning()) {
                        SwingProcessImpl.this.destroy();
                    }
                }
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    private boolean verifyBaseDir() {
        if (this.config.getBaseDir() == null || this.config.getBaseDir().isEmpty()) {
            return false;
        }
        File file = new File(this.config.getBaseDir());
        if (file.exists() && file.isDirectory() && file.canRead()) {
            return true;
        }
        String error = "";
        if (!file.exists()) {
            error = "Path does not exist.";
        } else if (!file.isDirectory()) {
            error = "Path is not a directory";
        } else if (!file.canRead()) {
            error = "Directory is not accessible";
        }
        throw new IllegalArgumentException("Failed to start application process with base dir:'" + this.config.getBaseDir() + "'. " + error);
    }

    public void destroy() {
        this.destroy(0);
    }

    @Override
    public void destroy(int delayMs) {
        if (delayMs > 0 && this.delayedTermination == null) {
            this.log.info("Waiting " + delayMs + "ms for app process " + this.config.getName() + " to end.");
            this.delayedTermination = this.processHandlerThread.schedule(new Runnable(){

                @Override
                public void run() {
                    SwingProcessImpl.this.destroy(0);
                }
            }, (long)delayMs, TimeUnit.MILLISECONDS);
        } else if (!this.destroying) {
            this.destroying = true;
            try {
                if (this.delayedTermination != null) {
                    this.delayedTermination.cancel(false);
                }
                this.destroyInternal();
            }
            finally {
                this.logsProcessor.cancel(false);
                this.log.info("[" + this.config.getName() + "] app process terminated. ");
                if (this.hasSessionLog) {
                    this.defaultLog.info("[" + this.config.getName() + "] app process terminated. ");
                }
                if (this.getCloseListener() != null) {
                    try {
                        this.getCloseListener().onClose();
                    }
                    catch (Exception e) {
                        this.log.error("Failed to call onClose on " + this.getCloseListener());
                    }
                }
                if (this.hasSessionLog) {
                    this.log.getAppenders().values().forEach(appender -> appender.stop());
                }
                this.destroying = false;
            }
        }
    }

    private void destroyInternal() {
        if (this.isRunning()) {
            this.log.info("Killing Application process " + this.config.getName() + ".");
            this.process.destroy();
            this.forceKilled = true;
        }
    }

    @Override
    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private String[] buildCommandline() throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.config.getJreExecutable() == null || this.config.getJreExecutable().isEmpty()) {
            throw new IllegalArgumentException("JRE executable cannot be empty. Please specify JRE.");
        }
        this.translateAndAdd(cmd, this.config.getJreExecutable(), "jreExecutable");
        if (this.config.getJvmArgs() != null) {
            this.translateAndAdd(cmd, this.config.getJvmArgs(), "jvmArgs");
        }
        if (this.config.getProperties().size() > 0) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                String property = "-D" + entry.getKey();
                String value = entry.getValue();
                if (value != null && !value.isEmpty()) {
                    property = property + "=" + value;
                }
                cmd.add(property);
            }
        }
        if (this.config.getClassPath() != null) {
            cmd.add("-cp");
            cmd.add(this.config.getClassPath());
        }
        if (this.config.getMainClass() != null) {
            cmd.add(this.config.getMainClass());
        }
        if (this.config.getArgs() != null) {
            this.translateAndAdd(cmd, this.config.getArgs(), "args");
        }
        return cmd.toArray(new String[cmd.size()]);
    }

    private void translateAndAdd(List<String> cmd, String args, String fieldName) throws Exception {
        try {
            for (String s : SwingProcessImpl.translateCommandline(args)) {
                cmd.add(s);
            }
        }
        catch (Exception e) {
            throw new Exception("Illegal value for '" + fieldName + "' field.", e);
        }
    }

    public static String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new Exception("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[result.size()]);
    }

    private void processStream(InputStream out, StringBuilder bufferOut, byte[] buffer, String name, boolean isError) throws IOException {
        long start = System.currentTimeMillis();
        boolean timeout = false;
        while (out.available() > 0 && !timeout) {
            int available = out.available();
            int read = out.read(buffer, 0, available > buffer.length ? buffer.length : available);
            bufferOut.append(new String(buffer, 0, read));
            while (bufferOut.indexOf("\n") >= 0) {
                int indexofNewLine = bufferOut.indexOf("\n");
                boolean isCR = indexofNewLine > 0 && bufferOut.charAt(indexofNewLine - 1) == '\r';
                String msg = "[" + name + "] " + bufferOut.subSequence(0, isCR ? indexofNewLine - 1 : indexofNewLine);
                if (isError) {
                    this.log.error(msg);
                } else {
                    this.log.info(msg);
                }
                bufferOut.delete(0, indexofNewLine + 1);
            }
            timeout = System.currentTimeMillis() - start > 100L;
        }
    }

    @Override
    public boolean isForceKilled() {
        return this.forceKilled;
    }

    public ProcessExitListener getCloseListener() {
        return this.closeListener;
    }

    @Override
    public void setProcessExitListener(ProcessExitListener closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public SwingProcessConfig getConfig() {
        return this.config;
    }
}

