/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.services.websocket.WebSocketMessageListener;

class WebSocketAtmosphereHandler
implements AtmosphereHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketAtmosphereHandler.class);
    private Map<String, WebSocketMessageListener> wsHandler = new HashMap<String, WebSocketMessageListener>();
    private Map<String, WebSocketConnection> connectionMap = new HashMap<String, WebSocketConnection>();

    public void addHandler(HttpServletRequest req, WebSocketMessageListener h) {
        this.wsHandler.put(req.getRequestURI(), h);
    }

    public void addHandler(String path, WebSocketMessageListener h) {
        this.wsHandler.put(path, h);
    }

    public void onReady(AtmosphereResource r) {
        this.findHandler(r).onReady(this.getConnection(r));
    }

    public void onDisconnect(AtmosphereResourceEvent event) {
        this.findHandler(event.getResource(), false).onDisconnect(this.getConnection(event));
    }

    public void onMessage(AtmosphereResource r, Object message) {
        this.findHandler(r).onMessage(this.getConnection(r), message);
    }

    public void onTimeout(AtmosphereResourceEvent event) {
        this.findHandler(event.getResource()).onTimeout(this.getConnection(event));
    }

    private WebSocketConnection getConnection(AtmosphereResourceEvent event) {
        WebSocketConnection c = this.getConnection(event.getResource());
        return c;
    }

    private WebSocketConnection getConnection(AtmosphereResource r) {
        WebSocketConnection result = null;
        if (this.connectionMap.containsKey(r.uuid())) {
            result = this.connectionMap.get(r.uuid());
        } else {
            result = new WebSocketConnection(r, this.findHandler(r, false).getOwner());
            this.connectionMap.put(r.uuid(), result);
        }
        return result;
    }

    private WebSocketMessageListener findHandler(AtmosphereResource r) {
        return this.findHandler(r, true);
    }

    private WebSocketMessageListener findHandler(AtmosphereResource r, boolean close) {
        WebSocketMessageListener h = this.wsHandler.get(r.getRequest().getRequestURI());
        try {
            if (h != null) {
                if (h.isReady()) {
                    return h;
                }
                if (!r.isCancelled() && close) {
                    r.close();
                }
            } else {
                log.error("No websocket handler found for URI " + r.getRequest().getRequestURI(), (Throwable)new IllegalStateException());
                if (!r.isCancelled() && close) {
                    r.close();
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to close websocket connection", (Throwable)e);
        }
        return new DummyWebSocketMessageListener();
    }

    public void destroy() {
    }

    public void onRequest(final AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String method = request.getMethod();
        boolean polling = Utils.pollableTransport((AtmosphereResource.TRANSPORT)resource.transport());
        boolean webSocketMessage = Utils.webSocketMessage((AtmosphereResource)resource);
        if (!webSocketMessage && !polling) {
            resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter.OnSuspend(){

                public void onSuspend(AtmosphereResourceEvent event) {
                    WebSocketAtmosphereHandler.this.onReady(event.getResource());
                    resource.removeEventListener((AtmosphereResourceEventListener)this);
                }
            });
            resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter.OnResume(){

                public void onResume(AtmosphereResourceEvent event) {
                    resource.removeEventListener((AtmosphereResourceEventListener)this);
                }
            });
            resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter.OnClose(){

                public void onClose(AtmosphereResourceEvent event) {
                    WebSocketAtmosphereHandler.this.onDisconnect(event);
                }
            });
        }
        if (method.equalsIgnoreCase("post")) {
            Object body = null;
            body = IOUtils.readEntirely((AtmosphereResource)resource);
            if (body != null && body instanceof String) {
                resource.getRequest().body((String)body);
            } else if (body != null) {
                resource.getRequest().body((byte[])body);
            }
            this.onMessage(resource, body);
        }
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        AtmosphereResource r = event.getResource();
        AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        if (event.isCancelled() || event.isClosedByClient()) {
            this.onDisconnect(event);
        } else if (event.isResumedOnTimeout() || event.isResuming()) {
            this.onTimeout(event);
        } else if (r.isSuspended()) {
            Object message = event.getMessage();
            boolean writeAsBytes = IOUtils.isBodyBinary((AtmosphereRequest)request);
            if (message instanceof List) {
                Iterator i = ((List)message).iterator();
                try {
                    while (i.hasNext()) {
                        Object s = i.next();
                        if (s instanceof String) {
                            response.getOutputStream().write(((String)s).getBytes(response.getCharacterEncoding()));
                        } else if (s instanceof byte[]) {
                            response.getOutputStream().write((byte[])s);
                        } else {
                            response.getOutputStream().write(s.toString().getBytes(response.getCharacterEncoding()));
                        }
                        i.remove();
                    }
                }
                catch (IOException ex) {
                    event.setMessage((Object)new ArrayList().addAll((List)message));
                    throw ex;
                }
                response.getOutputStream().flush();
            } else {
                response.getOutputStream().write(writeAsBytes ? (byte[])message : message.toString().getBytes(response.getCharacterEncoding()));
                response.getOutputStream().flush();
            }
            switch (r.transport()) {
                case JSONP: 
                case LONG_POLLING: {
                    r.resume();
                    break;
                }
            }
        }
    }

    public class DummyWebSocketMessageListener
    implements WebSocketMessageListener {
        @Override
        public void onReady(WebSocketConnection c) {
        }

        @Override
        public void onMessage(WebSocketConnection connection, Object message) {
        }

        @Override
        public void onDisconnect(WebSocketConnection connection) {
        }

        @Override
        public void onTimeout(WebSocketConnection connection) {
        }

        @Override
        public UrlHandler getOwner() {
            return null;
        }

        @Override
        public boolean isReady() {
            return false;
        }
    }
}

