/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security;

import java.io.Serializable;
import org.apache.shiro.authz.Permission;
import org.webswing.server.services.security.WebswingPrincipal;

public class WebswingPermission
implements Permission,
Serializable {
    private static final long serialVersionUID = 8721141086374586400L;
    private final String securedPath;
    private final String permissionName;

    public WebswingPermission(String securedPath, String permissionName) {
        this.securedPath = securedPath;
        this.permissionName = permissionName;
    }

    public String getSecuredPath() {
        return this.securedPath;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public boolean implies(Permission p) {
        if (this instanceof WebswingPrincipal) {
            WebswingPrincipal principal = (WebswingPrincipal)p;
            return principal.getSecuredPath().equals(this.securedPath) && principal.isPermitted(this.permissionName);
        }
        if (p instanceof WebswingPrincipal) {
            return p.implies((Permission)this);
        }
        return false;
    }
}

