/*
 Long.js (c) 2013 Daniel Wirtz <dcode@dcode.io>
 Released under the Apache License, Version 2.0
 see: https://github.com/dcodeIO/Long.js for details
*/

(function(){(function(e){function t(e,t,n){this.low=e|0,this.high=t|0,this.unsigned=!!n}t.isLong=function(e){return!0===(e&&e instanceof t)};var n={},r={};t.fromInt=function(e,i){var s;if(i){e>>>=0;if(0<=e&&256>e&&(s=r[e]))return s;s=new t(e,0>(e|0)?-1:0,!0),0<=e&&256>e&&(r[e]=s)}else{e|=0;if(-128<=e&&128>e&&(s=n[e]))return s;s=new t(e,0>e?-1:0,!1),-128<=e&&128>e&&(n[e]=s)}return s},t.fromNumber=function(e,n){return n=!!n,isNaN(e)||!isFinite(e)?t.ZERO:!n&&e<=-s?t.MIN_VALUE:!n&&e+1>=s?t.MAX_VALUE:n&&e>=i?t.MAX_UNSIGNED_VALUE:0>e?t.fromNumber(-e,n).negate():new t(e%4294967296|0,e/4294967296|0,n)},t.fromBits=function(e,n,r){return new t(e,n,r)},t.fromString=function(e,n,r){if(0===e.length)throw Error("number format error: empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return t.ZERO;"number"==typeof n&&(r=n,n=!1),r=r||10;if(2>r||36<r)throw Error("radix out of range: "+r);var i;if(0<(i=e.indexOf("-")))throw Error('number format error: interior "-" character: '+e);if(0===i)return t.fromString(e.substring(1),n,r).negate();i=t.fromNumber(Math.pow(r,8));for(var s=t.ZERO,o=0;o<e.length;o+=8){var u=Math.min(8,e.length-o),a=parseInt(e.substring(o,o+u),r);8>u?(u=t.fromNumber(Math.pow(r,u)),s=s.multiply(u).add(t.fromNumber(a))):(s=s.multiply(i),s=s.add(t.fromNumber(a)))}return s.unsigned=n,s},t.fromValue=function(e){return"number"==typeof e?t.fromNumber(e):"string"==typeof e?t.fromString(e):t.isLong(e)?e:new t(e.low,e.high,e.unsigned)};var i=0x10000000000000000,s=i/2,o=t.fromInt(16777216);t.ZERO=t.fromInt(0),t.UZERO=t.fromInt(0,!0),t.ONE=t.fromInt(1),t.UONE=t.fromInt(1,!0),t.NEG_ONE=t.fromInt(-1),t.MAX_VALUE=t.fromBits(-1,2147483647,!1),t.MAX_UNSIGNED_VALUE=t.fromBits(-1,-1,!0),t.MIN_VALUE=t.fromBits(0,-2147483648,!1),t.prototype.toInt=function(){return this.unsigned?this.low>>>0:this.low},t.prototype.toNumber=function(){return this.unsigned?4294967296*(this.high>>>0)+(this.low>>>0):4294967296*this.high+(this.low>>>0)},t.prototype.toString=function(e){e=e||10;if(2>e||36<e)throw RangeError("radix out of range: "+e);if(this.isZero())return"0";var n;if(this.isNegative()){if(this.equals(t.MIN_VALUE)){n=t.fromNumber(e);var r=this.div(n);return n=r.multiply(n).subtract(this),r.toString(e)+n.toInt().toString(e)}return"-"+this.negate().toString(e)}r=t.fromNumber(Math.pow(e,6),this.unsigned),n=this;for(var i="";;){var s=n.div(r),o=(n.subtract(s.multiply(r)).toInt()>>>0).toString(e);n=s;if(n.isZero())return o+i;for(;6>o.length;)o="0"+o;i=""+o+i}},t.prototype.getHighBits=function(){return this.high},t.prototype.getHighBitsUnsigned=function(){return this.high>>>0},t.prototype.getLowBits=function(){return this.low},t.prototype.getLowBitsUnsigned=function(){return this.low>>>0},t.prototype.getNumBitsAbs=function(){if(this.isNegative())return this.equals(t.MIN_VALUE)?64:this.negate().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,n=31;0<n&&0==(e&1<<n);n--);return 0!=this.high?n+33:n+1},t.prototype.isZero=function(){return 0===this.high&&0===this.low},t.prototype.isNegative=function(){return!this.unsigned&&0>this.high},t.prototype.isPositive=function(){return this.unsigned||0<=this.high},t.prototype.isOdd=function(){return 1===(this.low&1)},t.prototype.isEven=function(){return 0===(this.low&1)},t.prototype.equals=function(e){return t.isLong(e)||(e=t.fromValue(e)),this.unsigned!==e.unsigned&&1===this.high>>>31&&1===e.high>>>31?!1:this.high===e.high&&this.low===e.low},t.prototype.notEquals=function(e){return t.isLong(e)||(e=t.fromValue(e)),!this.equals(e)},t.prototype.lessThan=function(e){return t.isLong(e)||(e=t.fromValue(e)),0>this.compare(e)},t.prototype.lessThanOrEqual=function(e){return t.isLong(e)||(e=t.fromValue(e)),0>=this.compare(e)},t.prototype.greaterThan=function(e){return t.isLong(e)||(e=t.fromValue(e)),0<this.compare(e)},t.prototype.greaterThanOrEqual=function(e){return 0<=this.compare(e)},t.prototype.compare=function(e){if(this.equals(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.subtract(e).isNegative()?-1:1},t.prototype.negate=function(){return!this.unsigned&&this.equals(t.MIN_VALUE)?t.MIN_VALUE:this.not().add(t.ONE)},t.prototype.add=function(e){t.isLong(e)||(e=t.fromValue(e));var n=this.high>>>16,r=this.high&65535,i=this.low>>>16,s=e.high>>>16,o=e.high&65535,u=e.low>>>16,a;return a=0+((this.low&65535)+(e.low&65535)),e=0+(a>>>16),e+=i+u,i=0+(e>>>16),i+=r+o,r=0+(i>>>16),r=r+(n+s)&65535,t.fromBits((e&65535)<<16|a&65535,r<<16|i&65535,this.unsigned)},t.prototype.subtract=function(e){return t.isLong(e)||(e=t.fromValue(e)),this.add(e.negate())},t.prototype.multiply=function(e){if(this.isZero())return t.ZERO;t.isLong(e)||(e=t.fromValue(e));if(e.isZero())return t.ZERO;if(this.equals(t.MIN_VALUE))return e.isOdd()?t.MIN_VALUE:t.ZERO;if(e.equals(t.MIN_VALUE))return this.isOdd()?t.MIN_VALUE:t.ZERO;if(this.isNegative())return e.isNegative()?this.negate().multiply(e.negate()):this.negate().multiply(e).negate();if(e.isNegative())return this.multiply(e.negate()).negate();if(this.lessThan(o)&&e.lessThan(o))return t.fromNumber(this.toNumber()*e.toNumber(),this.unsigned);var n=this.high>>>16,r=this.high&65535,i=this.low>>>16,s=this.low&65535,u=e.high>>>16,a=e.high&65535,f=e.low>>>16;e=e.low&65535;var l,c,h,p;return p=0+s*e,h=0+(p>>>16),h+=i*e,c=0+(h>>>16),h=(h&65535)+s*f,c+=h>>>16,h&=65535,c+=r*e,l=0+(c>>>16),c=(c&65535)+i*f,l+=c>>>16,c&=65535,c+=s*a,l+=c>>>16,c&=65535,l=l+(n*e+r*f+i*a+s*u)&65535,t.fromBits(h<<16|p&65535,l<<16|c,this.unsigned)},t.prototype.div=function(e){t.isLong(e)||(e=t.fromValue(e));if(e.isZero())throw Error("division by zero");if(this.isZero())return this.unsigned?t.UZERO:t.ZERO;var n,r,i;if(this.equals(t.MIN_VALUE))return e.equals(t.ONE)||e.equals(t.NEG_ONE)?t.MIN_VALUE:e.equals(t.MIN_VALUE)?t.ONE:(n=this.shiftRight(1).div(e).shiftLeft(1),n.equals(t.ZERO)?e.isNegative()?t.ONE:t.NEG_ONE:(r=this.subtract(e.multiply(n)),i=n.add(r.div(e))));if(e.equals(t.MIN_VALUE))return this.unsigned?t.UZERO:t.ZERO;if(this.isNegative())return e.isNegative()?this.negate().div(e.negate()):this.negate().div(e).negate();if(e.isNegative())return this.div(e.negate()).negate();i=t.ZERO;for(r=this;r.greaterThanOrEqual(e);){n=Math.max(1,Math.floor(r.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(n)/Math.LN2),s=48>=s?1:Math.pow(2,s-48),o=t.fromNumber(n),u=o.multiply(e);u.isNegative()||u.greaterThan(r);)n-=s,o=t.fromNumber(n,this.unsigned),u=o.multiply(e);o.isZero()&&(o=t.ONE),i=i.add(o),r=r.subtract(u)}return i},t.prototype.modulo=function(e){return t.isLong(e)||(e=t.fromValue(e)),this.subtract(this.div(e).multiply(e))},t.prototype.not=function(){return t.fromBits(~this.low,~this.high,this.unsigned)},t.prototype.and=function(e){return t.isLong(e)||(e=t.fromValue(e)),t.fromBits(this.low&e.low,this.high&e.high,this.unsigned)},t.prototype.or=function(e){return t.isLong(e)||(e=t.fromValue(e)),t.fromBits(this.low|e.low,this.high|e.high,this.unsigned)},t.prototype.xor=function(e){return t.isLong(e)||(e=t.fromValue(e)),t.fromBits(this.low^e.low,this.high^e.high,this.unsigned)},t.prototype.shiftLeft=function(e){return t.isLong(e)&&(e=e.toInt()),0===(e&=63)?this:32>e?t.fromBits(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):t.fromBits(0,this.low<<e-32,this.unsigned)},t.prototype.shiftRight=function(e){return t.isLong(e)&&(e=e.toInt()),0===(e&=63)?this:32>e?t.fromBits(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):t.fromBits(this.high>>e-32,0<=this.high?0:-1,this.unsigned)},t.prototype.shiftRightUnsigned=function(e){t.isLong(e)&&(e=e.toInt()),e&=63;if(0===e)return this;var n=this.high;return 32>e?t.fromBits(this.low>>>e|n<<32-e,n>>>e,this.unsigned):32===e?t.fromBits(n,0,this.unsigned):t.fromBits(n>>>e-32,0,this.unsigned)},t.prototype.toSigned=function(){return this.unsigned?new t(this.low,this.high,!1):this},t.prototype.toUnsigned=function(){return this.unsigned?this:new t(this.low,this.high,!0)},"function"==typeof require&&"object"==typeof module&&module&&"object"==typeof exports&&exports?module.exports=t:"function"==typeof webswingRequirejs.define&&webswingRequirejs.define.amd?webswingRequirejs.define([],function(){return t}):(e.dcodeIO=e.dcodeIO||{}).Long=t})(this)})();