/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.webswing.server.services.security.SecurableService;
import org.webswing.server.services.security.SecurityManagerService;

class SecuredAtmosphereFramework
extends AtmosphereFramework
implements SecurableService {
    private SecurityManagerService securityManager;

    public SecuredAtmosphereFramework(SecurityManagerService securityManager) {
        this.securityManager = securityManager;
    }

    public Action doCometSupport(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        return (Action)this.securityManager.secure(this, (HttpServletRequest)new AtmosphereRequestWrapper(req), (HttpServletResponse)res);
    }

    @Override
    public Object secureServe(HttpServletRequest req, HttpServletResponse res) throws Exception {
        return super.doCometSupport(((AtmosphereRequestWrapper)req).getOriginal(), (AtmosphereResponse)res);
    }

    static class AtmosphereRequestWrapper
    extends HttpServletRequestWrapper {
        private AtmosphereRequest original;

        public AtmosphereRequestWrapper(AtmosphereRequest original) {
            super((HttpServletRequest)original);
            this.original = original;
        }

        public Cookie[] getCookies() {
            Cookie[] cookies = null;
            try {
                cookies = super.getCookies();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cookies == null || cookies.length == 0) {
                String cookieHeader = this.getHeader("Cookie");
                cookies = AtmosphereRequestWrapper.parseCookieHeader(cookieHeader);
            }
            return cookies;
        }

        public AtmosphereRequest getOriginal() {
            return this.original;
        }

        public static Cookie[] parseCookieHeader(String header) {
            if (header == null || header.length() < 1) {
                return new Cookie[0];
            }
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            while (header.length() > 0) {
                int semicolon = header.indexOf(59);
                if (semicolon < 0) {
                    semicolon = header.length();
                }
                if (semicolon == 0) break;
                String token = header.substring(0, semicolon);
                header = semicolon < header.length() ? header.substring(semicolon + 1) : "";
                try {
                    int equals = token.indexOf(61);
                    if (equals <= 0) continue;
                    String name = token.substring(0, equals).trim();
                    String value = token.substring(equals + 1).trim();
                    cookies.add(new Cookie(name, value));
                }
                catch (Throwable throwable) {}
            }
            return cookies.toArray(new Cookie[cookies.size()]);
        }
    }
}

