/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgIn;
import org.webswing.model.c2s.UploadEventMsgIn;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.files.FileDescriptor;
import org.webswing.server.services.files.FileTransferHandler;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.util.ServerUtil;

public class FileTransferHandlerImpl
extends AbstractUrlHandler
implements FileTransferHandler {
    private static final Logger log = LoggerFactory.getLogger(FileTransferHandlerImpl.class);
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private final SwingInstanceManager manager;
    private Map<String, FileDescriptor> fileMap = new ConcurrentHashMap<String, FileDescriptor>();
    private ScheduledExecutorService validatorService = Executors.newSingleThreadScheduledExecutor();

    public FileTransferHandlerImpl(SwingInstanceManager parent) {
        super(parent);
        this.manager = parent;
    }

    @Override
    protected String getPath() {
        return "file";
    }

    @Override
    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        try {
            if (req.getMethod().equals("GET")) {
                this.handleDownload(req, res);
                return true;
            }
            if (req.getMethod().equals("POST")) {
                this.handleUpload(req, res);
                return true;
            }
            if (req.getMethod().equals("OPTIONS")) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("FileTransfer failed.", (Throwable)e);
            throw new WsException("Failed to process file transfer " + req.getMethod(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, WsException {
        FileDescriptor fd;
        String fileId = request.getParameter("id");
        String userId = this.getUser() != null ? this.getUser().getUserId() : "null";
        this.checkPermission(WebswingAction.file_download);
        if (!this.fileMap.containsKey(fileId) || this.fileMap.get((Object)fileId).file == null) {
            response.sendError(404);
            return;
        }
        if (!userId.equals(this.fileMap.get((Object)fileId).userId)) {
            response.sendError(403);
            return;
        }
        FileDescriptor fileDescriptor = fd = this.fileMap.get(fileId);
        synchronized (fileDescriptor) {
            if (fd.waitForFile) {
                try {
                    fd.wait(Long.getLong("webswing.fileServletWaitTimeout", 300000L));
                }
                catch (InterruptedException e) {
                    response.sendError(404);
                    fd.waitForFileTask.cancel(false);
                    return;
                }
            }
        }
        if (this.fileMap.get(fileId) == null || !this.fileMap.get((Object)fileId).file.exists()) {
            response.sendError(404);
            return;
        }
        File file = fd.file;
        response.reset();
        response.setBufferSize(10240);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Length", String.valueOf(file.length()));
        String encodedName = URLEncoder.encode(file.getName(), "UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + "\"; filename*=UTF-8\"" + encodedName + "\"");
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(file), 10240);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            this.close(output);
            this.close(input);
        }
        catch (Throwable throwable) {
            this.close(output);
            this.close(input);
            throw throwable;
        }
    }

    private void handleUpload(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException, WsException {
        block9: {
            this.checkPermission(WebswingAction.file_upload);
            try {
                String uuid = request.getParameter("uuid");
                if (uuid != null) {
                    SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByConnectionId(uuid);
                    if (instance != null) {
                        double maxMB = instance.getAppConfig().getUploadMaxSize();
                        long maxsize = (long)(maxMB * 1024.0 * 1024.0);
                        Part filePart = request.getPart("files[]");
                        String filename = this.getFilename(filePart);
                        if (maxsize > 0L && filePart.getSize() > maxsize) {
                            resp.setStatus(400);
                            resp.getWriter().write(String.format("File '%s' is too large. (Max. file size is %.1fMB)", filename, maxMB));
                        } else {
                            String tempDir = System.getProperty("webswing.tempDirPath");
                            String tempName = UUID.randomUUID().toString();
                            InputStream filecontent = filePart.getInputStream();
                            File f = new File(URI.create(tempDir + "/" + tempName));
                            FileOutputStream output = new FileOutputStream(f);
                            IOUtils.copy((InputStream)filecontent, (OutputStream)output);
                            output.close();
                            filecontent.close();
                            log.info("File " + filename + " uploaded (size:" + filePart.getSize() + ") to " + f.getAbsolutePath());
                            UploadEventMsgIn msg = new UploadEventMsgIn();
                            msg.setFileName(filename);
                            msg.setTempFileLocation(f.getAbsolutePath());
                            boolean sent = instance.sendToSwing(null, (MsgIn)msg);
                            if (!sent) {
                                log.error("Failed to send upload notification to app session. File:" + filename + " InstanceID:" + instance.getInstanceId());
                                f.delete();
                            } else {
                                resp.setContentType("application/json; charset=UTF-8");
                                resp.setCharacterEncoding("UTF-8");
                                resp.getWriter().write("{\"files\":[{\"name\":\"" + filename + "\"}]}");
                            }
                        }
                        break block9;
                    }
                    throw new Exception("Related App instance not found.(" + uuid + ")");
                }
                throw new Exception("UUID not specified in request");
            }
            catch (Exception e) {
                if (e.getCause() instanceof EOFException) {
                    log.warn("File upload canceled by user: " + e.getMessage());
                }
                resp.setStatus(500);
                resp.getWriter().write("Upload finished with error...");
                log.error("Error while uploading file: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void destroy() {
        this.validatorService.shutdownNow();
        super.destroy();
    }

    @Override
    public void init() {
        this.validatorService = Executors.newSingleThreadScheduledExecutor();
        super.init();
    }

    private void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getFilename(Part part) {
        for (String cd : part.getHeader("Content-Disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return filename.substring(filename.lastIndexOf(47) + 1).substring(filename.lastIndexOf(92) + 1);
        }
        return null;
    }

    @Override
    public boolean registerFile(File file, final String id, long validForTime, TimeUnit timeUnit, String validForUser, String instanceId, boolean temp, boolean waitForFile, String overwriteDetails) {
        final FileDescriptor fd = new FileDescriptor(file, validForUser);
        fd.temporary = temp;
        fd.waitForFile = waitForFile;
        fd.overwriteDetails = overwriteDetails;
        fd.instanceId = instanceId;
        if (this.notifyWaitingForSameFile(fd)) {
            return false;
        }
        this.fileMap.put(id, fd);
        if (validForTime > 0L) {
            ScheduledFuture<?> invalidateTask = this.validatorService.schedule(new Runnable(){

                @Override
                public void run() {
                    FileTransferHandlerImpl.this.fileMap.remove(id);
                    if (fd.temporary) {
                        fd.file.delete();
                    }
                }
            }, validForTime, timeUnit);
            fd.invalidateScheduleTask = invalidateTask;
        }
        if (waitForFile) {
            fd.waitForFileTask = this.validatorService.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileDescriptor fileDescriptor = fd;
                    synchronized (fileDescriptor) {
                        String details;
                        if (fd.file.exists() && !(details = fd.file.length() + "|" + fd.file.lastModified()).equals(fd.overwriteDetails)) {
                            if (details.equals(fd.lastFileAttributes)) {
                                if (!ServerUtil.isFileLocked(fd.file)) {
                                    fd.waitForFile = false;
                                    fd.notifyAll();
                                    fd.waitForFileTask.cancel(false);
                                }
                            } else {
                                fd.lastFileAttributes = details;
                            }
                        }
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyWaitingForSameFile(FileDescriptor newFd) {
        for (String id : this.fileMap.keySet()) {
            FileDescriptor fd = this.fileMap.get(id);
            if (!fd.instanceId.equals(newFd.instanceId) || !fd.userId.equals(newFd.userId) || !fd.file.equals(newFd.file) || !fd.waitForFile) continue;
            FileDescriptor fileDescriptor = fd;
            synchronized (fileDescriptor) {
                fd.waitForFile = false;
                fd.notifyAll();
                fd.waitForFileTask.cancel(false);
            }
            return true;
        }
        return false;
    }
}

