/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.base;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.model.admin.InstanceManagerStatus;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.ConfigUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingSecurityConfig;
import org.webswing.server.services.security.api.WebswingSecurityModule;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.util.SecurityUtil;
import org.webswing.server.util.ServerUtil;

public abstract class PrimaryUrlHandler
extends AbstractUrlHandler
implements SecuredPathHandler,
SecurityContext {
    private static final Logger log = LoggerFactory.getLogger(PrimaryUrlHandler.class);
    private static final String default_version = "unresolved";
    public static final String JAVASCRIPT_NLS_PREFIX = "/javascript/nls";
    protected final ConfigurationService configService;
    protected final SecurityModuleService securityModuleService;
    private SecuredPathConfig config;
    private WebswingSecurityModule securityModule;
    private boolean enabled = false;
    private InstanceManagerStatus status = new InstanceManagerStatus();
    protected VariableSubstitutor varSubs;

    public PrimaryUrlHandler(UrlHandler parent, SecurityModuleService securityModuleService, ConfigurationService configService) {
        super(parent);
        this.securityModuleService = securityModuleService;
        this.securityModule = securityModuleService.createNoAccess(null, this, null);
        this.configService = configService;
        this.varSubs = VariableSubstitutor.basic();
    }

    @Override
    public void init() {
        try {
            super.init();
            if (this.getConfig().isEnabled()) {
                this.initConfiguration();
            } else {
                this.disable();
            }
        }
        catch (Throwable e) {
            log.error("Failed to start '" + this.getPathMapping() + "'.", e);
            try {
                this.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setStatusError(e);
        }
    }

    public abstract List<SwingInstanceManager> getApplications();

    @Override
    public synchronized void initConfiguration() {
        this.status.setStatus(InstanceManagerStatus.Status.Starting);
        String path = StringUtils.isEmpty((CharSequence)this.getPathMapping()) ? "/" : this.getPathMapping();
        this.config = this.configService.getConfiguration(path);
        WebswingSecurityConfig securityConfig = this.getSecurityConfig();
        try {
            this.varSubs = VariableSubstitutor.forSwingApp((SecuredPathConfig)this.getConfig());
            if (!new File(this.getHome()).getAbsoluteFile().isDirectory()) {
                throw new WsInitException("Home Folder '" + new File(this.getHome()).getAbsolutePath() + "'does not exist!");
            }
            try {
                if (this.securityModule != null) {
                    this.securityModule.destroy();
                }
            }
            catch (Exception e) {
                log.error("Failed to destroy Security module for " + path + ".", (Throwable)e);
            }
            this.securityModule = this.securityModuleService.create(this, securityConfig);
            if (this.securityModule != null) {
                this.securityModule.init();
            }
            this.status.setStatus(InstanceManagerStatus.Status.Running);
            this.enabled = true;
        }
        catch (Exception e) {
            this.securityModule = this.securityModuleService.createNoAccess("login.configurationError", this, securityConfig);
            this.setStatusError(e);
        }
    }

    public synchronized void disable() {
        this.status.setStatus(InstanceManagerStatus.Status.Stopping);
        this.enabled = false;
        try {
            this.killAll();
            if (this.securityModule != null) {
                this.securityModule.destroy();
            }
        }
        finally {
            this.securityModule = this.securityModuleService.createNoAccess(null, this, null);
        }
        this.status.setStatus(InstanceManagerStatus.Status.Stopped);
    }

    protected void killAll() {
    }

    private void setStatusError(Throwable e) {
        this.status.setStatus(InstanceManagerStatus.Status.Error);
        this.status.setError(e.getMessage());
        StringWriter out = new StringWriter();
        PrintWriter stacktrace = new PrintWriter(out);
        e.printStackTrace(stacktrace);
        this.status.setErrorDetails(out.toString());
    }

    protected WebswingSecurityConfig getSecurityConfig() {
        return (WebswingSecurityConfig)this.getConfig().getValueAs("security", WebswingSecurityConfig.class);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.disable();
    }

    @Override
    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        this.handleCorsHeaders(req, res);
        if (this.isWrongUrlCase(req) || this.isRootPathWithoutSlash(req)) {
            try {
                String redirectUrl = this.getFullPathMapping() + (ServerUtil.getContextPath(this.getServletContext()) + PrimaryUrlHandler.toPath(req.getPathInfo())).substring(this.getFullPathMapping().length());
                redirectUrl = this.isRootPathWithoutSlash(req) ? redirectUrl + "/" : redirectUrl;
                String queryString = req.getQueryString() == null ? "" : "?" + req.getQueryString();
                ServerUtil.sendHttpRedirect(req, res, redirectUrl + queryString);
            }
            catch (IOException e) {
                log.error("Failed to redirect.", (Throwable)e);
            }
            return true;
        }
        return super.serve(req, res);
    }

    @Override
    public boolean isSubPath(String subpath, String path) {
        return CommonUtil.isSubPathIgnoreCase((String)subpath, (String)path);
    }

    private boolean isWrongUrlCase(HttpServletRequest req) {
        if (req.getPathInfo() == null) {
            return false;
        }
        String relevantUrlPart = PrimaryUrlHandler.toPath(req.getPathInfo()).substring(0, this.getPathMapping().length());
        boolean isWrongCase = !relevantUrlPart.equals(this.getPathMapping()) && relevantUrlPart.equalsIgnoreCase(this.getPathMapping());
        return isWrongCase;
    }

    private boolean isRootPathWithoutSlash(HttpServletRequest req) {
        boolean isRootPathWithoutSlash = (ServerUtil.getContextPath(this.getServletContext()) + req.getPathInfo()).equals(this.getFullPathMapping());
        return req.getPathInfo() == null || isRootPathWithoutSlash;
    }

    private void handleCorsHeaders(HttpServletRequest req, HttpServletResponse res) throws WsException {
        if (this.isOriginAllowed(req.getHeader("Origin"))) {
            if (req.getHeader("Origin") != null) {
                res.setHeader("Access-Control-Allow-Origin", req.getHeader("Origin"));
                res.setHeader("Access-Control-Allow-Credentials", "true");
                res.setHeader("Access-Control-Expose-Headers", "X-webswing-args, X-webswing-recording, X-Cache-Date, X-Atmosphere-tracking-id, X-Requested-With");
            }
            if ("OPTIONS".equals(req.getMethod())) {
                res.setHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST, DELETE");
                res.setHeader("Access-Control-Allow-Headers", "X-webswing-args, X-webswing-recording, X-Requested-With, Origin, Content-Type, Content-Range, Content-Disposition, Content-Description, X-Atmosphere-Framework, X-Cache-Date, X-Atmosphere-tracking-id, X-Atmosphere-Transport");
                res.setHeader("Access-Control-Max-Age", "-1");
            }
        }
    }

    public boolean isOriginAllowed(String header) {
        List allowedCorsOrigins = this.getConfig().getAllowedCorsOrigins();
        if (allowedCorsOrigins == null || allowedCorsOrigins.size() == 0) {
            return false;
        }
        for (String s : allowedCorsOrigins) {
            if (!s.trim().equals(header) && !s.trim().equals("*")) continue;
            return true;
        }
        return false;
    }

    public boolean isSameOrigin(HttpServletRequest req) {
        String origin = req.getHeader("Origin");
        String host = req.getHeader("X-Forwarded-Host");
        if (origin == null) {
            return true;
        }
        if (host == null) {
            host = req.getHeader("Host");
        }
        if (origin != null && host != null) {
            String originHost;
            String string = originHost = origin.indexOf("://") >= 0 ? origin.substring(origin.indexOf("://") + 3) : origin;
            if (StringUtils.equals((CharSequence)originHost, (CharSequence)host)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public SecuredPathConfig getConfig() {
        if (this.config == null || !this.enabled) {
            String path = StringUtils.isEmpty((CharSequence)this.getPathMapping()) ? "/" : this.getPathMapping();
            this.config = this.configService.getConfiguration(path);
        }
        return this.config;
    }

    public SwingConfig getSwingConfig() {
        if (this.getConfig().getSwingConfig() == null) {
            return (SwingConfig)ConfigUtil.instantiateConfig(null, SwingConfig.class, (Object[])new Object[0]);
        }
        return this.getConfig().getSwingConfig();
    }

    public InstanceManagerStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public WebswingSecurityModule get() {
        return this.securityModule;
    }

    public File resolveFile(String name) {
        String home = this.getHome();
        return CommonUtil.resolveFile((String)name, (String)home, (VariableSubstitutor)this.varSubs);
    }

    private String getHome() {
        return VariableSubstitutor.basic().replace(this.getConfig().getHomeDir());
    }

    public URL getWebResource(String resource) {
        String webFolderPath;
        if (PrimaryUrlHandler.toPath(resource).startsWith(JAVASCRIPT_NLS_PREFIX)) {
            String langs = this.getConfig().getLangFolder();
            File langsFolder = StringUtils.isEmpty((CharSequence)langs) ? null : this.resolveFile(langs);
            URL result = ServerUtil.getFileResource(PrimaryUrlHandler.toPath(resource).substring(JAVASCRIPT_NLS_PREFIX.length()), langsFolder);
            if (result != null) {
                return result;
            }
        }
        File webFolder = StringUtils.isEmpty((CharSequence)(webFolderPath = this.getConfig().getWebFolder())) ? null : this.resolveFile(webFolderPath);
        return ServerUtil.getWebResource(PrimaryUrlHandler.toPath(resource), this.getServletContext(), webFolder);
    }

    public String generateCsrfToken() {
        String token = (String)this.getFromSecuritySession("X-webswing-CSRFToken");
        if (token == null) {
            SecureRandom random = new SecureRandom();
            byte[] values = new byte[32];
            random.nextBytes(values);
            token = Base64.encodeBase64String((byte[])values);
            this.setToSecuritySession("X-webswing-CSRFToken", token);
        }
        return token;
    }

    public boolean validateCsrfToken(HttpServletRequest req) {
        String header;
        String token = (String)this.getFromSecuritySession("X-webswing-CSRFToken");
        return token != null && StringUtils.equals((CharSequence)(header = req.getParameter("X-webswing-CSRFToken")), (CharSequence)token);
    }

    public String replaceVariables(String string) {
        return this.varSubs.replace(string);
    }

    public Map<String, String> getVariableMap() {
        return this.varSubs.getVariableMap();
    }

    public Object getFromSecuritySession(String attributeName) {
        return SecurityUtil.getFromSecuritySession(attributeName);
    }

    public void setToSecuritySession(String attributeName, Object value) {
        SecurityUtil.setToSecuritySession(attributeName, value);
    }
}

