/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest;

import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.rest.RestUrlHandler;
import org.webswing.server.services.rest.RestUrlHandlerImpl;

public class RestUrlHandlerImpl
extends AbstractUrlHandler
implements Container,
RestUrlHandler {
    private static final Logger log = LoggerFactory.getLogger(RestUrlHandlerImpl.class);
    private ApplicationHandler appHandler;

    public RestUrlHandlerImpl(UrlHandler parent, AbstractBinder binder, Class ... resources) {
        super(parent);
        this.appHandler = new ApplicationHandler((Application)new RestConfiguration(this, binder, resources));
    }

    public boolean serve(HttpServletRequest request, HttpServletResponse response) throws WsException {
        URI requestUri;
        URI baseUri;
        UriBuilder absoluteUriBuilder;
        StringBuffer requestUrl = request.getRequestURL();
        String requestURI = request.getRequestURI();
        try {
            absoluteUriBuilder = UriBuilder.fromUri((String)requestUrl.toString());
        }
        catch (IllegalArgumentException iae) {
            log.warn("Rest request url [" + requestUrl.toString() + "] is invalid.", (Throwable)iae);
            return false;
        }
        String basePath = this.getFullPathMapping() + "/";
        try {
            baseUri = absoluteUriBuilder.replacePath(basePath).build(new Object[0]);
            String queryParameters = ContainerUtils.encodeUnsafeCharacters((String)request.getQueryString());
            if (queryParameters == null) {
                queryParameters = "";
            }
            requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(queryParameters).build(new Object[0]);
        }
        catch (IllegalArgumentException | UriBuilderException ex) {
            log.warn("Rest request url [" + requestURI.toString() + "] is invalid.", ex);
            return false;
        }
        try {
            ResponseWriter responseWriter = new ResponseWriter(this, response);
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), (PropertiesDelegate)new MapPropertiesDelegate());
            requestContext.setEntityStream((InputStream)request.getInputStream());
            this.addRequestHeaders(request, requestContext);
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            this.appHandler.handle(requestContext);
            return responseWriter.isServed();
        }
        catch (Exception e) {
            log.error("Rest API call failed.", (Throwable)e);
            throw new WsException(e.getMessage(), (Throwable)e);
        }
    }

    private SecurityContext getSecurityContext(HttpServletRequest request) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected String getPath() {
        return "";
    }

    public void init() {
        super.init();
    }

    public void destroy() {
        super.destroy();
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration);
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (value == null) continue;
                requestContext.header(name, (Object)value);
            }
        }
    }
}

