/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.model.admin.ApplicationInfo;
import org.webswing.server.common.model.admin.BasicApplicationInfo;
import org.webswing.server.common.model.admin.Manifest;
import org.webswing.server.common.model.admin.Sessions;
import org.webswing.server.common.model.admin.SwingSession;
import org.webswing.server.common.model.rest.LogResponse;
import org.webswing.server.common.model.rest.SessionLogRequest;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestService;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.util.LogReaderUtil;
import org.webswing.server.util.LoggerStatisticsUtil;

@Path(value="")
@Produces(value={"application/json"})
public class SwingAppRestService
extends BaseRestService {
    @Inject
    SwingInstanceManager manager;
    @Inject
    PrimaryUrlHandler handler;
    @Inject
    ConfigurationService configService;
    @Inject
    StatisticsLoggerService loggerService;

    protected List<ApplicationInfoMsg> getAppsImpl() {
        return Arrays.asList(this.manager.getApplicationInfoMsg());
    }

    protected ApplicationInfo getAppInfoImpl() {
        ApplicationInfo app = super.getAppInfoImpl();
        app.setName(this.handler.getSwingConfig().getName());
        List allRunning = this.manager.getSwingInstanceHolder().getAllInstances();
        app.setRunningInstances(allRunning.size());
        int connected = 0;
        for (SwingInstance si : allRunning) {
            if (si.getConnectionId() == null) continue;
            ++connected;
        }
        app.setConnectedInstances(connected);
        app.setFinishedInstances(this.manager.getSwingInstanceHolder().getAllClosedInstances().size());
        int maxRunningInstances = this.handler.getSwingConfig().getMaxClients();
        app.setMaxRunningInstances(maxRunningInstances);
        app.setStats(this.manager.getStatsReader().getSummaryStats());
        app.setWarnings(this.manager.getStatsReader().getSummaryWarnings());
        return app;
    }

    protected List<BasicApplicationInfo> getPathsImpl() {
        BasicApplicationInfo app = new BasicApplicationInfo();
        app.setPath(this.manager.getPathMapping());
        app.setUrl(this.manager.getFullPathMapping());
        app.setEnabled(this.manager.isEnabled());
        app.setName(this.handler.getSwingConfig().getName());
        List allRunning = this.manager.getSwingInstanceHolder().getAllInstances();
        app.setRunningInstances(allRunning.size());
        return Arrays.asList(app);
    }

    @GET
    @Path(value="/start")
    public Response start() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_startApp);
        if (!this.getHandler().isEnabled()) {
            this.getHandler().initConfiguration();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/stop")
    public Response stop() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_stopApp);
        if (this.getHandler().isEnabled()) {
            this.getHandler().disable();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/appicon")
    @Produces(value={"image/png"})
    public Response appicon() throws WsException {
        CacheControl cc = new CacheControl();
        cc.setMaxAge(3600);
        cc.setPrivate(true);
        File icon = this.handler.resolveFile(this.handler.getConfig().getIcon());
        byte[] image = CommonUtil.loadImage((File)icon);
        return Response.ok((Object)image).cacheControl(cc).build();
    }

    @GET
    @Path(value="/rest/sessions")
    public Sessions getSessions() throws WsException {
        SwingSession session;
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
        HashSet<String> localRecordingFiles = new HashSet<String>();
        Sessions result = new Sessions();
        for (SwingInstance si : this.manager.getSwingInstanceHolder().getAllInstances()) {
            session = si.toSwingSession(false);
            result.getSessions().add(session);
            if (session.getRecordingFile() == null) continue;
            localRecordingFiles.add(session.getRecordingFile());
        }
        for (SwingInstance si : this.manager.getSwingInstanceHolder().getAllClosedInstances()) {
            session = si.toSwingSession(false);
            result.getClosedSessions().add(session);
            if (session.getRecordingFile() == null) continue;
            localRecordingFiles.add(session.getRecordingFile());
        }
        ArrayList<String> externalRecordings = new ArrayList<String>();
        if (this.manager.getRecordingsDirPath() != null) {
            File recordingsDir = new File(URI.create(this.manager.getRecordingsDirPath()));
            if (recordingsDir.exists() && recordingsDir.isDirectory() && recordingsDir.canRead()) {
                for (File rFile : recordingsDir.listFiles()) {
                    if (localRecordingFiles.contains(rFile.getName())) continue;
                    externalRecordings.add(rFile.getName());
                }
            }
            result.setRecordings(externalRecordings);
        }
        return result;
    }

    @GET
    @Path(value="/rest/session/{id}")
    public SwingSession getSession(@PathParam(value="id") String id) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/metrics/{uuid}")
    public SwingSession getMetrics(@PathParam(value="uuid") String uuid) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.websocket_connect);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByConnectionId(uuid);
        if (instance != null && this.getHandler().getUser().getUserId().equals(instance.getUserId())) {
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/record/{id}")
    public SwingSession startRecording(@PathParam(value="id") String id) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_startRecording);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            if (instance.isRecording()) {
                instance.stopRecording();
            } else {
                instance.startRecording();
            }
            return instance.toSwingSession(true);
        }
        return null;
    }

    @GET
    @Path(value="/rest/threadDump/{path}")
    @Produces(value={"text/plain"})
    public String getThreadDump(@PathParam(value="path") String id, @QueryParam(value="id") String timestamp) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getThreadDump);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            return instance.getThreadDump(timestamp);
        }
        List instaces = this.manager.getSwingInstanceHolder().getAllClosedInstances();
        for (SwingInstance i : instaces) {
            String td;
            if (!id.equals(i.getInstanceId()) || (td = i.getThreadDump(timestamp)) == null) continue;
            return td;
        }
        throw new WsException("Not found", 404);
    }

    @POST
    @Path(value="/rest/threadDump/{path}")
    public void requestThreadDump(@PathParam(value="path") String id) throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_requestThreadDump);
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance != null) {
            instance.requestThreadDump();
        }
    }

    @DELETE
    @Path(value="/rest/session/{id}")
    public void shutdown(@PathParam(value="id") String id, @QueryParam(value="force") String forceKill) throws WsException {
        boolean force = Boolean.parseBoolean(forceKill);
        if (force) {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdown);
        } else {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdownForce);
        }
        SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
        if (instance == null) {
            throw new WsException("Instance with id " + id + " not found.");
        }
        instance.shutdown(force);
    }

    @POST
    @Path(value="/rest/logs/session")
    public LogResponse getLogs(SessionLogRequest request) throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
        if (StringUtils.isBlank((CharSequence)request.getInstanceId())) {
            return null;
        }
        return LogReaderUtil.readSessionLog((String)this.getAppInfo().getUrl(), (String)this.getSessionLogsDir(), (SessionLogRequest)request);
    }

    @GET
    @Path(value="/rest/logs/session")
    public Response downloadLog() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
        Response.ResponseBuilder builder = Response.ok((Object)LogReaderUtil.getZippedSessionLog((String)this.getSessionLogsDir(), (String)this.getAppInfo().getUrl()), (String)"application/octet-stream");
        builder.header("content-disposition", (Object)("attachment; filename = " + LogReaderUtil.normalizeForFileName((String)this.getAppInfo().getName()) + "_session_logs.zip"));
        return builder.build();
    }

    @GET
    @Path(value="/rest/logs/session/instanceIds")
    public List<String> getLogInstanceIds() throws WsException {
        this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
        return LogReaderUtil.readSessionLogInstanceIds((String)this.getSessionLogsDir(), (String)this.getAppInfo().getUrl());
    }

    private String getSessionLogsDir() {
        return LogReaderUtil.getSessionLogDir((VariableSubstitutor)VariableSubstitutor.forSwingApp((SecuredPathConfig)this.manager.getConfig()), (SwingConfig)this.manager.getConfig().getSwingConfig());
    }

    @GET
    @Path(value="/rest/stats")
    public Map<String, Map<Long, Number>> getStats() throws WsException {
        this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getStats);
        ArrayList allStats = new ArrayList(this.manager.getStatsReader().getAllInstanceStats());
        allStats.addAll(this.loggerService.getServerLogger().getAllInstanceStats());
        return LoggerStatisticsUtil.mergeSummaryInstanceStats(allStats);
    }

    @GET
    @Path(value="/manifest.json")
    @Produces(value={"application/json"})
    public Manifest manifest() throws WsException {
        SecuredPathConfig config = this.handler.getConfig();
        String color = "#FFFFFF";
        Manifest manifest = new Manifest();
        manifest.setName(config.getSwingConfig().getName());
        manifest.setShort_name(manifest.getName());
        manifest.setIcon(new Manifest.IconDef(this.getHandler().getFullPathMapping() + "/appicon", "256x256"));
        manifest.setStart_url(this.getHandler().getFullPathMapping());
        manifest.setScope(this.getHandler().getFullPathMapping());
        manifest.setBackground_color(color);
        manifest.setDisplay("fullscreen");
        manifest.setTheme_color(color);
        return manifest;
    }

    protected PrimaryUrlHandler getHandler() {
        return this.handler;
    }

    protected ConfigurationService getConfigService() {
        return this.configService;
    }
}

