/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security.modules;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.ConfigUtil;
import org.webswing.server.extension.ExtensionClassLoader;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.BuiltInModules;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingSecurityConfig;
import org.webswing.server.services.security.api.WebswingSecurityModule;
import org.webswing.server.services.security.api.WebswingSecurityModuleConfig;
import org.webswing.toolkit.util.ClasspathUtil;

public class SecurityModuleWrapper
implements WebswingSecurityModule {
    private static final Logger log = LoggerFactory.getLogger(SecurityModuleWrapper.class);
    private WebswingSecurityModule custom;
    private WebswingSecurityConfig config;
    private URLClassLoader customCL;
    private SecurityContext context;

    public SecurityModuleWrapper(SecurityContext context, WebswingSecurityConfig config) {
        this.context = context;
        this.config = config;
    }

    public void init() {
        try {
            String classPath = CommonUtil.generateClassPathString((Collection)this.config.getClassPath());
            classPath = this.context.replaceVariables(classPath);
            URL[] urls = ClasspathUtil.populateClassPath((String)classPath, (String)this.context.resolveFile(".").getAbsolutePath());
            this.customCL = new URLClassLoader(urls, (ClassLoader)new ExtensionClassLoader());
            String securityModuleClassName = BuiltInModules.getSecurityModuleClassName((String)this.config.getModule());
            Class<?> moduleClass = this.customCL.loadClass(securityModuleClassName);
            Constructor<?> defaultConstructor = null;
            Constructor<?> configConstructor = null;
            for (Constructor<?> constructor : moduleClass.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 1) {
                    if (!WebswingSecurityModuleConfig.class.isAssignableFrom(parameterTypes[0])) continue;
                    configConstructor = constructor;
                    break;
                }
                if (parameterTypes.length != 0) continue;
                defaultConstructor = constructor;
            }
            WsInitException ex = null;
            if (configConstructor != null) {
                Class<?> configClass = configConstructor.getParameterTypes()[0];
                try {
                    this.custom = (WebswingSecurityModule)configConstructor.newInstance(ConfigUtil.instantiateConfig((Map)this.config.getConfig(), configClass, (Object[])new Object[]{this.context}));
                }
                catch (Exception e) {
                    ex = new WsInitException("Could not construct custom security module class (using WebswingSecurityModuleConfig constructor).", (Throwable)e);
                    log.error("Initialization failed.", (Throwable)ex);
                }
            }
            if (this.custom == null && defaultConstructor != null) {
                try {
                    this.custom = (WebswingSecurityModule)defaultConstructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    ex = new WsInitException("Could not construct custom security module class (using Default constructor).", (Throwable)e);
                    log.error("Initialization failed.", (Throwable)ex);
                }
            }
            if (this.custom == null) {
                log.error("Custom security module class should define a default or WebswingSecurityModuleConfig constructor!");
                throw ex;
            }
            this.runWithContextClassLoader((Callable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error("Failed to initialize security module. ", (Throwable)e);
            throw new RuntimeException("Failed to initialize Secuirty module.", e);
        }
    }

    public AbstractWebswingUser doLogin(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.custom != null) {
            AbstractWebswingUser user;
            try {
                user = (AbstractWebswingUser)this.runWithContextClassLoader((Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e1) {
                if (e1 instanceof ServletException) {
                    throw (ServletException)e1;
                }
                if (e1 instanceof IOException) {
                    throw (IOException)e1;
                }
                throw new IOException("Failed to get user. Unexpected exception", e1);
            }
            return user;
        }
        return null;
    }

    public void doLogout(HttpServletRequest req, HttpServletResponse res, AbstractWebswingUser user) {
        if (this.custom != null) {
            try {
                this.runWithContextClassLoader((Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e1) {
                log.error("Logout by SecurityModule failed.", (Throwable)e1);
            }
        }
    }

    public void doServeAuthenticated(AbstractWebswingUser user, String path, HttpServletRequest req, HttpServletResponse resp) {
        if (this.custom != null) {
            try {
                this.runWithContextClassLoader((Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e1) {
                log.error("Authenticated request processing by SecurityModule failed.", (Throwable)e1);
            }
        }
    }

    public void destroy() {
        if (this.custom != null) {
            try {
                this.runWithContextClassLoader((Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e1) {
                log.error("Destroying SecurityModule failed.", (Throwable)e1);
            }
        }
        if (this.customCL != null) {
            try {
                this.customCL.close();
            }
            catch (IOException e) {
                log.error("Closing Custom SecurityModule classloader failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithContextClassLoader(Callable<T> contextCallback) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.customCL);
            T t = contextCallback.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    static /* synthetic */ WebswingSecurityModule access$000(SecurityModuleWrapper x0) {
        return x0.custom;
    }
}

