/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgIn;
import org.webswing.model.MsgOut;
import org.webswing.model.c2s.ActionEventMsgIn;
import org.webswing.model.c2s.CopyEventMsgIn;
import org.webswing.model.c2s.FilesSelectedEventMsgIn;
import org.webswing.model.c2s.InputEventMsgIn;
import org.webswing.model.c2s.InputEventsFrameMsgIn;
import org.webswing.model.c2s.PasteEventMsgIn;
import org.webswing.model.c2s.PixelsAreaResponseMsgIn;
import org.webswing.model.c2s.WindowEventMsgIn;
import org.webswing.model.jslink.JavaEvalRequestMsgIn;
import org.webswing.model.jslink.JsResultMsg;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.model.s2c.SimpleEventMsgOut;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.EncodedMessage;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.services.websocket.WebSocketService;
import org.webswing.server.services.websocket.WebSocketUrlHandler;
import org.webswing.server.util.ServerUtil;

public class WebSocketUrlHandlerImpl
implements WebSocketUrlHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketUrlHandlerImpl.class);
    private final PrimaryUrlHandler parent;
    private final WebSocketService websocket;
    private final SwingInstanceManager instanceManager;
    private final String path;
    private boolean ready;

    public WebSocketUrlHandlerImpl(PrimaryUrlHandler parent, String path, WebSocketService websocket, SwingInstanceManager instanceManager) {
        this.parent = parent;
        this.path = path;
        this.websocket = websocket;
        this.instanceManager = instanceManager;
    }

    public void init() {
        this.ready = true;
    }

    public void destroy() {
        this.ready = false;
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        return this.serveDefault(req, res, this.parent, this.websocket, log);
    }

    public void onReady(WebSocketConnection r) {
        if (r.hasPermission(WebswingAction.websocket_connect)) {
            AppFrameMsgOut appInfo = new AppFrameMsgOut();
            ApplicationInfoMsg applicationInfoMsg = this.instanceManager.getApplicationInfoMsg();
            if (applicationInfoMsg != null) {
                appInfo.setApplications(Arrays.asList(applicationInfoMsg));
            }
            appInfo.setSessionId(r.uuid());
            EncodedMessage encoded = new EncodedMessage((MsgOut)appInfo);
            if (r.isBinary()) {
                r.write(encoded.getProtoMessage());
            } else {
                r.write(encoded.getJsonMessage());
            }
        } else {
            r.broadcastMessage((MsgOut)SimpleEventMsgOut.unauthorizedAccess.buildMsgOut());
            r.disconnect();
        }
    }

    public void onDisconnect(WebSocketConnection r) {
        SwingInstance instance = this.instanceManager.getSwingInstanceHolder().findInstanceByConnectionId(r.uuid());
        if (instance != null) {
            instance.webSessionDisconnected(r.uuid());
        }
    }

    public void onMessage(WebSocketConnection r, Object message) {
        try {
            int length = 0;
            Object decodedMessage = null;
            if (message instanceof String) {
                length = ((String)message).getBytes().length;
                decodedMessage = ServerUtil.decodeJson((String)((String)message));
            } else if (message instanceof byte[]) {
                length = ((byte[])message).length;
                decodedMessage = ServerUtil.decodeProto((byte[])((byte[])message));
            }
            if (decodedMessage != null && decodedMessage instanceof InputEventsFrameMsgIn) {
                InputEventsFrameMsgIn frame = (InputEventsFrameMsgIn)decodedMessage;
                if (frame.getEvents() != null && frame.getEvents().size() > 0) {
                    List evts = frame.getEvents();
                    for (InputEventMsgIn evt : evts) {
                        if (evt.getHandshake() != null) {
                            this.instanceManager.connectView(evt.getHandshake(), r);
                            continue;
                        }
                        if (evt.getKey() != null) {
                            this.send(r, (MsgIn)evt.getKey());
                            continue;
                        }
                        if (evt.getMouse() != null) {
                            this.send(r, (MsgIn)evt.getMouse());
                            continue;
                        }
                        if (evt.getEvent() != null) {
                            this.send(r, (MsgIn)evt.getEvent());
                            continue;
                        }
                        if (evt.getTimestamps() == null) continue;
                        this.send(r, (MsgIn)evt.getTimestamps());
                    }
                } else if (frame.getPaste() != null) {
                    PasteEventMsgIn p = frame.getPaste();
                    this.send(r, (MsgIn)p);
                } else if (frame.getCopy() != null) {
                    CopyEventMsgIn p = frame.getCopy();
                    this.send(r, (MsgIn)p);
                } else if (frame.getSelected() != null) {
                    FilesSelectedEventMsgIn p = frame.getSelected();
                    this.send(r, (MsgIn)p);
                } else if (frame.getJsResponse() != null) {
                    JsResultMsg p = frame.getJsResponse();
                    this.send(r, (MsgIn)p);
                } else if (frame.getJavaRequest() != null) {
                    JavaEvalRequestMsgIn p = frame.getJavaRequest();
                    this.send(r, (MsgIn)p);
                } else if (frame.getPixelsResponse() != null) {
                    PixelsAreaResponseMsgIn p = frame.getPixelsResponse();
                    this.send(r, (MsgIn)p);
                } else if (frame.getWindow() != null) {
                    WindowEventMsgIn w = frame.getWindow();
                    this.send(r, (MsgIn)w);
                } else if (frame.getAction() != null) {
                    ActionEventMsgIn a = frame.getAction();
                    this.send(r, (MsgIn)a);
                }
            } else {
                log.error("Unable to decode message: " + message);
            }
            SwingInstance instance = this.instanceManager.getSwingInstanceHolder().findInstanceByConnectionId(r.uuid());
            if (instance != null) {
                instance.logStatValue("inboundSize", (Number)length);
            }
        }
        catch (Exception e) {
            log.error("Exception while processing websocket message.", (Throwable)e);
        }
    }

    public void onTimeout(WebSocketConnection event) {
    }

    private void send(WebSocketConnection r, MsgIn o) {
        SwingInstance instance = this.instanceManager.getSwingInstanceHolder().findInstanceByConnectionId(r.uuid());
        if (instance != null) {
            instance.sendToSwing(r, o);
        }
    }

    public UrlHandler getOwner() {
        return this.parent;
    }

    public void registerFirstChildUrlHandler(UrlHandler handler) {
    }

    public void registerChildUrlHandler(UrlHandler handler) {
    }

    public void removeChildUrlHandler(UrlHandler Handler) {
    }

    public long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    public String getPathMapping() {
        return AbstractUrlHandler.toPath((String)this.path);
    }

    public String getFullPathMapping() {
        return this.parent.getFullPathMapping() + this.getPathMapping();
    }

    public String getSecuredPath() {
        return this.parent.getSecuredPath();
    }

    public UrlHandler getRootHandler() {
        return this.parent.getRootHandler();
    }

    public AbstractWebswingUser getUser() {
        return this.parent.getUser();
    }

    public void checkPermission(WebswingAction action) throws WsException {
        this.parent.checkPermission(action);
    }

    public SecuredPathHandler getSecurityProvider() {
        return this.parent.getSecurityProvider();
    }

    public ServletContext getServletContext() {
        return this.parent.getServletContext();
    }

    public void checkMasterPermission(WebswingAction action) throws WsException {
        this.parent.checkMasterPermission(action);
    }

    public boolean isReady() {
        return this.ready;
    }
}

